/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Segment type containing a list of detected issues.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeContactAnalysisSegmentIssues implements SdkPojo, Serializable,
        ToCopyableBuilder<RealTimeContactAnalysisSegmentIssues.Builder, RealTimeContactAnalysisSegmentIssues> {
    private static final SdkField<List<RealTimeContactAnalysisIssueDetected>> ISSUES_DETECTED_FIELD = SdkField
            .<List<RealTimeContactAnalysisIssueDetected>> builder(MarshallingType.LIST)
            .memberName("IssuesDetected")
            .getter(getter(RealTimeContactAnalysisSegmentIssues::issuesDetected))
            .setter(setter(Builder::issuesDetected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssuesDetected").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RealTimeContactAnalysisIssueDetected> builder(MarshallingType.SDK_POJO)
                                            .constructor(RealTimeContactAnalysisIssueDetected::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUES_DETECTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RealTimeContactAnalysisIssueDetected> issuesDetected;

    private RealTimeContactAnalysisSegmentIssues(BuilderImpl builder) {
        this.issuesDetected = builder.issuesDetected;
    }

    /**
     * For responses, this returns true if the service returned a value for the IssuesDetected property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIssuesDetected() {
        return issuesDetected != null && !(issuesDetected instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the issues detected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIssuesDetected} method.
     * </p>
     * 
     * @return List of the issues detected.
     */
    public final List<RealTimeContactAnalysisIssueDetected> issuesDetected() {
        return issuesDetected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIssuesDetected() ? issuesDetected() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisSegmentIssues)) {
            return false;
        }
        RealTimeContactAnalysisSegmentIssues other = (RealTimeContactAnalysisSegmentIssues) obj;
        return hasIssuesDetected() == other.hasIssuesDetected() && Objects.equals(issuesDetected(), other.issuesDetected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeContactAnalysisSegmentIssues")
                .add("IssuesDetected", hasIssuesDetected() ? issuesDetected() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IssuesDetected":
            return Optional.ofNullable(clazz.cast(issuesDetected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IssuesDetected", ISSUES_DETECTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisSegmentIssues, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisSegmentIssues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeContactAnalysisSegmentIssues> {
        /**
         * <p>
         * List of the issues detected.
         * </p>
         * 
         * @param issuesDetected
         *        List of the issues detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuesDetected(Collection<RealTimeContactAnalysisIssueDetected> issuesDetected);

        /**
         * <p>
         * List of the issues detected.
         * </p>
         * 
         * @param issuesDetected
         *        List of the issues detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuesDetected(RealTimeContactAnalysisIssueDetected... issuesDetected);

        /**
         * <p>
         * List of the issues detected.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisIssueDetected.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisIssueDetected#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisIssueDetected.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #issuesDetected(List<RealTimeContactAnalysisIssueDetected>)}.
         * 
         * @param issuesDetected
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisIssueDetected.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #issuesDetected(java.util.Collection<RealTimeContactAnalysisIssueDetected>)
         */
        Builder issuesDetected(Consumer<RealTimeContactAnalysisIssueDetected.Builder>... issuesDetected);
    }

    static final class BuilderImpl implements Builder {
        private List<RealTimeContactAnalysisIssueDetected> issuesDetected = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisSegmentIssues model) {
            issuesDetected(model.issuesDetected);
        }

        public final List<RealTimeContactAnalysisIssueDetected.Builder> getIssuesDetected() {
            List<RealTimeContactAnalysisIssueDetected.Builder> result = RealTimeContactAnalysisIssuesDetectedCopier
                    .copyToBuilder(this.issuesDetected);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIssuesDetected(Collection<RealTimeContactAnalysisIssueDetected.BuilderImpl> issuesDetected) {
            this.issuesDetected = RealTimeContactAnalysisIssuesDetectedCopier.copyFromBuilder(issuesDetected);
        }

        @Override
        public final Builder issuesDetected(Collection<RealTimeContactAnalysisIssueDetected> issuesDetected) {
            this.issuesDetected = RealTimeContactAnalysisIssuesDetectedCopier.copy(issuesDetected);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issuesDetected(RealTimeContactAnalysisIssueDetected... issuesDetected) {
            issuesDetected(Arrays.asList(issuesDetected));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issuesDetected(Consumer<RealTimeContactAnalysisIssueDetected.Builder>... issuesDetected) {
            issuesDetected(Stream.of(issuesDetected)
                    .map(c -> RealTimeContactAnalysisIssueDetected.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RealTimeContactAnalysisSegmentIssues build() {
            return new RealTimeContactAnalysisSegmentIssues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
