/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Transcript representation containing Id, Content and list of character intervals that are associated with analysis
 * data. For example, this object within an issue detected would describe both content that contains identified issue
 * and intervals where that content is taken from.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealTimeContactAnalysisTranscriptItemWithContent
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<RealTimeContactAnalysisTranscriptItemWithContent.Builder, RealTimeContactAnalysisTranscriptItemWithContent> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(RealTimeContactAnalysisTranscriptItemWithContent::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RealTimeContactAnalysisTranscriptItemWithContent::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<RealTimeContactAnalysisCharacterInterval> CHARACTER_OFFSETS_FIELD = SdkField
            .<RealTimeContactAnalysisCharacterInterval> builder(MarshallingType.SDK_POJO).memberName("CharacterOffsets")
            .getter(getter(RealTimeContactAnalysisTranscriptItemWithContent::characterOffsets))
            .setter(setter(Builder::characterOffsets)).constructor(RealTimeContactAnalysisCharacterInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterOffsets").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, ID_FIELD,
            CHARACTER_OFFSETS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String content;

    private final String id;

    private final RealTimeContactAnalysisCharacterInterval characterOffsets;

    private RealTimeContactAnalysisTranscriptItemWithContent(BuilderImpl builder) {
        this.content = builder.content;
        this.id = builder.id;
        this.characterOffsets = builder.characterOffsets;
    }

    /**
     * <p>
     * Part of the transcript content that contains identified issue. Can be redacted
     * </p>
     * 
     * @return Part of the transcript content that contains identified issue. Can be redacted
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * Transcript identifier. Matches the identifier from one of the TranscriptSegments.
     * </p>
     * 
     * @return Transcript identifier. Matches the identifier from one of the TranscriptSegments.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the CharacterOffsets property for this object.
     * 
     * @return The value of the CharacterOffsets property for this object.
     */
    public final RealTimeContactAnalysisCharacterInterval characterOffsets() {
        return characterOffsets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(characterOffsets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisTranscriptItemWithContent)) {
            return false;
        }
        RealTimeContactAnalysisTranscriptItemWithContent other = (RealTimeContactAnalysisTranscriptItemWithContent) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(id(), other.id())
                && Objects.equals(characterOffsets(), other.characterOffsets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealTimeContactAnalysisTranscriptItemWithContent").add("Content", content()).add("Id", id())
                .add("CharacterOffsets", characterOffsets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CharacterOffsets":
            return Optional.ofNullable(clazz.cast(characterOffsets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Content", CONTENT_FIELD);
        map.put("Id", ID_FIELD);
        map.put("CharacterOffsets", CHARACTER_OFFSETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisTranscriptItemWithContent, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisTranscriptItemWithContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealTimeContactAnalysisTranscriptItemWithContent> {
        /**
         * <p>
         * Part of the transcript content that contains identified issue. Can be redacted
         * </p>
         * 
         * @param content
         *        Part of the transcript content that contains identified issue. Can be redacted
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * Transcript identifier. Matches the identifier from one of the TranscriptSegments.
         * </p>
         * 
         * @param id
         *        Transcript identifier. Matches the identifier from one of the TranscriptSegments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the CharacterOffsets property for this object.
         *
         * @param characterOffsets
         *        The new value for the CharacterOffsets property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterOffsets(RealTimeContactAnalysisCharacterInterval characterOffsets);

        /**
         * Sets the value of the CharacterOffsets property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link RealTimeContactAnalysisCharacterInterval.Builder} avoiding the need to create one manually via
         * {@link RealTimeContactAnalysisCharacterInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeContactAnalysisCharacterInterval.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #characterOffsets(RealTimeContactAnalysisCharacterInterval)}.
         * 
         * @param characterOffsets
         *        a consumer that will call methods on {@link RealTimeContactAnalysisCharacterInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #characterOffsets(RealTimeContactAnalysisCharacterInterval)
         */
        default Builder characterOffsets(Consumer<RealTimeContactAnalysisCharacterInterval.Builder> characterOffsets) {
            return characterOffsets(RealTimeContactAnalysisCharacterInterval.builder().applyMutation(characterOffsets).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String id;

        private RealTimeContactAnalysisCharacterInterval characterOffsets;

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisTranscriptItemWithContent model) {
            content(model.content);
            id(model.id);
            characterOffsets(model.characterOffsets);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final RealTimeContactAnalysisCharacterInterval.Builder getCharacterOffsets() {
            return characterOffsets != null ? characterOffsets.toBuilder() : null;
        }

        public final void setCharacterOffsets(RealTimeContactAnalysisCharacterInterval.BuilderImpl characterOffsets) {
            this.characterOffsets = characterOffsets != null ? characterOffsets.build() : null;
        }

        @Override
        public final Builder characterOffsets(RealTimeContactAnalysisCharacterInterval characterOffsets) {
            this.characterOffsets = characterOffsets;
            return this;
        }

        @Override
        public RealTimeContactAnalysisTranscriptItemWithContent build() {
            return new RealTimeContactAnalysisTranscriptItemWithContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
