/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Well-formed data on a contact, used by agents to complete a contact request. You can have up to 4,096 UTF-8 bytes
 * across all references for a contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Reference implements SdkPojo, Serializable, ToCopyableBuilder<Reference.Builder, Reference> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Reference::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Reference::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Reference::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Reference::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(Reference::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD,
            STATUS_FIELD, ARN_FIELD, STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String type;

    private final String status;

    private final String arn;

    private final String statusReason;

    private Reference(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.status = builder.status;
        this.arn = builder.arn;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * A valid value for the reference. For example, for a URL reference, a formatted URL that is displayed to an agent
     * in the Contact Control Panel (CCP).
     * </p>
     * 
     * @return A valid value for the reference. For example, for a URL reference, a formatted URL that is displayed to
     *         an agent in the Contact Control Panel (CCP).
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The type of the reference. <code>DATE</code> must be of type Epoch timestamp.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the reference. <code>DATE</code> must be of type Epoch timestamp.
     * @see ReferenceType
     */
    public final ReferenceType type() {
        return ReferenceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the reference. <code>DATE</code> must be of type Epoch timestamp.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ReferenceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the reference. <code>DATE</code> must be of type Epoch timestamp.
     * @see ReferenceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Status of the attachment reference type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the attachment reference type.
     * @see ReferenceStatus
     */
    public final ReferenceStatus status() {
        return ReferenceStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the attachment reference type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the attachment reference type.
     * @see ReferenceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the reference
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the reference
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Relevant details why the reference was not successfully created.
     * </p>
     * 
     * @return Relevant details why the reference was not successfully created.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference other = (Reference) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Reference").add("Value", value()).add("Type", typeAsString()).add("Status", statusAsString())
                .add("Arn", arn()).add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Reference, T> g) {
        return obj -> g.apply((Reference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Reference> {
        /**
         * <p>
         * A valid value for the reference. For example, for a URL reference, a formatted URL that is displayed to an
         * agent in the Contact Control Panel (CCP).
         * </p>
         * 
         * @param value
         *        A valid value for the reference. For example, for a URL reference, a formatted URL that is displayed
         *        to an agent in the Contact Control Panel (CCP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The type of the reference. <code>DATE</code> must be of type Epoch timestamp.
         * </p>
         * 
         * @param type
         *        The type of the reference. <code>DATE</code> must be of type Epoch timestamp.
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the reference. <code>DATE</code> must be of type Epoch timestamp.
         * </p>
         * 
         * @param type
         *        The type of the reference. <code>DATE</code> must be of type Epoch timestamp.
         * @see ReferenceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceType
         */
        Builder type(ReferenceType type);

        /**
         * <p>
         * Status of the attachment reference type.
         * </p>
         * 
         * @param status
         *        Status of the attachment reference type.
         * @see ReferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the attachment reference type.
         * </p>
         * 
         * @param status
         *        Status of the attachment reference type.
         * @see ReferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceStatus
         */
        Builder status(ReferenceStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the reference
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the reference
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Relevant details why the reference was not successfully created.
         * </p>
         * 
         * @param statusReason
         *        Relevant details why the reference was not successfully created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String type;

        private String status;

        private String arn;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(Reference model) {
            value(model.value);
            type(model.type);
            status(model.status);
            arn(model.arn);
            statusReason(model.statusReason);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ReferenceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReferenceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public Reference build() {
            return new Reference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
