/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the action to be performed when a rule is triggered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleAction implements SdkPojo, Serializable, ToCopyableBuilder<RuleAction.Builder, RuleAction> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(RuleAction::actionTypeAsString)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<TaskActionDefinition> TASK_ACTION_FIELD = SdkField
            .<TaskActionDefinition> builder(MarshallingType.SDK_POJO).memberName("TaskAction")
            .getter(getter(RuleAction::taskAction)).setter(setter(Builder::taskAction))
            .constructor(TaskActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskAction").build()).build();

    private static final SdkField<EventBridgeActionDefinition> EVENT_BRIDGE_ACTION_FIELD = SdkField
            .<EventBridgeActionDefinition> builder(MarshallingType.SDK_POJO).memberName("EventBridgeAction")
            .getter(getter(RuleAction::eventBridgeAction)).setter(setter(Builder::eventBridgeAction))
            .constructor(EventBridgeActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeAction").build()).build();

    private static final SdkField<AssignContactCategoryActionDefinition> ASSIGN_CONTACT_CATEGORY_ACTION_FIELD = SdkField
            .<AssignContactCategoryActionDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("AssignContactCategoryAction")
            .getter(getter(RuleAction::assignContactCategoryAction))
            .setter(setter(Builder::assignContactCategoryAction))
            .constructor(AssignContactCategoryActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignContactCategoryAction")
                    .build()).build();

    private static final SdkField<SendNotificationActionDefinition> SEND_NOTIFICATION_ACTION_FIELD = SdkField
            .<SendNotificationActionDefinition> builder(MarshallingType.SDK_POJO).memberName("SendNotificationAction")
            .getter(getter(RuleAction::sendNotificationAction)).setter(setter(Builder::sendNotificationAction))
            .constructor(SendNotificationActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendNotificationAction").build())
            .build();

    private static final SdkField<CreateCaseActionDefinition> CREATE_CASE_ACTION_FIELD = SdkField
            .<CreateCaseActionDefinition> builder(MarshallingType.SDK_POJO).memberName("CreateCaseAction")
            .getter(getter(RuleAction::createCaseAction)).setter(setter(Builder::createCaseAction))
            .constructor(CreateCaseActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateCaseAction").build()).build();

    private static final SdkField<UpdateCaseActionDefinition> UPDATE_CASE_ACTION_FIELD = SdkField
            .<UpdateCaseActionDefinition> builder(MarshallingType.SDK_POJO).memberName("UpdateCaseAction")
            .getter(getter(RuleAction::updateCaseAction)).setter(setter(Builder::updateCaseAction))
            .constructor(UpdateCaseActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateCaseAction").build()).build();

    private static final SdkField<EndAssociatedTasksActionDefinition> END_ASSOCIATED_TASKS_ACTION_FIELD = SdkField
            .<EndAssociatedTasksActionDefinition> builder(MarshallingType.SDK_POJO).memberName("EndAssociatedTasksAction")
            .getter(getter(RuleAction::endAssociatedTasksAction)).setter(setter(Builder::endAssociatedTasksAction))
            .constructor(EndAssociatedTasksActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndAssociatedTasksAction").build())
            .build();

    private static final SdkField<SubmitAutoEvaluationActionDefinition> SUBMIT_AUTO_EVALUATION_ACTION_FIELD = SdkField
            .<SubmitAutoEvaluationActionDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("SubmitAutoEvaluationAction")
            .getter(getter(RuleAction::submitAutoEvaluationAction))
            .setter(setter(Builder::submitAutoEvaluationAction))
            .constructor(SubmitAutoEvaluationActionDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitAutoEvaluationAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD,
            TASK_ACTION_FIELD, EVENT_BRIDGE_ACTION_FIELD, ASSIGN_CONTACT_CATEGORY_ACTION_FIELD, SEND_NOTIFICATION_ACTION_FIELD,
            CREATE_CASE_ACTION_FIELD, UPDATE_CASE_ACTION_FIELD, END_ASSOCIATED_TASKS_ACTION_FIELD,
            SUBMIT_AUTO_EVALUATION_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String actionType;

    private final TaskActionDefinition taskAction;

    private final EventBridgeActionDefinition eventBridgeAction;

    private final AssignContactCategoryActionDefinition assignContactCategoryAction;

    private final SendNotificationActionDefinition sendNotificationAction;

    private final CreateCaseActionDefinition createCaseAction;

    private final UpdateCaseActionDefinition updateCaseAction;

    private final EndAssociatedTasksActionDefinition endAssociatedTasksAction;

    private final SubmitAutoEvaluationActionDefinition submitAutoEvaluationAction;

    private RuleAction(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.taskAction = builder.taskAction;
        this.eventBridgeAction = builder.eventBridgeAction;
        this.assignContactCategoryAction = builder.assignContactCategoryAction;
        this.sendNotificationAction = builder.sendNotificationAction;
        this.createCaseAction = builder.createCaseAction;
        this.updateCaseAction = builder.updateCaseAction;
        this.endAssociatedTasksAction = builder.endAssociatedTasksAction;
        this.submitAutoEvaluationAction = builder.submitAutoEvaluationAction;
    }

    /**
     * <p>
     * The type of action that creates a rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action that creates a rule.
     * @see ActionType
     */
    public final ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The type of action that creates a rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The type of action that creates a rule.
     * @see ActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * Information about the task action. This field is required if <code>TriggerEventSource</code> is one of the
     * following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> |
     * <code>OnSalesforceCaseCreate</code>
     * </p>
     * 
     * @return Information about the task action. This field is required if <code>TriggerEventSource</code> is one of
     *         the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> |
     *         <code>OnSalesforceCaseCreate</code>
     */
    public final TaskActionDefinition taskAction() {
        return taskAction;
    }

    /**
     * <p>
     * Information about the EventBridge action.
     * </p>
     * <p>
     * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
     * <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
     * <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> |
     * <code>OnMetricDataUpdate</code>
     * </p>
     * 
     * @return Information about the EventBridge action.</p>
     *         <p>
     *         Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
     *         <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
     *         <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> |
     *         <code>OnMetricDataUpdate</code>
     */
    public final EventBridgeActionDefinition eventBridgeAction() {
        return eventBridgeAction;
    }

    /**
     * <p>
     * Information about the contact category action.
     * </p>
     * <p>
     * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
     * <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
     * <code>OnPostChatAnalysisAvailable</code> | <code>OnZendeskTicketCreate</code> |
     * <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
     * </p>
     * 
     * @return Information about the contact category action.</p>
     *         <p>
     *         Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
     *         <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
     *         <code>OnPostChatAnalysisAvailable</code> | <code>OnZendeskTicketCreate</code> |
     *         <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
     */
    public final AssignContactCategoryActionDefinition assignContactCategoryAction() {
        return assignContactCategoryAction;
    }

    /**
     * <p>
     * Information about the send notification action.
     * </p>
     * <p>
     * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
     * <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
     * <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> |
     * <code>OnMetricDataUpdate</code>
     * </p>
     * 
     * @return Information about the send notification action.</p>
     *         <p>
     *         Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
     *         <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
     *         <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> |
     *         <code>OnMetricDataUpdate</code>
     */
    public final SendNotificationActionDefinition sendNotificationAction() {
        return sendNotificationAction;
    }

    /**
     * <p>
     * Information about the create case action.
     * </p>
     * <p>
     * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
     * <code>OnPostChatAnalysisAvailable</code>.
     * </p>
     * 
     * @return Information about the create case action.</p>
     *         <p>
     *         Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
     *         <code>OnPostChatAnalysisAvailable</code>.
     */
    public final CreateCaseActionDefinition createCaseAction() {
        return createCaseAction;
    }

    /**
     * <p>
     * Information about the update case action.
     * </p>
     * <p>
     * Supported only for <code>TriggerEventSource</code> values: <code>OnCaseCreate</code> | <code>OnCaseUpdate</code>.
     * </p>
     * 
     * @return Information about the update case action.</p>
     *         <p>
     *         Supported only for <code>TriggerEventSource</code> values: <code>OnCaseCreate</code> |
     *         <code>OnCaseUpdate</code>.
     */
    public final UpdateCaseActionDefinition updateCaseAction() {
        return updateCaseAction;
    }

    /**
     * <p>
     * Information about the end associated tasks action.
     * </p>
     * <p>
     * Supported only for <code>TriggerEventSource</code> values: <code>OnCaseUpdate</code>.
     * </p>
     * 
     * @return Information about the end associated tasks action.</p>
     *         <p>
     *         Supported only for <code>TriggerEventSource</code> values: <code>OnCaseUpdate</code>.
     */
    public final EndAssociatedTasksActionDefinition endAssociatedTasksAction() {
        return endAssociatedTasksAction;
    }

    /**
     * <p>
     * Information about the submit automated evaluation action.
     * </p>
     * 
     * @return Information about the submit automated evaluation action.
     */
    public final SubmitAutoEvaluationActionDefinition submitAutoEvaluationAction() {
        return submitAutoEvaluationAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(taskAction());
        hashCode = 31 * hashCode + Objects.hashCode(eventBridgeAction());
        hashCode = 31 * hashCode + Objects.hashCode(assignContactCategoryAction());
        hashCode = 31 * hashCode + Objects.hashCode(sendNotificationAction());
        hashCode = 31 * hashCode + Objects.hashCode(createCaseAction());
        hashCode = 31 * hashCode + Objects.hashCode(updateCaseAction());
        hashCode = 31 * hashCode + Objects.hashCode(endAssociatedTasksAction());
        hashCode = 31 * hashCode + Objects.hashCode(submitAutoEvaluationAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleAction)) {
            return false;
        }
        RuleAction other = (RuleAction) obj;
        return Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(taskAction(), other.taskAction())
                && Objects.equals(eventBridgeAction(), other.eventBridgeAction())
                && Objects.equals(assignContactCategoryAction(), other.assignContactCategoryAction())
                && Objects.equals(sendNotificationAction(), other.sendNotificationAction())
                && Objects.equals(createCaseAction(), other.createCaseAction())
                && Objects.equals(updateCaseAction(), other.updateCaseAction())
                && Objects.equals(endAssociatedTasksAction(), other.endAssociatedTasksAction())
                && Objects.equals(submitAutoEvaluationAction(), other.submitAutoEvaluationAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleAction").add("ActionType", actionTypeAsString()).add("TaskAction", taskAction())
                .add("EventBridgeAction", eventBridgeAction()).add("AssignContactCategoryAction", assignContactCategoryAction())
                .add("SendNotificationAction", sendNotificationAction()).add("CreateCaseAction", createCaseAction())
                .add("UpdateCaseAction", updateCaseAction()).add("EndAssociatedTasksAction", endAssociatedTasksAction())
                .add("SubmitAutoEvaluationAction", submitAutoEvaluationAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "TaskAction":
            return Optional.ofNullable(clazz.cast(taskAction()));
        case "EventBridgeAction":
            return Optional.ofNullable(clazz.cast(eventBridgeAction()));
        case "AssignContactCategoryAction":
            return Optional.ofNullable(clazz.cast(assignContactCategoryAction()));
        case "SendNotificationAction":
            return Optional.ofNullable(clazz.cast(sendNotificationAction()));
        case "CreateCaseAction":
            return Optional.ofNullable(clazz.cast(createCaseAction()));
        case "UpdateCaseAction":
            return Optional.ofNullable(clazz.cast(updateCaseAction()));
        case "EndAssociatedTasksAction":
            return Optional.ofNullable(clazz.cast(endAssociatedTasksAction()));
        case "SubmitAutoEvaluationAction":
            return Optional.ofNullable(clazz.cast(submitAutoEvaluationAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("TaskAction", TASK_ACTION_FIELD);
        map.put("EventBridgeAction", EVENT_BRIDGE_ACTION_FIELD);
        map.put("AssignContactCategoryAction", ASSIGN_CONTACT_CATEGORY_ACTION_FIELD);
        map.put("SendNotificationAction", SEND_NOTIFICATION_ACTION_FIELD);
        map.put("CreateCaseAction", CREATE_CASE_ACTION_FIELD);
        map.put("UpdateCaseAction", UPDATE_CASE_ACTION_FIELD);
        map.put("EndAssociatedTasksAction", END_ASSOCIATED_TASKS_ACTION_FIELD);
        map.put("SubmitAutoEvaluationAction", SUBMIT_AUTO_EVALUATION_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleAction, T> g) {
        return obj -> g.apply((RuleAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleAction> {
        /**
         * <p>
         * The type of action that creates a rule.
         * </p>
         * 
         * @param actionType
         *        The type of action that creates a rule.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The type of action that creates a rule.
         * </p>
         * 
         * @param actionType
         *        The type of action that creates a rule.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * Information about the task action. This field is required if <code>TriggerEventSource</code> is one of the
         * following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> |
         * <code>OnSalesforceCaseCreate</code>
         * </p>
         * 
         * @param taskAction
         *        Information about the task action. This field is required if <code>TriggerEventSource</code> is one of
         *        the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> |
         *        <code>OnSalesforceCaseCreate</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskAction(TaskActionDefinition taskAction);

        /**
         * <p>
         * Information about the task action. This field is required if <code>TriggerEventSource</code> is one of the
         * following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> |
         * <code>OnSalesforceCaseCreate</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskActionDefinition.Builder} avoiding
         * the need to create one manually via {@link TaskActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskActionDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #taskAction(TaskActionDefinition)}.
         * 
         * @param taskAction
         *        a consumer that will call methods on {@link TaskActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskAction(TaskActionDefinition)
         */
        default Builder taskAction(Consumer<TaskActionDefinition.Builder> taskAction) {
            return taskAction(TaskActionDefinition.builder().applyMutation(taskAction).build());
        }

        /**
         * <p>
         * Information about the EventBridge action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         * <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
         * <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> |
         * <code>OnMetricDataUpdate</code>
         * </p>
         * 
         * @param eventBridgeAction
         *        Information about the EventBridge action.</p>
         *        <p>
         *        Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         *        <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
         *        <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> |
         *        <code>OnMetricDataUpdate</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventBridgeAction(EventBridgeActionDefinition eventBridgeAction);

        /**
         * <p>
         * Information about the EventBridge action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         * <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
         * <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> |
         * <code>OnMetricDataUpdate</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link EventBridgeActionDefinition.Builder}
         * avoiding the need to create one manually via {@link EventBridgeActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventBridgeActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #eventBridgeAction(EventBridgeActionDefinition)}.
         * 
         * @param eventBridgeAction
         *        a consumer that will call methods on {@link EventBridgeActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventBridgeAction(EventBridgeActionDefinition)
         */
        default Builder eventBridgeAction(Consumer<EventBridgeActionDefinition.Builder> eventBridgeAction) {
            return eventBridgeAction(EventBridgeActionDefinition.builder().applyMutation(eventBridgeAction).build());
        }

        /**
         * <p>
         * Information about the contact category action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         * <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
         * <code>OnPostChatAnalysisAvailable</code> | <code>OnZendeskTicketCreate</code> |
         * <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
         * </p>
         * 
         * @param assignContactCategoryAction
         *        Information about the contact category action.</p>
         *        <p>
         *        Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         *        <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
         *        <code>OnPostChatAnalysisAvailable</code> | <code>OnZendeskTicketCreate</code> |
         *        <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignContactCategoryAction(AssignContactCategoryActionDefinition assignContactCategoryAction);

        /**
         * <p>
         * Information about the contact category action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         * <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
         * <code>OnPostChatAnalysisAvailable</code> | <code>OnZendeskTicketCreate</code> |
         * <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssignContactCategoryActionDefinition.Builder} avoiding the need to create one manually via
         * {@link AssignContactCategoryActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssignContactCategoryActionDefinition.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #assignContactCategoryAction(AssignContactCategoryActionDefinition)}.
         * 
         * @param assignContactCategoryAction
         *        a consumer that will call methods on {@link AssignContactCategoryActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assignContactCategoryAction(AssignContactCategoryActionDefinition)
         */
        default Builder assignContactCategoryAction(
                Consumer<AssignContactCategoryActionDefinition.Builder> assignContactCategoryAction) {
            return assignContactCategoryAction(AssignContactCategoryActionDefinition.builder()
                    .applyMutation(assignContactCategoryAction).build());
        }

        /**
         * <p>
         * Information about the send notification action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         * <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
         * <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> |
         * <code>OnMetricDataUpdate</code>
         * </p>
         * 
         * @param sendNotificationAction
         *        Information about the send notification action.</p>
         *        <p>
         *        Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         *        <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
         *        <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> |
         *        <code>OnMetricDataUpdate</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendNotificationAction(SendNotificationActionDefinition sendNotificationAction);

        /**
         * <p>
         * Information about the send notification action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         * <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> |
         * <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> |
         * <code>OnMetricDataUpdate</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link SendNotificationActionDefinition.Builder}
         * avoiding the need to create one manually via {@link SendNotificationActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SendNotificationActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #sendNotificationAction(SendNotificationActionDefinition)}.
         * 
         * @param sendNotificationAction
         *        a consumer that will call methods on {@link SendNotificationActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sendNotificationAction(SendNotificationActionDefinition)
         */
        default Builder sendNotificationAction(Consumer<SendNotificationActionDefinition.Builder> sendNotificationAction) {
            return sendNotificationAction(SendNotificationActionDefinition.builder().applyMutation(sendNotificationAction)
                    .build());
        }

        /**
         * <p>
         * Information about the create case action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         * <code>OnPostChatAnalysisAvailable</code>.
         * </p>
         * 
         * @param createCaseAction
         *        Information about the create case action.</p>
         *        <p>
         *        Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         *        <code>OnPostChatAnalysisAvailable</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createCaseAction(CreateCaseActionDefinition createCaseAction);

        /**
         * <p>
         * Information about the create case action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> |
         * <code>OnPostChatAnalysisAvailable</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateCaseActionDefinition.Builder}
         * avoiding the need to create one manually via {@link CreateCaseActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateCaseActionDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #createCaseAction(CreateCaseActionDefinition)}.
         * 
         * @param createCaseAction
         *        a consumer that will call methods on {@link CreateCaseActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createCaseAction(CreateCaseActionDefinition)
         */
        default Builder createCaseAction(Consumer<CreateCaseActionDefinition.Builder> createCaseAction) {
            return createCaseAction(CreateCaseActionDefinition.builder().applyMutation(createCaseAction).build());
        }

        /**
         * <p>
         * Information about the update case action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnCaseCreate</code> |
         * <code>OnCaseUpdate</code>.
         * </p>
         * 
         * @param updateCaseAction
         *        Information about the update case action.</p>
         *        <p>
         *        Supported only for <code>TriggerEventSource</code> values: <code>OnCaseCreate</code> |
         *        <code>OnCaseUpdate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateCaseAction(UpdateCaseActionDefinition updateCaseAction);

        /**
         * <p>
         * Information about the update case action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnCaseCreate</code> |
         * <code>OnCaseUpdate</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateCaseActionDefinition.Builder}
         * avoiding the need to create one manually via {@link UpdateCaseActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateCaseActionDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #updateCaseAction(UpdateCaseActionDefinition)}.
         * 
         * @param updateCaseAction
         *        a consumer that will call methods on {@link UpdateCaseActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateCaseAction(UpdateCaseActionDefinition)
         */
        default Builder updateCaseAction(Consumer<UpdateCaseActionDefinition.Builder> updateCaseAction) {
            return updateCaseAction(UpdateCaseActionDefinition.builder().applyMutation(updateCaseAction).build());
        }

        /**
         * <p>
         * Information about the end associated tasks action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnCaseUpdate</code>.
         * </p>
         * 
         * @param endAssociatedTasksAction
         *        Information about the end associated tasks action.</p>
         *        <p>
         *        Supported only for <code>TriggerEventSource</code> values: <code>OnCaseUpdate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endAssociatedTasksAction(EndAssociatedTasksActionDefinition endAssociatedTasksAction);

        /**
         * <p>
         * Information about the end associated tasks action.
         * </p>
         * <p>
         * Supported only for <code>TriggerEventSource</code> values: <code>OnCaseUpdate</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EndAssociatedTasksActionDefinition.Builder} avoiding the need to create one manually via
         * {@link EndAssociatedTasksActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndAssociatedTasksActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #endAssociatedTasksAction(EndAssociatedTasksActionDefinition)}.
         * 
         * @param endAssociatedTasksAction
         *        a consumer that will call methods on {@link EndAssociatedTasksActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endAssociatedTasksAction(EndAssociatedTasksActionDefinition)
         */
        default Builder endAssociatedTasksAction(Consumer<EndAssociatedTasksActionDefinition.Builder> endAssociatedTasksAction) {
            return endAssociatedTasksAction(EndAssociatedTasksActionDefinition.builder().applyMutation(endAssociatedTasksAction)
                    .build());
        }

        /**
         * <p>
         * Information about the submit automated evaluation action.
         * </p>
         * 
         * @param submitAutoEvaluationAction
         *        Information about the submit automated evaluation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitAutoEvaluationAction(SubmitAutoEvaluationActionDefinition submitAutoEvaluationAction);

        /**
         * <p>
         * Information about the submit automated evaluation action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SubmitAutoEvaluationActionDefinition.Builder} avoiding the need to create one manually via
         * {@link SubmitAutoEvaluationActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubmitAutoEvaluationActionDefinition.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #submitAutoEvaluationAction(SubmitAutoEvaluationActionDefinition)}.
         * 
         * @param submitAutoEvaluationAction
         *        a consumer that will call methods on {@link SubmitAutoEvaluationActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #submitAutoEvaluationAction(SubmitAutoEvaluationActionDefinition)
         */
        default Builder submitAutoEvaluationAction(
                Consumer<SubmitAutoEvaluationActionDefinition.Builder> submitAutoEvaluationAction) {
            return submitAutoEvaluationAction(SubmitAutoEvaluationActionDefinition.builder()
                    .applyMutation(submitAutoEvaluationAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String actionType;

        private TaskActionDefinition taskAction;

        private EventBridgeActionDefinition eventBridgeAction;

        private AssignContactCategoryActionDefinition assignContactCategoryAction;

        private SendNotificationActionDefinition sendNotificationAction;

        private CreateCaseActionDefinition createCaseAction;

        private UpdateCaseActionDefinition updateCaseAction;

        private EndAssociatedTasksActionDefinition endAssociatedTasksAction;

        private SubmitAutoEvaluationActionDefinition submitAutoEvaluationAction;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleAction model) {
            actionType(model.actionType);
            taskAction(model.taskAction);
            eventBridgeAction(model.eventBridgeAction);
            assignContactCategoryAction(model.assignContactCategoryAction);
            sendNotificationAction(model.sendNotificationAction);
            createCaseAction(model.createCaseAction);
            updateCaseAction(model.updateCaseAction);
            endAssociatedTasksAction(model.endAssociatedTasksAction);
            submitAutoEvaluationAction(model.submitAutoEvaluationAction);
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final TaskActionDefinition.Builder getTaskAction() {
            return taskAction != null ? taskAction.toBuilder() : null;
        }

        public final void setTaskAction(TaskActionDefinition.BuilderImpl taskAction) {
            this.taskAction = taskAction != null ? taskAction.build() : null;
        }

        @Override
        public final Builder taskAction(TaskActionDefinition taskAction) {
            this.taskAction = taskAction;
            return this;
        }

        public final EventBridgeActionDefinition.Builder getEventBridgeAction() {
            return eventBridgeAction != null ? eventBridgeAction.toBuilder() : null;
        }

        public final void setEventBridgeAction(EventBridgeActionDefinition.BuilderImpl eventBridgeAction) {
            this.eventBridgeAction = eventBridgeAction != null ? eventBridgeAction.build() : null;
        }

        @Override
        public final Builder eventBridgeAction(EventBridgeActionDefinition eventBridgeAction) {
            this.eventBridgeAction = eventBridgeAction;
            return this;
        }

        public final AssignContactCategoryActionDefinition.Builder getAssignContactCategoryAction() {
            return assignContactCategoryAction != null ? assignContactCategoryAction.toBuilder() : null;
        }

        public final void setAssignContactCategoryAction(
                AssignContactCategoryActionDefinition.BuilderImpl assignContactCategoryAction) {
            this.assignContactCategoryAction = assignContactCategoryAction != null ? assignContactCategoryAction.build() : null;
        }

        @Override
        public final Builder assignContactCategoryAction(AssignContactCategoryActionDefinition assignContactCategoryAction) {
            this.assignContactCategoryAction = assignContactCategoryAction;
            return this;
        }

        public final SendNotificationActionDefinition.Builder getSendNotificationAction() {
            return sendNotificationAction != null ? sendNotificationAction.toBuilder() : null;
        }

        public final void setSendNotificationAction(SendNotificationActionDefinition.BuilderImpl sendNotificationAction) {
            this.sendNotificationAction = sendNotificationAction != null ? sendNotificationAction.build() : null;
        }

        @Override
        public final Builder sendNotificationAction(SendNotificationActionDefinition sendNotificationAction) {
            this.sendNotificationAction = sendNotificationAction;
            return this;
        }

        public final CreateCaseActionDefinition.Builder getCreateCaseAction() {
            return createCaseAction != null ? createCaseAction.toBuilder() : null;
        }

        public final void setCreateCaseAction(CreateCaseActionDefinition.BuilderImpl createCaseAction) {
            this.createCaseAction = createCaseAction != null ? createCaseAction.build() : null;
        }

        @Override
        public final Builder createCaseAction(CreateCaseActionDefinition createCaseAction) {
            this.createCaseAction = createCaseAction;
            return this;
        }

        public final UpdateCaseActionDefinition.Builder getUpdateCaseAction() {
            return updateCaseAction != null ? updateCaseAction.toBuilder() : null;
        }

        public final void setUpdateCaseAction(UpdateCaseActionDefinition.BuilderImpl updateCaseAction) {
            this.updateCaseAction = updateCaseAction != null ? updateCaseAction.build() : null;
        }

        @Override
        public final Builder updateCaseAction(UpdateCaseActionDefinition updateCaseAction) {
            this.updateCaseAction = updateCaseAction;
            return this;
        }

        public final EndAssociatedTasksActionDefinition.Builder getEndAssociatedTasksAction() {
            return endAssociatedTasksAction != null ? endAssociatedTasksAction.toBuilder() : null;
        }

        public final void setEndAssociatedTasksAction(EndAssociatedTasksActionDefinition.BuilderImpl endAssociatedTasksAction) {
            this.endAssociatedTasksAction = endAssociatedTasksAction != null ? endAssociatedTasksAction.build() : null;
        }

        @Override
        public final Builder endAssociatedTasksAction(EndAssociatedTasksActionDefinition endAssociatedTasksAction) {
            this.endAssociatedTasksAction = endAssociatedTasksAction;
            return this;
        }

        public final SubmitAutoEvaluationActionDefinition.Builder getSubmitAutoEvaluationAction() {
            return submitAutoEvaluationAction != null ? submitAutoEvaluationAction.toBuilder() : null;
        }

        public final void setSubmitAutoEvaluationAction(
                SubmitAutoEvaluationActionDefinition.BuilderImpl submitAutoEvaluationAction) {
            this.submitAutoEvaluationAction = submitAutoEvaluationAction != null ? submitAutoEvaluationAction.build() : null;
        }

        @Override
        public final Builder submitAutoEvaluationAction(SubmitAutoEvaluationActionDefinition submitAutoEvaluationAction) {
            this.submitAutoEvaluationAction = submitAutoEvaluationAction;
            return this;
        }

        @Override
        public RuleAction build() {
            return new RuleAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
