/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name of the event source. This field is required if <code>TriggerEventSource</code> is one of the following
 * values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> |
 * <code>OnSalesforceCaseCreate</code> | <code>OnContactEvaluationSubmit</code> | <code>OnMetricDataUpdate</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleTriggerEventSource implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleTriggerEventSource.Builder, RuleTriggerEventSource> {
    private static final SdkField<String> EVENT_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSourceName").getter(getter(RuleTriggerEventSource::eventSourceNameAsString))
            .setter(setter(Builder::eventSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceName").build()).build();

    private static final SdkField<String> INTEGRATION_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationAssociationId").getter(getter(RuleTriggerEventSource::integrationAssociationId))
            .setter(setter(Builder::integrationAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationAssociationId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCE_NAME_FIELD,
            INTEGRATION_ASSOCIATION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventSourceName;

    private final String integrationAssociationId;

    private RuleTriggerEventSource(BuilderImpl builder) {
        this.eventSourceName = builder.eventSourceName;
        this.integrationAssociationId = builder.integrationAssociationId;
    }

    /**
     * <p>
     * The name of the event source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSourceName}
     * will return {@link EventSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventSourceNameAsString}.
     * </p>
     * 
     * @return The name of the event source.
     * @see EventSourceName
     */
    public final EventSourceName eventSourceName() {
        return EventSourceName.fromValue(eventSourceName);
    }

    /**
     * <p>
     * The name of the event source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventSourceName}
     * will return {@link EventSourceName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventSourceNameAsString}.
     * </p>
     * 
     * @return The name of the event source.
     * @see EventSourceName
     */
    public final String eventSourceNameAsString() {
        return eventSourceName;
    }

    /**
     * <p>
     * The identifier for the integration association.
     * </p>
     * 
     * @return The identifier for the integration association.
     */
    public final String integrationAssociationId() {
        return integrationAssociationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(integrationAssociationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleTriggerEventSource)) {
            return false;
        }
        RuleTriggerEventSource other = (RuleTriggerEventSource) obj;
        return Objects.equals(eventSourceNameAsString(), other.eventSourceNameAsString())
                && Objects.equals(integrationAssociationId(), other.integrationAssociationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleTriggerEventSource").add("EventSourceName", eventSourceNameAsString())
                .add("IntegrationAssociationId", integrationAssociationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSourceName":
            return Optional.ofNullable(clazz.cast(eventSourceNameAsString()));
        case "IntegrationAssociationId":
            return Optional.ofNullable(clazz.cast(integrationAssociationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventSourceName", EVENT_SOURCE_NAME_FIELD);
        map.put("IntegrationAssociationId", INTEGRATION_ASSOCIATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleTriggerEventSource, T> g) {
        return obj -> g.apply((RuleTriggerEventSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleTriggerEventSource> {
        /**
         * <p>
         * The name of the event source.
         * </p>
         * 
         * @param eventSourceName
         *        The name of the event source.
         * @see EventSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceName
         */
        Builder eventSourceName(String eventSourceName);

        /**
         * <p>
         * The name of the event source.
         * </p>
         * 
         * @param eventSourceName
         *        The name of the event source.
         * @see EventSourceName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSourceName
         */
        Builder eventSourceName(EventSourceName eventSourceName);

        /**
         * <p>
         * The identifier for the integration association.
         * </p>
         * 
         * @param integrationAssociationId
         *        The identifier for the integration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationAssociationId(String integrationAssociationId);
    }

    static final class BuilderImpl implements Builder {
        private String eventSourceName;

        private String integrationAssociationId;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleTriggerEventSource model) {
            eventSourceName(model.eventSourceName);
            integrationAssociationId(model.integrationAssociationId);
        }

        public final String getEventSourceName() {
            return eventSourceName;
        }

        public final void setEventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
        }

        @Override
        public final Builder eventSourceName(String eventSourceName) {
            this.eventSourceName = eventSourceName;
            return this;
        }

        @Override
        public final Builder eventSourceName(EventSourceName eventSourceName) {
            this.eventSourceName(eventSourceName == null ? null : eventSourceName.toString());
            return this;
        }

        public final String getIntegrationAssociationId() {
            return integrationAssociationId;
        }

        public final void setIntegrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
        }

        @Override
        public final Builder integrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
            return this;
        }

        @Override
        public RuleTriggerEventSource build() {
            return new RuleTriggerEventSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
