/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResourceTagsRequest extends ConnectRequest implements
        ToCopyableBuilder<SearchResourceTagsRequest.Builder, SearchResourceTagsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SearchResourceTagsRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(SearchResourceTagsRequest::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchResourceTagsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(SearchResourceTagsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<ResourceTagsSearchCriteria> SEARCH_CRITERIA_FIELD = SdkField
            .<ResourceTagsSearchCriteria> builder(MarshallingType.SDK_POJO).memberName("SearchCriteria")
            .getter(getter(SearchResourceTagsRequest::searchCriteria)).setter(setter(Builder::searchCriteria))
            .constructor(ResourceTagsSearchCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            RESOURCE_TYPES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SEARCH_CRITERIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final List<String> resourceTypes;

    private final String nextToken;

    private final Integer maxResults;

    private final ResourceTagsSearchCriteria searchCriteria;

    private SearchResourceTagsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.resourceTypes = builder.resourceTypes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.searchCriteria = builder.searchCriteria;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the Amazon Resource Name (ARN) of
     * the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the Amazon Resource Name
     *         (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of resource types to be used to search tags from. If not provided or if any empty list is provided, this
     * API will search from all supported resource types.
     * </p>
     * <p class="title">
     * <b>Supported resource types</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * AGENT
     * </p>
     * </li>
     * <li>
     * <p>
     * ROUTING_PROFILE
     * </p>
     * </li>
     * <li>
     * <p>
     * STANDARD_QUEUE
     * </p>
     * </li>
     * <li>
     * <p>
     * SECURITY_PROFILE
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_HOURS
     * </p>
     * </li>
     * <li>
     * <p>
     * PROMPT
     * </p>
     * </li>
     * <li>
     * <p>
     * CONTACT_FLOW
     * </p>
     * </li>
     * <li>
     * <p>
     * FLOW_MODULE
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The list of resource types to be used to search tags from. If not provided or if any empty list is
     *         provided, this API will search from all supported resource types.</p>
     *         <p class="title">
     *         <b>Supported resource types</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AGENT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ROUTING_PROFILE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STANDARD_QUEUE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SECURITY_PROFILE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATING_HOURS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROMPT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONTACT_FLOW
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FLOW_MODULE
     *         </p>
     *         </li>
     */
    public final List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The search criteria to be used to return tags.
     * </p>
     * 
     * @return The search criteria to be used to return tags.
     */
    public final ResourceTagsSearchCriteria searchCriteria() {
        return searchCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(searchCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourceTagsRequest)) {
            return false;
        }
        SearchResourceTagsRequest other = (SearchResourceTagsRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypes(), other.resourceTypes()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(searchCriteria(), other.searchCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchResourceTagsRequest").add("InstanceId", instanceId())
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("SearchCriteria", searchCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SearchCriteria":
            return Optional.ofNullable(clazz.cast(searchCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ResourceTypes", RESOURCE_TYPES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("SearchCriteria", SEARCH_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchResourceTagsRequest, T> g) {
        return obj -> g.apply((SearchResourceTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchResourceTagsRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the Amazon Resource Name (ARN)
         * of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the Amazon Resource Name
         *        (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The list of resource types to be used to search tags from. If not provided or if any empty list is provided,
         * this API will search from all supported resource types.
         * </p>
         * <p class="title">
         * <b>Supported resource types</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * AGENT
         * </p>
         * </li>
         * <li>
         * <p>
         * ROUTING_PROFILE
         * </p>
         * </li>
         * <li>
         * <p>
         * STANDARD_QUEUE
         * </p>
         * </li>
         * <li>
         * <p>
         * SECURITY_PROFILE
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_HOURS
         * </p>
         * </li>
         * <li>
         * <p>
         * PROMPT
         * </p>
         * </li>
         * <li>
         * <p>
         * CONTACT_FLOW
         * </p>
         * </li>
         * <li>
         * <p>
         * FLOW_MODULE
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        The list of resource types to be used to search tags from. If not provided or if any empty list is
         *        provided, this API will search from all supported resource types.</p>
         *        <p class="title">
         *        <b>Supported resource types</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AGENT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ROUTING_PROFILE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STANDARD_QUEUE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SECURITY_PROFILE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_HOURS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROMPT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONTACT_FLOW
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLOW_MODULE
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * The list of resource types to be used to search tags from. If not provided or if any empty list is provided,
         * this API will search from all supported resource types.
         * </p>
         * <p class="title">
         * <b>Supported resource types</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * AGENT
         * </p>
         * </li>
         * <li>
         * <p>
         * ROUTING_PROFILE
         * </p>
         * </li>
         * <li>
         * <p>
         * STANDARD_QUEUE
         * </p>
         * </li>
         * <li>
         * <p>
         * SECURITY_PROFILE
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_HOURS
         * </p>
         * </li>
         * <li>
         * <p>
         * PROMPT
         * </p>
         * </li>
         * <li>
         * <p>
         * CONTACT_FLOW
         * </p>
         * </li>
         * <li>
         * <p>
         * FLOW_MODULE
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTypes
         *        The list of resource types to be used to search tags from. If not provided or if any empty list is
         *        provided, this API will search from all supported resource types.</p>
         *        <p class="title">
         *        <b>Supported resource types</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AGENT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ROUTING_PROFILE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STANDARD_QUEUE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SECURITY_PROFILE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_HOURS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROMPT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONTACT_FLOW
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FLOW_MODULE
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The search criteria to be used to return tags.
         * </p>
         * 
         * @param searchCriteria
         *        The search criteria to be used to return tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchCriteria(ResourceTagsSearchCriteria searchCriteria);

        /**
         * <p>
         * The search criteria to be used to return tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceTagsSearchCriteria.Builder}
         * avoiding the need to create one manually via {@link ResourceTagsSearchCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceTagsSearchCriteria.Builder#build()} is called immediately
         * and its result is passed to {@link #searchCriteria(ResourceTagsSearchCriteria)}.
         * 
         * @param searchCriteria
         *        a consumer that will call methods on {@link ResourceTagsSearchCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchCriteria(ResourceTagsSearchCriteria)
         */
        default Builder searchCriteria(Consumer<ResourceTagsSearchCriteria.Builder> searchCriteria) {
            return searchCriteria(ResourceTagsSearchCriteria.builder().applyMutation(searchCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private ResourceTagsSearchCriteria searchCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourceTagsRequest model) {
            super(model);
            instanceId(model.instanceId);
            resourceTypes(model.resourceTypes);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            searchCriteria(model.searchCriteria);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ResourceTagsSearchCriteria.Builder getSearchCriteria() {
            return searchCriteria != null ? searchCriteria.toBuilder() : null;
        }

        public final void setSearchCriteria(ResourceTagsSearchCriteria.BuilderImpl searchCriteria) {
            this.searchCriteria = searchCriteria != null ? searchCriteria.build() : null;
        }

        @Override
        public final Builder searchCriteria(ResourceTagsSearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchResourceTagsRequest build() {
            return new SearchResourceTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
