/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendChatIntegrationEventRequest extends ConnectRequest implements
        ToCopyableBuilder<SendChatIntegrationEventRequest.Builder, SendChatIntegrationEventRequest> {
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceId").getter(getter(SendChatIntegrationEventRequest::sourceId)).setter(setter(Builder::sourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceId").build()).build();

    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationId").getter(getter(SendChatIntegrationEventRequest::destinationId))
            .setter(setter(Builder::destinationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationId").build()).build();

    private static final SdkField<String> SUBTYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subtype")
            .getter(getter(SendChatIntegrationEventRequest::subtype)).setter(setter(Builder::subtype))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subtype").build()).build();

    private static final SdkField<ChatEvent> EVENT_FIELD = SdkField.<ChatEvent> builder(MarshallingType.SDK_POJO)
            .memberName("Event").getter(getter(SendChatIntegrationEventRequest::event)).setter(setter(Builder::event))
            .constructor(ChatEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()).build();

    private static final SdkField<NewSessionDetails> NEW_SESSION_DETAILS_FIELD = SdkField
            .<NewSessionDetails> builder(MarshallingType.SDK_POJO).memberName("NewSessionDetails")
            .getter(getter(SendChatIntegrationEventRequest::newSessionDetails)).setter(setter(Builder::newSessionDetails))
            .constructor(NewSessionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewSessionDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ID_FIELD,
            DESTINATION_ID_FIELD, SUBTYPE_FIELD, EVENT_FIELD, NEW_SESSION_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sourceId;

    private final String destinationId;

    private final String subtype;

    private final ChatEvent event;

    private final NewSessionDetails newSessionDetails;

    private SendChatIntegrationEventRequest(BuilderImpl builder) {
        super(builder);
        this.sourceId = builder.sourceId;
        this.destinationId = builder.destinationId;
        this.subtype = builder.subtype;
        this.event = builder.event;
        this.newSessionDetails = builder.newSessionDetails;
    }

    /**
     * <p>
     * External identifier of chat customer participant, used in part to uniquely identify a chat. For SMS, this is the
     * E164 phone number of the chat customer participant.
     * </p>
     * 
     * @return External identifier of chat customer participant, used in part to uniquely identify a chat. For SMS, this
     *         is the E164 phone number of the chat customer participant.
     */
    public final String sourceId() {
        return sourceId;
    }

    /**
     * <p>
     * Chat system identifier, used in part to uniquely identify chat. This is associated with the Amazon Connect
     * instance and flow to be used to start chats. For Server Migration Service, this is the phone number destination
     * of inbound Server Migration Service messages represented by an Amazon Web Services End User Messaging phone
     * number ARN.
     * </p>
     * 
     * @return Chat system identifier, used in part to uniquely identify chat. This is associated with the Amazon
     *         Connect instance and flow to be used to start chats. For Server Migration Service, this is the phone
     *         number destination of inbound Server Migration Service messages represented by an Amazon Web Services End
     *         User Messaging phone number ARN.
     */
    public final String destinationId() {
        return destinationId;
    }

    /**
     * <p>
     * Classification of a channel. This is used in part to uniquely identify chat.
     * </p>
     * <p>
     * Valid value: <code>["connect:sms", connect:"WhatsApp"]</code>
     * </p>
     * 
     * @return Classification of a channel. This is used in part to uniquely identify chat. </p>
     *         <p>
     *         Valid value: <code>["connect:sms", connect:"WhatsApp"]</code>
     */
    public final String subtype() {
        return subtype;
    }

    /**
     * <p>
     * Chat integration event payload
     * </p>
     * 
     * @return Chat integration event payload
     */
    public final ChatEvent event() {
        return event;
    }

    /**
     * <p>
     * Contact properties to apply when starting a new chat. If the integration event is handled with an existing chat,
     * this is ignored.
     * </p>
     * 
     * @return Contact properties to apply when starting a new chat. If the integration event is handled with an
     *         existing chat, this is ignored.
     */
    public final NewSessionDetails newSessionDetails() {
        return newSessionDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(subtype());
        hashCode = 31 * hashCode + Objects.hashCode(event());
        hashCode = 31 * hashCode + Objects.hashCode(newSessionDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendChatIntegrationEventRequest)) {
            return false;
        }
        SendChatIntegrationEventRequest other = (SendChatIntegrationEventRequest) obj;
        return Objects.equals(sourceId(), other.sourceId()) && Objects.equals(destinationId(), other.destinationId())
                && Objects.equals(subtype(), other.subtype()) && Objects.equals(event(), other.event())
                && Objects.equals(newSessionDetails(), other.newSessionDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendChatIntegrationEventRequest").add("SourceId", sourceId())
                .add("DestinationId", destinationId()).add("Subtype", subtype()).add("Event", event())
                .add("NewSessionDetails", newSessionDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceId":
            return Optional.ofNullable(clazz.cast(sourceId()));
        case "DestinationId":
            return Optional.ofNullable(clazz.cast(destinationId()));
        case "Subtype":
            return Optional.ofNullable(clazz.cast(subtype()));
        case "Event":
            return Optional.ofNullable(clazz.cast(event()));
        case "NewSessionDetails":
            return Optional.ofNullable(clazz.cast(newSessionDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceId", SOURCE_ID_FIELD);
        map.put("DestinationId", DESTINATION_ID_FIELD);
        map.put("Subtype", SUBTYPE_FIELD);
        map.put("Event", EVENT_FIELD);
        map.put("NewSessionDetails", NEW_SESSION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendChatIntegrationEventRequest, T> g) {
        return obj -> g.apply((SendChatIntegrationEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendChatIntegrationEventRequest> {
        /**
         * <p>
         * External identifier of chat customer participant, used in part to uniquely identify a chat. For SMS, this is
         * the E164 phone number of the chat customer participant.
         * </p>
         * 
         * @param sourceId
         *        External identifier of chat customer participant, used in part to uniquely identify a chat. For SMS,
         *        this is the E164 phone number of the chat customer participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceId(String sourceId);

        /**
         * <p>
         * Chat system identifier, used in part to uniquely identify chat. This is associated with the Amazon Connect
         * instance and flow to be used to start chats. For Server Migration Service, this is the phone number
         * destination of inbound Server Migration Service messages represented by an Amazon Web Services End User
         * Messaging phone number ARN.
         * </p>
         * 
         * @param destinationId
         *        Chat system identifier, used in part to uniquely identify chat. This is associated with the Amazon
         *        Connect instance and flow to be used to start chats. For Server Migration Service, this is the phone
         *        number destination of inbound Server Migration Service messages represented by an Amazon Web Services
         *        End User Messaging phone number ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationId(String destinationId);

        /**
         * <p>
         * Classification of a channel. This is used in part to uniquely identify chat.
         * </p>
         * <p>
         * Valid value: <code>["connect:sms", connect:"WhatsApp"]</code>
         * </p>
         * 
         * @param subtype
         *        Classification of a channel. This is used in part to uniquely identify chat. </p>
         *        <p>
         *        Valid value: <code>["connect:sms", connect:"WhatsApp"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subtype(String subtype);

        /**
         * <p>
         * Chat integration event payload
         * </p>
         * 
         * @param event
         *        Chat integration event payload
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(ChatEvent event);

        /**
         * <p>
         * Chat integration event payload
         * </p>
         * This is a convenience method that creates an instance of the {@link ChatEvent.Builder} avoiding the need to
         * create one manually via {@link ChatEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChatEvent.Builder#build()} is called immediately and its result
         * is passed to {@link #event(ChatEvent)}.
         * 
         * @param event
         *        a consumer that will call methods on {@link ChatEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #event(ChatEvent)
         */
        default Builder event(Consumer<ChatEvent.Builder> event) {
            return event(ChatEvent.builder().applyMutation(event).build());
        }

        /**
         * <p>
         * Contact properties to apply when starting a new chat. If the integration event is handled with an existing
         * chat, this is ignored.
         * </p>
         * 
         * @param newSessionDetails
         *        Contact properties to apply when starting a new chat. If the integration event is handled with an
         *        existing chat, this is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newSessionDetails(NewSessionDetails newSessionDetails);

        /**
         * <p>
         * Contact properties to apply when starting a new chat. If the integration event is handled with an existing
         * chat, this is ignored.
         * </p>
         * This is a convenience method that creates an instance of the {@link NewSessionDetails.Builder} avoiding the
         * need to create one manually via {@link NewSessionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NewSessionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #newSessionDetails(NewSessionDetails)}.
         * 
         * @param newSessionDetails
         *        a consumer that will call methods on {@link NewSessionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newSessionDetails(NewSessionDetails)
         */
        default Builder newSessionDetails(Consumer<NewSessionDetails.Builder> newSessionDetails) {
            return newSessionDetails(NewSessionDetails.builder().applyMutation(newSessionDetails).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String sourceId;

        private String destinationId;

        private String subtype;

        private ChatEvent event;

        private NewSessionDetails newSessionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(SendChatIntegrationEventRequest model) {
            super(model);
            sourceId(model.sourceId);
            destinationId(model.destinationId);
            subtype(model.subtype);
            event(model.event);
            newSessionDetails(model.newSessionDetails);
        }

        public final String getSourceId() {
            return sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getDestinationId() {
            return destinationId;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final String getSubtype() {
            return subtype;
        }

        public final void setSubtype(String subtype) {
            this.subtype = subtype;
        }

        @Override
        public final Builder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public final ChatEvent.Builder getEvent() {
            return event != null ? event.toBuilder() : null;
        }

        public final void setEvent(ChatEvent.BuilderImpl event) {
            this.event = event != null ? event.build() : null;
        }

        @Override
        public final Builder event(ChatEvent event) {
            this.event = event;
            return this;
        }

        public final NewSessionDetails.Builder getNewSessionDetails() {
            return newSessionDetails != null ? newSessionDetails.toBuilder() : null;
        }

        public final void setNewSessionDetails(NewSessionDetails.BuilderImpl newSessionDetails) {
            this.newSessionDetails = newSessionDetails != null ? newSessionDetails.build() : null;
        }

        @Override
        public final Builder newSessionDetails(NewSessionDetails newSessionDetails) {
            this.newSessionDetails = newSessionDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendChatIntegrationEventRequest build() {
            return new SendChatIntegrationEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
