/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the send notification action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendNotificationActionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<SendNotificationActionDefinition.Builder, SendNotificationActionDefinition> {
    private static final SdkField<String> DELIVERY_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryMethod").getter(getter(SendNotificationActionDefinition::deliveryMethodAsString))
            .setter(setter(Builder::deliveryMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryMethod").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(SendNotificationActionDefinition::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(SendNotificationActionDefinition::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(SendNotificationActionDefinition::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<NotificationRecipientType> RECIPIENT_FIELD = SdkField
            .<NotificationRecipientType> builder(MarshallingType.SDK_POJO).memberName("Recipient")
            .getter(getter(SendNotificationActionDefinition::recipient)).setter(setter(Builder::recipient))
            .constructor(NotificationRecipientType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recipient").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_METHOD_FIELD,
            SUBJECT_FIELD, CONTENT_FIELD, CONTENT_TYPE_FIELD, RECIPIENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deliveryMethod;

    private final String subject;

    private final String content;

    private final String contentType;

    private final NotificationRecipientType recipient;

    private SendNotificationActionDefinition(BuilderImpl builder) {
        this.deliveryMethod = builder.deliveryMethod;
        this.subject = builder.subject;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.recipient = builder.recipient;
    }

    /**
     * <p>
     * Notification delivery method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryMethod}
     * will return {@link NotificationDeliveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deliveryMethodAsString}.
     * </p>
     * 
     * @return Notification delivery method.
     * @see NotificationDeliveryType
     */
    public final NotificationDeliveryType deliveryMethod() {
        return NotificationDeliveryType.fromValue(deliveryMethod);
    }

    /**
     * <p>
     * Notification delivery method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryMethod}
     * will return {@link NotificationDeliveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deliveryMethodAsString}.
     * </p>
     * 
     * @return Notification delivery method.
     * @see NotificationDeliveryType
     */
    public final String deliveryMethodAsString() {
        return deliveryMethod;
    }

    /**
     * <p>
     * The subject of the email if the delivery method is <code>EMAIL</code>. Supports variable injection. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath
     * reference</a> in the <i>Amazon Connect Administrators Guide</i>.
     * </p>
     * 
     * @return The subject of the email if the delivery method is <code>EMAIL</code>. Supports variable injection. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html"
     *         >JSONPath reference</a> in the <i>Amazon Connect Administrators Guide</i>.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * Notification content. Supports variable injection. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath
     * reference</a> in the <i>Amazon Connect Administrators Guide</i>.
     * </p>
     * 
     * @return Notification content. Supports variable injection. For more information, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html"
     *         >JSONPath reference</a> in the <i>Amazon Connect Administrators Guide</i>.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * Content type format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link NotificationContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Content type format.
     * @see NotificationContentType
     */
    public final NotificationContentType contentType() {
        return NotificationContentType.fromValue(contentType);
    }

    /**
     * <p>
     * Content type format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link NotificationContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return Content type format.
     * @see NotificationContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * <p>
     * Notification recipient.
     * </p>
     * 
     * @return Notification recipient.
     */
    public final NotificationRecipientType recipient() {
        return recipient;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recipient());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendNotificationActionDefinition)) {
            return false;
        }
        SendNotificationActionDefinition other = (SendNotificationActionDefinition) obj;
        return Objects.equals(deliveryMethodAsString(), other.deliveryMethodAsString())
                && Objects.equals(subject(), other.subject()) && Objects.equals(content(), other.content())
                && Objects.equals(contentTypeAsString(), other.contentTypeAsString())
                && Objects.equals(recipient(), other.recipient());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendNotificationActionDefinition").add("DeliveryMethod", deliveryMethodAsString())
                .add("Subject", subject()).add("Content", content()).add("ContentType", contentTypeAsString())
                .add("Recipient", recipient()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryMethod":
            return Optional.ofNullable(clazz.cast(deliveryMethodAsString()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "Recipient":
            return Optional.ofNullable(clazz.cast(recipient()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeliveryMethod", DELIVERY_METHOD_FIELD);
        map.put("Subject", SUBJECT_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("Recipient", RECIPIENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendNotificationActionDefinition, T> g) {
        return obj -> g.apply((SendNotificationActionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SendNotificationActionDefinition> {
        /**
         * <p>
         * Notification delivery method.
         * </p>
         * 
         * @param deliveryMethod
         *        Notification delivery method.
         * @see NotificationDeliveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationDeliveryType
         */
        Builder deliveryMethod(String deliveryMethod);

        /**
         * <p>
         * Notification delivery method.
         * </p>
         * 
         * @param deliveryMethod
         *        Notification delivery method.
         * @see NotificationDeliveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationDeliveryType
         */
        Builder deliveryMethod(NotificationDeliveryType deliveryMethod);

        /**
         * <p>
         * The subject of the email if the delivery method is <code>EMAIL</code>. Supports variable injection. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath
         * reference</a> in the <i>Amazon Connect Administrators Guide</i>.
         * </p>
         * 
         * @param subject
         *        The subject of the email if the delivery method is <code>EMAIL</code>. Supports variable injection.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html"
         *        >JSONPath reference</a> in the <i>Amazon Connect Administrators Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * Notification content. Supports variable injection. For more information, see <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath
         * reference</a> in the <i>Amazon Connect Administrators Guide</i>.
         * </p>
         * 
         * @param content
         *        Notification content. Supports variable injection. For more information, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html"
         *        >JSONPath reference</a> in the <i>Amazon Connect Administrators Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * Content type format.
         * </p>
         * 
         * @param contentType
         *        Content type format.
         * @see NotificationContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Content type format.
         * </p>
         * 
         * @param contentType
         *        Content type format.
         * @see NotificationContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotificationContentType
         */
        Builder contentType(NotificationContentType contentType);

        /**
         * <p>
         * Notification recipient.
         * </p>
         * 
         * @param recipient
         *        Notification recipient.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipient(NotificationRecipientType recipient);

        /**
         * <p>
         * Notification recipient.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationRecipientType.Builder}
         * avoiding the need to create one manually via {@link NotificationRecipientType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationRecipientType.Builder#build()} is called immediately
         * and its result is passed to {@link #recipient(NotificationRecipientType)}.
         * 
         * @param recipient
         *        a consumer that will call methods on {@link NotificationRecipientType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipient(NotificationRecipientType)
         */
        default Builder recipient(Consumer<NotificationRecipientType.Builder> recipient) {
            return recipient(NotificationRecipientType.builder().applyMutation(recipient).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deliveryMethod;

        private String subject;

        private String content;

        private String contentType;

        private NotificationRecipientType recipient;

        private BuilderImpl() {
        }

        private BuilderImpl(SendNotificationActionDefinition model) {
            deliveryMethod(model.deliveryMethod);
            subject(model.subject);
            content(model.content);
            contentType(model.contentType);
            recipient(model.recipient);
        }

        public final String getDeliveryMethod() {
            return deliveryMethod;
        }

        public final void setDeliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
        }

        @Override
        public final Builder deliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        @Override
        public final Builder deliveryMethod(NotificationDeliveryType deliveryMethod) {
            this.deliveryMethod(deliveryMethod == null ? null : deliveryMethod.toString());
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(NotificationContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final NotificationRecipientType.Builder getRecipient() {
            return recipient != null ? recipient.toBuilder() : null;
        }

        public final void setRecipient(NotificationRecipientType.BuilderImpl recipient) {
            this.recipient = recipient != null ? recipient.build() : null;
        }

        @Override
        public final Builder recipient(NotificationRecipientType recipient) {
            this.recipient = recipient;
            return this;
        }

        @Override
        public SendNotificationActionDefinition build() {
            return new SendNotificationActionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
