/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAttachedFileUploadRequest extends ConnectRequest implements
        ToCopyableBuilder<StartAttachedFileUploadRequest.Builder, StartAttachedFileUploadRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartAttachedFileUploadRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StartAttachedFileUploadRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(StartAttachedFileUploadRequest::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()).build();

    private static final SdkField<Long> FILE_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FileSizeInBytes").getter(getter(StartAttachedFileUploadRequest::fileSizeInBytes))
            .setter(setter(Builder::fileSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSizeInBytes").build()).build();

    private static final SdkField<Integer> URL_EXPIRY_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UrlExpiryInSeconds").getter(getter(StartAttachedFileUploadRequest::urlExpiryInSeconds))
            .setter(setter(Builder::urlExpiryInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlExpiryInSeconds").build())
            .build();

    private static final SdkField<String> FILE_USE_CASE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileUseCaseType").getter(getter(StartAttachedFileUploadRequest::fileUseCaseTypeAsString))
            .setter(setter(Builder::fileUseCaseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileUseCaseType").build()).build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResourceArn").getter(getter(StartAttachedFileUploadRequest::associatedResourceArn))
            .setter(setter(Builder::associatedResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("associatedResourceArn").build())
            .build();

    private static final SdkField<CreatedByInfo> CREATED_BY_FIELD = SdkField.<CreatedByInfo> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(StartAttachedFileUploadRequest::createdBy)).setter(setter(Builder::createdBy))
            .constructor(CreatedByInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(StartAttachedFileUploadRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            INSTANCE_ID_FIELD, FILE_NAME_FIELD, FILE_SIZE_IN_BYTES_FIELD, URL_EXPIRY_IN_SECONDS_FIELD, FILE_USE_CASE_TYPE_FIELD,
            ASSOCIATED_RESOURCE_ARN_FIELD, CREATED_BY_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String instanceId;

    private final String fileName;

    private final Long fileSizeInBytes;

    private final Integer urlExpiryInSeconds;

    private final String fileUseCaseType;

    private final String associatedResourceArn;

    private final CreatedByInfo createdBy;

    private final Map<String, String> tags;

    private StartAttachedFileUploadRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.instanceId = builder.instanceId;
        this.fileName = builder.fileName;
        this.fileSizeInBytes = builder.fileSizeInBytes;
        this.urlExpiryInSeconds = builder.urlExpiryInSeconds;
        this.fileUseCaseType = builder.fileUseCaseType;
        this.associatedResourceArn = builder.associatedResourceArn;
        this.createdBy = builder.createdBy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The unique identifier of the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A case-sensitive name of the attached file being uploaded.
     * </p>
     * 
     * @return A case-sensitive name of the attached file being uploaded.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The size of the attached file in bytes.
     * </p>
     * 
     * @return The size of the attached file in bytes.
     */
    public final Long fileSizeInBytes() {
        return fileSizeInBytes;
    }

    /**
     * <p>
     * Optional override for the expiry of the pre-signed S3 URL in seconds. The default value is 300.
     * </p>
     * 
     * @return Optional override for the expiry of the pre-signed S3 URL in seconds. The default value is 300.
     */
    public final Integer urlExpiryInSeconds() {
        return urlExpiryInSeconds;
    }

    /**
     * <p>
     * The use case for the file.
     * </p>
     * <important>
     * <p>
     * Only <code>ATTACHMENTS</code> are supported.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileUseCaseType}
     * will return {@link FileUseCaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileUseCaseTypeAsString}.
     * </p>
     * 
     * @return The use case for the file.</p> <important>
     *         <p>
     *         Only <code>ATTACHMENTS</code> are supported.
     *         </p>
     * @see FileUseCaseType
     */
    public final FileUseCaseType fileUseCaseType() {
        return FileUseCaseType.fromValue(fileUseCaseType);
    }

    /**
     * <p>
     * The use case for the file.
     * </p>
     * <important>
     * <p>
     * Only <code>ATTACHMENTS</code> are supported.
     * </p>
     * </important>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileUseCaseType}
     * will return {@link FileUseCaseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileUseCaseTypeAsString}.
     * </p>
     * 
     * @return The use case for the file.</p> <important>
     *         <p>
     *         Only <code>ATTACHMENTS</code> are supported.
     *         </p>
     * @see FileUseCaseType
     */
    public final String fileUseCaseTypeAsString() {
        return fileUseCaseType;
    }

    /**
     * <p>
     * The resource to which the attached file is (being) uploaded to. The supported resources are <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/cases.html">Cases</a> and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html">Email</a>.
     * </p>
     * <note>
     * <p>
     * This value must be a valid ARN.
     * </p>
     * </note>
     * 
     * @return The resource to which the attached file is (being) uploaded to. The supported resources are <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/cases.html">Cases</a> and <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html">Email</a>.</p>
     *         <note>
     *         <p>
     *         This value must be a valid ARN.
     *         </p>
     */
    public final String associatedResourceArn() {
        return associatedResourceArn;
    }

    /**
     * <p>
     * Represents the identity that created the file.
     * </p>
     * 
     * @return Represents the identity that created the file.
     */
    public final CreatedByInfo createdBy() {
        return createdBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example,
     * <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example,
     *         <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(fileSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(urlExpiryInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(fileUseCaseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAttachedFileUploadRequest)) {
            return false;
        }
        StartAttachedFileUploadRequest other = (StartAttachedFileUploadRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(fileName(), other.fileName()) && Objects.equals(fileSizeInBytes(), other.fileSizeInBytes())
                && Objects.equals(urlExpiryInSeconds(), other.urlExpiryInSeconds())
                && Objects.equals(fileUseCaseTypeAsString(), other.fileUseCaseTypeAsString())
                && Objects.equals(associatedResourceArn(), other.associatedResourceArn())
                && Objects.equals(createdBy(), other.createdBy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAttachedFileUploadRequest").add("ClientToken", clientToken())
                .add("InstanceId", instanceId()).add("FileName", fileName()).add("FileSizeInBytes", fileSizeInBytes())
                .add("UrlExpiryInSeconds", urlExpiryInSeconds()).add("FileUseCaseType", fileUseCaseTypeAsString())
                .add("AssociatedResourceArn", associatedResourceArn()).add("CreatedBy", createdBy())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "FileSizeInBytes":
            return Optional.ofNullable(clazz.cast(fileSizeInBytes()));
        case "UrlExpiryInSeconds":
            return Optional.ofNullable(clazz.cast(urlExpiryInSeconds()));
        case "FileUseCaseType":
            return Optional.ofNullable(clazz.cast(fileUseCaseTypeAsString()));
        case "AssociatedResourceArn":
            return Optional.ofNullable(clazz.cast(associatedResourceArn()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("FileName", FILE_NAME_FIELD);
        map.put("FileSizeInBytes", FILE_SIZE_IN_BYTES_FIELD);
        map.put("UrlExpiryInSeconds", URL_EXPIRY_IN_SECONDS_FIELD);
        map.put("FileUseCaseType", FILE_USE_CASE_TYPE_FIELD);
        map.put("associatedResourceArn", ASSOCIATED_RESOURCE_ARN_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAttachedFileUploadRequest, T> g) {
        return obj -> g.apply((StartAttachedFileUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartAttachedFileUploadRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A case-sensitive name of the attached file being uploaded.
         * </p>
         * 
         * @param fileName
         *        A case-sensitive name of the attached file being uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The size of the attached file in bytes.
         * </p>
         * 
         * @param fileSizeInBytes
         *        The size of the attached file in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSizeInBytes(Long fileSizeInBytes);

        /**
         * <p>
         * Optional override for the expiry of the pre-signed S3 URL in seconds. The default value is 300.
         * </p>
         * 
         * @param urlExpiryInSeconds
         *        Optional override for the expiry of the pre-signed S3 URL in seconds. The default value is 300.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlExpiryInSeconds(Integer urlExpiryInSeconds);

        /**
         * <p>
         * The use case for the file.
         * </p>
         * <important>
         * <p>
         * Only <code>ATTACHMENTS</code> are supported.
         * </p>
         * </important>
         * 
         * @param fileUseCaseType
         *        The use case for the file.</p> <important>
         *        <p>
         *        Only <code>ATTACHMENTS</code> are supported.
         *        </p>
         * @see FileUseCaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileUseCaseType
         */
        Builder fileUseCaseType(String fileUseCaseType);

        /**
         * <p>
         * The use case for the file.
         * </p>
         * <important>
         * <p>
         * Only <code>ATTACHMENTS</code> are supported.
         * </p>
         * </important>
         * 
         * @param fileUseCaseType
         *        The use case for the file.</p> <important>
         *        <p>
         *        Only <code>ATTACHMENTS</code> are supported.
         *        </p>
         * @see FileUseCaseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileUseCaseType
         */
        Builder fileUseCaseType(FileUseCaseType fileUseCaseType);

        /**
         * <p>
         * The resource to which the attached file is (being) uploaded to. The supported resources are <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/cases.html">Cases</a> and <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html">Email</a>.
         * </p>
         * <note>
         * <p>
         * This value must be a valid ARN.
         * </p>
         * </note>
         * 
         * @param associatedResourceArn
         *        The resource to which the attached file is (being) uploaded to. The supported resources are <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/cases.html">Cases</a> and <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html">Email</a>.</p>
         *        <note>
         *        <p>
         *        This value must be a valid ARN.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceArn(String associatedResourceArn);

        /**
         * <p>
         * Represents the identity that created the file.
         * </p>
         * 
         * @param createdBy
         *        Represents the identity that created the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(CreatedByInfo createdBy);

        /**
         * <p>
         * Represents the identity that created the file.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreatedByInfo.Builder} avoiding the need
         * to create one manually via {@link CreatedByInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreatedByInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #createdBy(CreatedByInfo)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link CreatedByInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(CreatedByInfo)
         */
        default Builder createdBy(Consumer<CreatedByInfo.Builder> createdBy) {
            return createdBy(CreatedByInfo.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example,
         * <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example,
         *        <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String instanceId;

        private String fileName;

        private Long fileSizeInBytes;

        private Integer urlExpiryInSeconds;

        private String fileUseCaseType;

        private String associatedResourceArn;

        private CreatedByInfo createdBy;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartAttachedFileUploadRequest model) {
            super(model);
            clientToken(model.clientToken);
            instanceId(model.instanceId);
            fileName(model.fileName);
            fileSizeInBytes(model.fileSizeInBytes);
            urlExpiryInSeconds(model.urlExpiryInSeconds);
            fileUseCaseType(model.fileUseCaseType);
            associatedResourceArn(model.associatedResourceArn);
            createdBy(model.createdBy);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final Long getFileSizeInBytes() {
            return fileSizeInBytes;
        }

        public final void setFileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
        }

        @Override
        public final Builder fileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            return this;
        }

        public final Integer getUrlExpiryInSeconds() {
            return urlExpiryInSeconds;
        }

        public final void setUrlExpiryInSeconds(Integer urlExpiryInSeconds) {
            this.urlExpiryInSeconds = urlExpiryInSeconds;
        }

        @Override
        public final Builder urlExpiryInSeconds(Integer urlExpiryInSeconds) {
            this.urlExpiryInSeconds = urlExpiryInSeconds;
            return this;
        }

        public final String getFileUseCaseType() {
            return fileUseCaseType;
        }

        public final void setFileUseCaseType(String fileUseCaseType) {
            this.fileUseCaseType = fileUseCaseType;
        }

        @Override
        public final Builder fileUseCaseType(String fileUseCaseType) {
            this.fileUseCaseType = fileUseCaseType;
            return this;
        }

        @Override
        public final Builder fileUseCaseType(FileUseCaseType fileUseCaseType) {
            this.fileUseCaseType(fileUseCaseType == null ? null : fileUseCaseType.toString());
            return this;
        }

        public final String getAssociatedResourceArn() {
            return associatedResourceArn;
        }

        public final void setAssociatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
        }

        @Override
        public final Builder associatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
            return this;
        }

        public final CreatedByInfo.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(CreatedByInfo.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(CreatedByInfo createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAttachedFileUploadRequest build() {
            return new StartAttachedFileUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
