/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Response from StartAttachedFileUpload API.
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAttachedFileUploadResponse extends ConnectResponse implements
        ToCopyableBuilder<StartAttachedFileUploadResponse.Builder, StartAttachedFileUploadResponse> {
    private static final SdkField<String> FILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileArn").getter(getter(StartAttachedFileUploadResponse::fileArn)).setter(setter(Builder::fileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileArn").build()).build();

    private static final SdkField<String> FILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("FileId")
            .getter(getter(StartAttachedFileUploadResponse::fileId)).setter(setter(Builder::fileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileId").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(StartAttachedFileUploadResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FILE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileStatus").getter(getter(StartAttachedFileUploadResponse::fileStatusAsString))
            .setter(setter(Builder::fileStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileStatus").build()).build();

    private static final SdkField<CreatedByInfo> CREATED_BY_FIELD = SdkField.<CreatedByInfo> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(StartAttachedFileUploadResponse::createdBy))
            .setter(setter(Builder::createdBy)).constructor(CreatedByInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<UploadUrlMetadata> UPLOAD_URL_METADATA_FIELD = SdkField
            .<UploadUrlMetadata> builder(MarshallingType.SDK_POJO).memberName("UploadUrlMetadata")
            .getter(getter(StartAttachedFileUploadResponse::uploadUrlMetadata)).setter(setter(Builder::uploadUrlMetadata))
            .constructor(UploadUrlMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadUrlMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_ARN_FIELD, FILE_ID_FIELD,
            CREATION_TIME_FIELD, FILE_STATUS_FIELD, CREATED_BY_FIELD, UPLOAD_URL_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fileArn;

    private final String fileId;

    private final String creationTime;

    private final String fileStatus;

    private final CreatedByInfo createdBy;

    private final UploadUrlMetadata uploadUrlMetadata;

    private StartAttachedFileUploadResponse(BuilderImpl builder) {
        super(builder);
        this.fileArn = builder.fileArn;
        this.fileId = builder.fileId;
        this.creationTime = builder.creationTime;
        this.fileStatus = builder.fileStatus;
        this.createdBy = builder.createdBy;
        this.uploadUrlMetadata = builder.uploadUrlMetadata;
    }

    /**
     * <p>
     * The unique identifier of the attached file resource (ARN).
     * </p>
     * 
     * @return The unique identifier of the attached file resource (ARN).
     */
    public final String fileArn() {
        return fileArn;
    }

    /**
     * <p>
     * The unique identifier of the attached file resource.
     * </p>
     * 
     * @return The unique identifier of the attached file resource.
     */
    public final String fileId() {
        return fileId;
    }

    /**
     * <p>
     * The time of Creation of the file resource as an ISO timestamp. It's specified in ISO 8601 format:
     * <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.
     * </p>
     * 
     * @return The time of Creation of the file resource as an ISO timestamp. It's specified in ISO 8601 format:
     *         <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The current status of the attached file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileStatus} will
     * return {@link FileStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileStatusAsString}.
     * </p>
     * 
     * @return The current status of the attached file.
     * @see FileStatusType
     */
    public final FileStatusType fileStatus() {
        return FileStatusType.fromValue(fileStatus);
    }

    /**
     * <p>
     * The current status of the attached file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileStatus} will
     * return {@link FileStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileStatusAsString}.
     * </p>
     * 
     * @return The current status of the attached file.
     * @see FileStatusType
     */
    public final String fileStatusAsString() {
        return fileStatus;
    }

    /**
     * <p>
     * Represents the identity that created the file.
     * </p>
     * 
     * @return Represents the identity that created the file.
     */
    public final CreatedByInfo createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The headers to be provided while uploading the file to the URL.
     * </p>
     * 
     * @return The headers to be provided while uploading the file to the URL.
     */
    public final UploadUrlMetadata uploadUrlMetadata() {
        return uploadUrlMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileArn());
        hashCode = 31 * hashCode + Objects.hashCode(fileId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(fileStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(uploadUrlMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAttachedFileUploadResponse)) {
            return false;
        }
        StartAttachedFileUploadResponse other = (StartAttachedFileUploadResponse) obj;
        return Objects.equals(fileArn(), other.fileArn()) && Objects.equals(fileId(), other.fileId())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(fileStatusAsString(), other.fileStatusAsString())
                && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(uploadUrlMetadata(), other.uploadUrlMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAttachedFileUploadResponse").add("FileArn", fileArn()).add("FileId", fileId())
                .add("CreationTime", creationTime()).add("FileStatus", fileStatusAsString()).add("CreatedBy", createdBy())
                .add("UploadUrlMetadata", uploadUrlMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileArn":
            return Optional.ofNullable(clazz.cast(fileArn()));
        case "FileId":
            return Optional.ofNullable(clazz.cast(fileId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FileStatus":
            return Optional.ofNullable(clazz.cast(fileStatusAsString()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "UploadUrlMetadata":
            return Optional.ofNullable(clazz.cast(uploadUrlMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileArn", FILE_ARN_FIELD);
        map.put("FileId", FILE_ID_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FileStatus", FILE_STATUS_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("UploadUrlMetadata", UPLOAD_URL_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAttachedFileUploadResponse, T> g) {
        return obj -> g.apply((StartAttachedFileUploadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartAttachedFileUploadResponse> {
        /**
         * <p>
         * The unique identifier of the attached file resource (ARN).
         * </p>
         * 
         * @param fileArn
         *        The unique identifier of the attached file resource (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileArn(String fileArn);

        /**
         * <p>
         * The unique identifier of the attached file resource.
         * </p>
         * 
         * @param fileId
         *        The unique identifier of the attached file resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileId(String fileId);

        /**
         * <p>
         * The time of Creation of the file resource as an ISO timestamp. It's specified in ISO 8601 format:
         * <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.
         * </p>
         * 
         * @param creationTime
         *        The time of Creation of the file resource as an ISO timestamp. It's specified in ISO 8601 format:
         *        <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The current status of the attached file.
         * </p>
         * 
         * @param fileStatus
         *        The current status of the attached file.
         * @see FileStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileStatusType
         */
        Builder fileStatus(String fileStatus);

        /**
         * <p>
         * The current status of the attached file.
         * </p>
         * 
         * @param fileStatus
         *        The current status of the attached file.
         * @see FileStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileStatusType
         */
        Builder fileStatus(FileStatusType fileStatus);

        /**
         * <p>
         * Represents the identity that created the file.
         * </p>
         * 
         * @param createdBy
         *        Represents the identity that created the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(CreatedByInfo createdBy);

        /**
         * <p>
         * Represents the identity that created the file.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreatedByInfo.Builder} avoiding the need
         * to create one manually via {@link CreatedByInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreatedByInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #createdBy(CreatedByInfo)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link CreatedByInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(CreatedByInfo)
         */
        default Builder createdBy(Consumer<CreatedByInfo.Builder> createdBy) {
            return createdBy(CreatedByInfo.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The headers to be provided while uploading the file to the URL.
         * </p>
         * 
         * @param uploadUrlMetadata
         *        The headers to be provided while uploading the file to the URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadUrlMetadata(UploadUrlMetadata uploadUrlMetadata);

        /**
         * <p>
         * The headers to be provided while uploading the file to the URL.
         * </p>
         * This is a convenience method that creates an instance of the {@link UploadUrlMetadata.Builder} avoiding the
         * need to create one manually via {@link UploadUrlMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UploadUrlMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #uploadUrlMetadata(UploadUrlMetadata)}.
         * 
         * @param uploadUrlMetadata
         *        a consumer that will call methods on {@link UploadUrlMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploadUrlMetadata(UploadUrlMetadata)
         */
        default Builder uploadUrlMetadata(Consumer<UploadUrlMetadata.Builder> uploadUrlMetadata) {
            return uploadUrlMetadata(UploadUrlMetadata.builder().applyMutation(uploadUrlMetadata).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String fileArn;

        private String fileId;

        private String creationTime;

        private String fileStatus;

        private CreatedByInfo createdBy;

        private UploadUrlMetadata uploadUrlMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAttachedFileUploadResponse model) {
            super(model);
            fileArn(model.fileArn);
            fileId(model.fileId);
            creationTime(model.creationTime);
            fileStatus(model.fileStatus);
            createdBy(model.createdBy);
            uploadUrlMetadata(model.uploadUrlMetadata);
        }

        public final String getFileArn() {
            return fileArn;
        }

        public final void setFileArn(String fileArn) {
            this.fileArn = fileArn;
        }

        @Override
        public final Builder fileArn(String fileArn) {
            this.fileArn = fileArn;
            return this;
        }

        public final String getFileId() {
            return fileId;
        }

        public final void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public final Builder fileId(String fileId) {
            this.fileId = fileId;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFileStatus() {
            return fileStatus;
        }

        public final void setFileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
        }

        @Override
        public final Builder fileStatus(String fileStatus) {
            this.fileStatus = fileStatus;
            return this;
        }

        @Override
        public final Builder fileStatus(FileStatusType fileStatus) {
            this.fileStatus(fileStatus == null ? null : fileStatus.toString());
            return this;
        }

        public final CreatedByInfo.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(CreatedByInfo.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(CreatedByInfo createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final UploadUrlMetadata.Builder getUploadUrlMetadata() {
            return uploadUrlMetadata != null ? uploadUrlMetadata.toBuilder() : null;
        }

        public final void setUploadUrlMetadata(UploadUrlMetadata.BuilderImpl uploadUrlMetadata) {
            this.uploadUrlMetadata = uploadUrlMetadata != null ? uploadUrlMetadata.build() : null;
        }

        @Override
        public final Builder uploadUrlMetadata(UploadUrlMetadata uploadUrlMetadata) {
            this.uploadUrlMetadata = uploadUrlMetadata;
            return this;
        }

        @Override
        public StartAttachedFileUploadResponse build() {
            return new StartAttachedFileUploadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
