/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartChatContactResponse extends ConnectResponse implements
        ToCopyableBuilder<StartChatContactResponse.Builder, StartChatContactResponse> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(StartChatContactResponse::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantId").getter(getter(StartChatContactResponse::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()).build();

    private static final SdkField<String> PARTICIPANT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantToken").getter(getter(StartChatContactResponse::participantToken))
            .setter(setter(Builder::participantToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantToken").build()).build();

    private static final SdkField<String> CONTINUED_FROM_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContinuedFromContactId").getter(getter(StartChatContactResponse::continuedFromContactId))
            .setter(setter(Builder::continuedFromContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuedFromContactId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            PARTICIPANT_ID_FIELD, PARTICIPANT_TOKEN_FIELD, CONTINUED_FROM_CONTACT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contactId;

    private final String participantId;

    private final String participantToken;

    private final String continuedFromContactId;

    private StartChatContactResponse(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.participantId = builder.participantId;
        this.participantToken = builder.participantToken;
        this.continuedFromContactId = builder.continuedFromContactId;
    }

    /**
     * <p>
     * The identifier of this contact within the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of this contact within the Amazon Connect instance.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The identifier for a chat participant. The participantId for a chat participant is the same throughout the chat
     * lifecycle.
     * </p>
     * 
     * @return The identifier for a chat participant. The participantId for a chat participant is the same throughout
     *         the chat lifecycle.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * The token used by the chat participant to call <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     * >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.
     * </p>
     * 
     * @return The token used by the chat participant to call <a
     *         href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     *         >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.
     */
    public final String participantToken() {
        return participantToken;
    }

    /**
     * <p>
     * The contactId from which a persistent chat session is started. This field is populated only for persistent chats.
     * </p>
     * 
     * @return The contactId from which a persistent chat session is started. This field is populated only for
     *         persistent chats.
     */
    public final String continuedFromContactId() {
        return continuedFromContactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(participantToken());
        hashCode = 31 * hashCode + Objects.hashCode(continuedFromContactId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChatContactResponse)) {
            return false;
        }
        StartChatContactResponse other = (StartChatContactResponse) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(participantId(), other.participantId())
                && Objects.equals(participantToken(), other.participantToken())
                && Objects.equals(continuedFromContactId(), other.continuedFromContactId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartChatContactResponse").add("ContactId", contactId()).add("ParticipantId", participantId())
                .add("ParticipantToken", participantToken()).add("ContinuedFromContactId", continuedFromContactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "ParticipantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "ParticipantToken":
            return Optional.ofNullable(clazz.cast(participantToken()));
        case "ContinuedFromContactId":
            return Optional.ofNullable(clazz.cast(continuedFromContactId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("ParticipantId", PARTICIPANT_ID_FIELD);
        map.put("ParticipantToken", PARTICIPANT_TOKEN_FIELD);
        map.put("ContinuedFromContactId", CONTINUED_FROM_CONTACT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartChatContactResponse, T> g) {
        return obj -> g.apply((StartChatContactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartChatContactResponse> {
        /**
         * <p>
         * The identifier of this contact within the Amazon Connect instance.
         * </p>
         * 
         * @param contactId
         *        The identifier of this contact within the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The identifier for a chat participant. The participantId for a chat participant is the same throughout the
         * chat lifecycle.
         * </p>
         * 
         * @param participantId
         *        The identifier for a chat participant. The participantId for a chat participant is the same throughout
         *        the chat lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * The token used by the chat participant to call <a href=
         * "https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
         * >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.
         * </p>
         * 
         * @param participantToken
         *        The token used by the chat participant to call <a href=
         *        "https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
         *        >CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat
         *        participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantToken(String participantToken);

        /**
         * <p>
         * The contactId from which a persistent chat session is started. This field is populated only for persistent
         * chats.
         * </p>
         * 
         * @param continuedFromContactId
         *        The contactId from which a persistent chat session is started. This field is populated only for
         *        persistent chats.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuedFromContactId(String continuedFromContactId);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String contactId;

        private String participantId;

        private String participantToken;

        private String continuedFromContactId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChatContactResponse model) {
            super(model);
            contactId(model.contactId);
            participantId(model.participantId);
            participantToken(model.participantToken);
            continuedFromContactId(model.continuedFromContactId);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantToken() {
            return participantToken;
        }

        public final void setParticipantToken(String participantToken) {
            this.participantToken = participantToken;
        }

        @Override
        public final Builder participantToken(String participantToken) {
            this.participantToken = participantToken;
            return this;
        }

        public final String getContinuedFromContactId() {
            return continuedFromContactId;
        }

        public final void setContinuedFromContactId(String continuedFromContactId) {
            this.continuedFromContactId = continuedFromContactId;
        }

        @Override
        public final Builder continuedFromContactId(String continuedFromContactId) {
            this.continuedFromContactId = continuedFromContactId;
            return this;
        }

        @Override
        public StartChatContactResponse build() {
            return new StartChatContactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
