/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartContactStreamingResponse extends ConnectResponse implements
        ToCopyableBuilder<StartContactStreamingResponse.Builder, StartContactStreamingResponse> {
    private static final SdkField<String> STREAMING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamingId").getter(getter(StartContactStreamingResponse::streamingId))
            .setter(setter(Builder::streamingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAMING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamingId;

    private StartContactStreamingResponse(BuilderImpl builder) {
        super(builder);
        this.streamingId = builder.streamingId;
    }

    /**
     * <p>
     * The identifier of the streaming configuration enabled.
     * </p>
     * 
     * @return The identifier of the streaming configuration enabled.
     */
    public final String streamingId() {
        return streamingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartContactStreamingResponse)) {
            return false;
        }
        StartContactStreamingResponse other = (StartContactStreamingResponse) obj;
        return Objects.equals(streamingId(), other.streamingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartContactStreamingResponse").add("StreamingId", streamingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamingId":
            return Optional.ofNullable(clazz.cast(streamingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamingId", STREAMING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartContactStreamingResponse, T> g) {
        return obj -> g.apply((StartContactStreamingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartContactStreamingResponse> {
        /**
         * <p>
         * The identifier of the streaming configuration enabled.
         * </p>
         * 
         * @param streamingId
         *        The identifier of the streaming configuration enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamingId(String streamingId);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String streamingId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartContactStreamingResponse model) {
            super(model);
            streamingId(model.streamingId);
        }

        public final String getStreamingId() {
            return streamingId;
        }

        public final void setStreamingId(String streamingId) {
            this.streamingId = streamingId;
        }

        @Override
        public final Builder streamingId(String streamingId) {
            this.streamingId = streamingId;
            return this;
        }

        @Override
        public StartContactStreamingResponse build() {
            return new StartContactStreamingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
