/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartWebRtcContactRequest extends ConnectRequest implements
        ToCopyableBuilder<StartWebRtcContactRequest.Builder, StartWebRtcContactRequest> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(StartWebRtcContactRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartWebRtcContactRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(StartWebRtcContactRequest::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StartWebRtcContactRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<AllowedCapabilities> ALLOWED_CAPABILITIES_FIELD = SdkField
            .<AllowedCapabilities> builder(MarshallingType.SDK_POJO).memberName("AllowedCapabilities")
            .getter(getter(StartWebRtcContactRequest::allowedCapabilities)).setter(setter(Builder::allowedCapabilities))
            .constructor(AllowedCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedCapabilities").build())
            .build();

    private static final SdkField<ParticipantDetails> PARTICIPANT_DETAILS_FIELD = SdkField
            .<ParticipantDetails> builder(MarshallingType.SDK_POJO).memberName("ParticipantDetails")
            .getter(getter(StartWebRtcContactRequest::participantDetails)).setter(setter(Builder::participantDetails))
            .constructor(ParticipantDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantDetails").build())
            .build();

    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedContactId").getter(getter(StartWebRtcContactRequest::relatedContactId))
            .setter(setter(Builder::relatedContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()).build();

    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField
            .<Map<String, Reference>> builder(MarshallingType.MAP)
            .memberName("References")
            .getter(getter(StartWebRtcContactRequest::references))
            .setter(setter(Builder::references))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Reference> builder(MarshallingType.SDK_POJO)
                                            .constructor(Reference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartWebRtcContactRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            CLIENT_TOKEN_FIELD, CONTACT_FLOW_ID_FIELD, INSTANCE_ID_FIELD, ALLOWED_CAPABILITIES_FIELD, PARTICIPANT_DETAILS_FIELD,
            RELATED_CONTACT_ID_FIELD, REFERENCES_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, String> attributes;

    private final String clientToken;

    private final String contactFlowId;

    private final String instanceId;

    private final AllowedCapabilities allowedCapabilities;

    private final ParticipantDetails participantDetails;

    private final String relatedContactId;

    private final Map<String, Reference> references;

    private final String description;

    private StartWebRtcContactRequest(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
        this.clientToken = builder.clientToken;
        this.contactFlowId = builder.contactFlowId;
        this.instanceId = builder.instanceId;
        this.allowedCapabilities = builder.allowedCapabilities;
        this.participantDetails = builder.participantDetails;
        this.relatedContactId = builder.relatedContactId;
        this.references = builder.references;
        this.description = builder.description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be
     * accessed in flows just like any other contact attributes.
     * </p>
     * <p>
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
     * alphanumeric, -, and _ characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
     *         and can be accessed in flows just like any other contact attributes.</p>
     *         <p>
     *         There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include
     *         only alphanumeric, -, and _ characters.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * <p>
     * The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.</p>
     *         <p>
     *         The token is valid for 7 days after creation. If a contact is already started, the contact ID is
     *         returned.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect admin website, on the
     * navigation menu go to <b>Routing</b>, <b>Flows</b>. Choose the flow. On the flow page, under the name of the
     * flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here
     * in bold:
     * </p>
     * <p>
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     * </p>
     * 
     * @return The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect admin website, on
     *         the navigation menu go to <b>Routing</b>, <b>Flows</b>. Choose the flow. On the flow page, under the name
     *         of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the
     *         ARN, shown here in bold: </p>
     *         <p>
     *         arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     *         846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Information about the video sharing capabilities of the participants (customer, agent).
     * </p>
     * 
     * @return Information about the video sharing capabilities of the participants (customer, agent).
     */
    public final AllowedCapabilities allowedCapabilities() {
        return allowedCapabilities;
    }

    /**
     * Returns the value of the ParticipantDetails property for this object.
     * 
     * @return The value of the ParticipantDetails property for this object.
     */
    public final ParticipantDetails participantDetails() {
        return participantDetails;
    }

    /**
     * <p>
     * The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.
     * </p>
     * 
     * @return The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.
     */
    public final String relatedContactId() {
        return relatedContactId;
    }

    /**
     * For responses, this returns true if the service returned a value for the References property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReferences() {
        return references != null && !(references instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the following
     * reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> | <code>STRING</code> |
     * <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a supported reference type during task
     * creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferences} method.
     * </p>
     * 
     * @return A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the
     *         following reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> |
     *         <code>STRING</code> | <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a supported
     *         reference type during task creation.
     */
    public final Map<String, Reference> references() {
        return references;
    }

    /**
     * <p>
     * A description of the task that is shown to an agent in the Contact Control Panel (CCP).
     * </p>
     * 
     * @return A description of the task that is shown to an agent in the Contact Control Panel (CCP).
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(allowedCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(participantDetails());
        hashCode = 31 * hashCode + Objects.hashCode(relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferences() ? references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWebRtcContactRequest)) {
            return false;
        }
        StartWebRtcContactRequest other = (StartWebRtcContactRequest) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(contactFlowId(), other.contactFlowId())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(allowedCapabilities(), other.allowedCapabilities())
                && Objects.equals(participantDetails(), other.participantDetails())
                && Objects.equals(relatedContactId(), other.relatedContactId()) && hasReferences() == other.hasReferences()
                && Objects.equals(references(), other.references()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartWebRtcContactRequest").add("Attributes", hasAttributes() ? attributes() : null)
                .add("ClientToken", clientToken()).add("ContactFlowId", contactFlowId()).add("InstanceId", instanceId())
                .add("AllowedCapabilities", allowedCapabilities()).add("ParticipantDetails", participantDetails())
                .add("RelatedContactId", relatedContactId()).add("References", hasReferences() ? references() : null)
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AllowedCapabilities":
            return Optional.ofNullable(clazz.cast(allowedCapabilities()));
        case "ParticipantDetails":
            return Optional.ofNullable(clazz.cast(participantDetails()));
        case "RelatedContactId":
            return Optional.ofNullable(clazz.cast(relatedContactId()));
        case "References":
            return Optional.ofNullable(clazz.cast(references()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AllowedCapabilities", ALLOWED_CAPABILITIES_FIELD);
        map.put("ParticipantDetails", PARTICIPANT_DETAILS_FIELD);
        map.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
        map.put("References", REFERENCES_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartWebRtcContactRequest, T> g) {
        return obj -> g.apply((StartWebRtcContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartWebRtcContactRequest> {
        /**
         * <p>
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and
         * can be accessed in flows just like any other contact attributes.
         * </p>
         * <p>
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
         * alphanumeric, -, and _ characters.
         * </p>
         * 
         * @param attributes
         *        A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
         *        and can be accessed in flows just like any other contact attributes.</p>
         *        <p>
         *        There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can
         *        include only alphanumeric, -, and _ characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * <p>
         * The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.</p>
         *        <p>
         *        The token is valid for 7 days after creation. If a contact is already started, the contact ID is
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect admin website, on the
         * navigation menu go to <b>Routing</b>, <b>Flows</b>. Choose the flow. On the flow page, under the name of the
         * flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown
         * here in bold:
         * </p>
         * <p>
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect admin website,
         *        on the navigation menu go to <b>Routing</b>, <b>Flows</b>. Choose the flow. On the flow page, under
         *        the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last
         *        part of the ARN, shown here in bold: </p>
         *        <p>
         *        arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         *        846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Information about the video sharing capabilities of the participants (customer, agent).
         * </p>
         * 
         * @param allowedCapabilities
         *        Information about the video sharing capabilities of the participants (customer, agent).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedCapabilities(AllowedCapabilities allowedCapabilities);

        /**
         * <p>
         * Information about the video sharing capabilities of the participants (customer, agent).
         * </p>
         * This is a convenience method that creates an instance of the {@link AllowedCapabilities.Builder} avoiding the
         * need to create one manually via {@link AllowedCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllowedCapabilities.Builder#build()} is called immediately and
         * its result is passed to {@link #allowedCapabilities(AllowedCapabilities)}.
         * 
         * @param allowedCapabilities
         *        a consumer that will call methods on {@link AllowedCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedCapabilities(AllowedCapabilities)
         */
        default Builder allowedCapabilities(Consumer<AllowedCapabilities.Builder> allowedCapabilities) {
            return allowedCapabilities(AllowedCapabilities.builder().applyMutation(allowedCapabilities).build());
        }

        /**
         * Sets the value of the ParticipantDetails property for this object.
         *
         * @param participantDetails
         *        The new value for the ParticipantDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantDetails(ParticipantDetails participantDetails);

        /**
         * Sets the value of the ParticipantDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ParticipantDetails.Builder} avoiding the
         * need to create one manually via {@link ParticipantDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #participantDetails(ParticipantDetails)}.
         * 
         * @param participantDetails
         *        a consumer that will call methods on {@link ParticipantDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participantDetails(ParticipantDetails)
         */
        default Builder participantDetails(Consumer<ParticipantDetails.Builder> participantDetails) {
            return participantDetails(ParticipantDetails.builder().applyMutation(participantDetails).build());
        }

        /**
         * <p>
         * The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.
         * </p>
         * 
         * @param relatedContactId
         *        The unique identifier for an Amazon Connect contact. This identifier is related to the contact
         *        starting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedContactId(String relatedContactId);

        /**
         * <p>
         * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the following
         * reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> | <code>STRING</code> |
         * <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a supported reference type during task
         * creation.
         * </p>
         * 
         * @param references
         *        A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the
         *        following reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> |
         *        <code>STRING</code> | <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a
         *        supported reference type during task creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(Map<String, Reference> references);

        /**
         * <p>
         * A description of the task that is shown to an agent in the Contact Control Panel (CCP).
         * </p>
         * 
         * @param description
         *        A description of the task that is shown to an agent in the Contact Control Panel (CCP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private String contactFlowId;

        private String instanceId;

        private AllowedCapabilities allowedCapabilities;

        private ParticipantDetails participantDetails;

        private String relatedContactId;

        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWebRtcContactRequest model) {
            super(model);
            attributes(model.attributes);
            clientToken(model.clientToken);
            contactFlowId(model.contactFlowId);
            instanceId(model.instanceId);
            allowedCapabilities(model.allowedCapabilities);
            participantDetails(model.participantDetails);
            relatedContactId(model.relatedContactId);
            references(model.references);
            description(model.description);
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final AllowedCapabilities.Builder getAllowedCapabilities() {
            return allowedCapabilities != null ? allowedCapabilities.toBuilder() : null;
        }

        public final void setAllowedCapabilities(AllowedCapabilities.BuilderImpl allowedCapabilities) {
            this.allowedCapabilities = allowedCapabilities != null ? allowedCapabilities.build() : null;
        }

        @Override
        public final Builder allowedCapabilities(AllowedCapabilities allowedCapabilities) {
            this.allowedCapabilities = allowedCapabilities;
            return this;
        }

        public final ParticipantDetails.Builder getParticipantDetails() {
            return participantDetails != null ? participantDetails.toBuilder() : null;
        }

        public final void setParticipantDetails(ParticipantDetails.BuilderImpl participantDetails) {
            this.participantDetails = participantDetails != null ? participantDetails.build() : null;
        }

        @Override
        public final Builder participantDetails(ParticipantDetails participantDetails) {
            this.participantDetails = participantDetails;
            return this;
        }

        public final String getRelatedContactId() {
            return relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartWebRtcContactRequest build() {
            return new StartWebRtcContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
