/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartWebRtcContactResponse extends ConnectResponse implements
        ToCopyableBuilder<StartWebRtcContactResponse.Builder, StartWebRtcContactResponse> {
    private static final SdkField<ConnectionData> CONNECTION_DATA_FIELD = SdkField
            .<ConnectionData> builder(MarshallingType.SDK_POJO).memberName("ConnectionData")
            .getter(getter(StartWebRtcContactResponse::connectionData)).setter(setter(Builder::connectionData))
            .constructor(ConnectionData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionData").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(StartWebRtcContactResponse::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantId").getter(getter(StartWebRtcContactResponse::participantId))
            .setter(setter(Builder::participantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()).build();

    private static final SdkField<String> PARTICIPANT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantToken").getter(getter(StartWebRtcContactResponse::participantToken))
            .setter(setter(Builder::participantToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_DATA_FIELD,
            CONTACT_ID_FIELD, PARTICIPANT_ID_FIELD, PARTICIPANT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConnectionData connectionData;

    private final String contactId;

    private final String participantId;

    private final String participantToken;

    private StartWebRtcContactResponse(BuilderImpl builder) {
        super(builder);
        this.connectionData = builder.connectionData;
        this.contactId = builder.contactId;
        this.participantId = builder.participantId;
        this.participantToken = builder.participantToken;
    }

    /**
     * <p>
     * Information required for the client application (mobile application or website) to connect to the call.
     * </p>
     * 
     * @return Information required for the client application (mobile application or website) to connect to the call.
     */
    public final ConnectionData connectionData() {
        return connectionData;
    }

    /**
     * <p>
     * The identifier of the contact in this instance of Amazon Connect.
     * </p>
     * 
     * @return The identifier of the contact in this instance of Amazon Connect.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The identifier for a contact participant. The <code>ParticipantId</code> for a contact participant is the same
     * throughout the contact lifecycle.
     * </p>
     * 
     * @return The identifier for a contact participant. The <code>ParticipantId</code> for a contact participant is the
     *         same throughout the contact lifecycle.
     */
    public final String participantId() {
        return participantId;
    }

    /**
     * <p>
     * The token used by the contact participant to call the <a
     * href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     * >CreateParticipantConnection</a> API. The participant token is valid for the lifetime of a contact participant.
     * </p>
     * 
     * @return The token used by the contact participant to call the <a
     *         href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
     *         >CreateParticipantConnection</a> API. The participant token is valid for the lifetime of a contact
     *         participant.
     */
    public final String participantToken() {
        return participantToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionData());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(participantId());
        hashCode = 31 * hashCode + Objects.hashCode(participantToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWebRtcContactResponse)) {
            return false;
        }
        StartWebRtcContactResponse other = (StartWebRtcContactResponse) obj;
        return Objects.equals(connectionData(), other.connectionData()) && Objects.equals(contactId(), other.contactId())
                && Objects.equals(participantId(), other.participantId())
                && Objects.equals(participantToken(), other.participantToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartWebRtcContactResponse").add("ConnectionData", connectionData())
                .add("ContactId", contactId()).add("ParticipantId", participantId()).add("ParticipantToken", participantToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionData":
            return Optional.ofNullable(clazz.cast(connectionData()));
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "ParticipantId":
            return Optional.ofNullable(clazz.cast(participantId()));
        case "ParticipantToken":
            return Optional.ofNullable(clazz.cast(participantToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionData", CONNECTION_DATA_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("ParticipantId", PARTICIPANT_ID_FIELD);
        map.put("ParticipantToken", PARTICIPANT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartWebRtcContactResponse, T> g) {
        return obj -> g.apply((StartWebRtcContactResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartWebRtcContactResponse> {
        /**
         * <p>
         * Information required for the client application (mobile application or website) to connect to the call.
         * </p>
         * 
         * @param connectionData
         *        Information required for the client application (mobile application or website) to connect to the
         *        call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionData(ConnectionData connectionData);

        /**
         * <p>
         * Information required for the client application (mobile application or website) to connect to the call.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionData.Builder} avoiding the need
         * to create one manually via {@link ConnectionData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionData.Builder#build()} is called immediately and its
         * result is passed to {@link #connectionData(ConnectionData)}.
         * 
         * @param connectionData
         *        a consumer that will call methods on {@link ConnectionData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionData(ConnectionData)
         */
        default Builder connectionData(Consumer<ConnectionData.Builder> connectionData) {
            return connectionData(ConnectionData.builder().applyMutation(connectionData).build());
        }

        /**
         * <p>
         * The identifier of the contact in this instance of Amazon Connect.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact in this instance of Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The identifier for a contact participant. The <code>ParticipantId</code> for a contact participant is the
         * same throughout the contact lifecycle.
         * </p>
         * 
         * @param participantId
         *        The identifier for a contact participant. The <code>ParticipantId</code> for a contact participant is
         *        the same throughout the contact lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantId(String participantId);

        /**
         * <p>
         * The token used by the contact participant to call the <a href=
         * "https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
         * >CreateParticipantConnection</a> API. The participant token is valid for the lifetime of a contact
         * participant.
         * </p>
         * 
         * @param participantToken
         *        The token used by the contact participant to call the <a href=
         *        "https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html"
         *        >CreateParticipantConnection</a> API. The participant token is valid for the lifetime of a contact
         *        participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantToken(String participantToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private ConnectionData connectionData;

        private String contactId;

        private String participantId;

        private String participantToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWebRtcContactResponse model) {
            super(model);
            connectionData(model.connectionData);
            contactId(model.contactId);
            participantId(model.participantId);
            participantToken(model.participantToken);
        }

        public final ConnectionData.Builder getConnectionData() {
            return connectionData != null ? connectionData.toBuilder() : null;
        }

        public final void setConnectionData(ConnectionData.BuilderImpl connectionData) {
            this.connectionData = connectionData != null ? connectionData.build() : null;
        }

        @Override
        public final Builder connectionData(ConnectionData connectionData) {
            this.connectionData = connectionData;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getParticipantId() {
            return participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantToken() {
            return participantToken;
        }

        public final void setParticipantToken(String participantToken) {
            this.participantToken = participantToken;
        }

        @Override
        public final Builder participantToken(String participantToken) {
            this.participantToken = participantToken;
            return this;
        }

        @Override
        public StartWebRtcContactResponse build() {
            return new StartWebRtcContactResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
