/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopContactRequest extends ConnectRequest implements
        ToCopyableBuilder<StopContactRequest.Builder, StopContactRequest> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(StopContactRequest::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StopContactRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<DisconnectReason> DISCONNECT_REASON_FIELD = SdkField
            .<DisconnectReason> builder(MarshallingType.SDK_POJO).memberName("DisconnectReason")
            .getter(getter(StopContactRequest::disconnectReason)).setter(setter(Builder::disconnectReason))
            .constructor(DisconnectReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            INSTANCE_ID_FIELD, DISCONNECT_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String contactId;

    private final String instanceId;

    private final DisconnectReason disconnectReason;

    private StopContactRequest(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.instanceId = builder.instanceId;
        this.disconnectReason = builder.disconnectReason;
    }

    /**
     * <p>
     * The ID of the contact.
     * </p>
     * 
     * @return The ID of the contact.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The reason a contact can be disconnected. Only Amazon Connect outbound campaigns can provide this field.
     * </p>
     * 
     * @return The reason a contact can be disconnected. Only Amazon Connect outbound campaigns can provide this field.
     */
    public final DisconnectReason disconnectReason() {
        return disconnectReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopContactRequest)) {
            return false;
        }
        StopContactRequest other = (StopContactRequest) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(disconnectReason(), other.disconnectReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopContactRequest").add("ContactId", contactId()).add("InstanceId", instanceId())
                .add("DisconnectReason", disconnectReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DisconnectReason":
            return Optional.ofNullable(clazz.cast(disconnectReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("DisconnectReason", DISCONNECT_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopContactRequest, T> g) {
        return obj -> g.apply((StopContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopContactRequest> {
        /**
         * <p>
         * The ID of the contact.
         * </p>
         * 
         * @param contactId
         *        The ID of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The reason a contact can be disconnected. Only Amazon Connect outbound campaigns can provide this field.
         * </p>
         * 
         * @param disconnectReason
         *        The reason a contact can be disconnected. Only Amazon Connect outbound campaigns can provide this
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectReason(DisconnectReason disconnectReason);

        /**
         * <p>
         * The reason a contact can be disconnected. Only Amazon Connect outbound campaigns can provide this field.
         * </p>
         * This is a convenience method that creates an instance of the {@link DisconnectReason.Builder} avoiding the
         * need to create one manually via {@link DisconnectReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DisconnectReason.Builder#build()} is called immediately and its
         * result is passed to {@link #disconnectReason(DisconnectReason)}.
         * 
         * @param disconnectReason
         *        a consumer that will call methods on {@link DisconnectReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #disconnectReason(DisconnectReason)
         */
        default Builder disconnectReason(Consumer<DisconnectReason.Builder> disconnectReason) {
            return disconnectReason(DisconnectReason.builder().applyMutation(disconnectReason).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String contactId;

        private String instanceId;

        private DisconnectReason disconnectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopContactRequest model) {
            super(model);
            contactId(model.contactId);
            instanceId(model.instanceId);
            disconnectReason(model.disconnectReason);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final DisconnectReason.Builder getDisconnectReason() {
            return disconnectReason != null ? disconnectReason.toBuilder() : null;
        }

        public final void setDisconnectReason(DisconnectReason.BuilderImpl disconnectReason) {
            this.disconnectReason = disconnectReason != null ? disconnectReason.build() : null;
        }

        @Override
        public final Builder disconnectReason(DisconnectReason disconnectReason) {
            this.disconnectReason = disconnectReason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopContactRequest build() {
            return new StopContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
