/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmitContactEvaluationRequest extends ConnectRequest implements
        ToCopyableBuilder<SubmitContactEvaluationRequest.Builder, SubmitContactEvaluationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(SubmitContactEvaluationRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationId").getter(getter(SubmitContactEvaluationRequest::evaluationId))
            .setter(setter(Builder::evaluationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EvaluationId").build()).build();

    private static final SdkField<Map<String, EvaluationAnswerInput>> ANSWERS_FIELD = SdkField
            .<Map<String, EvaluationAnswerInput>> builder(MarshallingType.MAP)
            .memberName("Answers")
            .getter(getter(SubmitContactEvaluationRequest::answers))
            .setter(setter(Builder::answers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Answers").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EvaluationAnswerInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationAnswerInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, EvaluationNote>> NOTES_FIELD = SdkField
            .<Map<String, EvaluationNote>> builder(MarshallingType.MAP)
            .memberName("Notes")
            .getter(getter(SubmitContactEvaluationRequest::notes))
            .setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EvaluationNote> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationNote::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            EVALUATION_ID_FIELD, ANSWERS_FIELD, NOTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String evaluationId;

    private final Map<String, EvaluationAnswerInput> answers;

    private final Map<String, EvaluationNote> notes;

    private SubmitContactEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.evaluationId = builder.evaluationId;
        this.answers = builder.answers;
        this.notes = builder.notes;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A unique identifier for the contact evaluation.
     * </p>
     * 
     * @return A unique identifier for the contact evaluation.
     */
    public final String evaluationId() {
        return evaluationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Answers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAnswers() {
        return answers != null && !(answers instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of question identifiers to answer value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnswers} method.
     * </p>
     * 
     * @return A map of question identifiers to answer value.
     */
    public final Map<String, EvaluationAnswerInput> answers() {
        return answers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Notes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNotes() {
        return notes != null && !(notes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of question identifiers to note value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotes} method.
     * </p>
     * 
     * @return A map of question identifiers to note value.
     */
    public final Map<String, EvaluationNote> notes() {
        return notes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnswers() ? answers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotes() ? notes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitContactEvaluationRequest)) {
            return false;
        }
        SubmitContactEvaluationRequest other = (SubmitContactEvaluationRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(evaluationId(), other.evaluationId())
                && hasAnswers() == other.hasAnswers() && Objects.equals(answers(), other.answers())
                && hasNotes() == other.hasNotes() && Objects.equals(notes(), other.notes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubmitContactEvaluationRequest").add("InstanceId", instanceId())
                .add("EvaluationId", evaluationId()).add("Answers", hasAnswers() ? answers() : null)
                .add("Notes", hasNotes() ? notes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "EvaluationId":
            return Optional.ofNullable(clazz.cast(evaluationId()));
        case "Answers":
            return Optional.ofNullable(clazz.cast(answers()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("EvaluationId", EVALUATION_ID_FIELD);
        map.put("Answers", ANSWERS_FIELD);
        map.put("Notes", NOTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubmitContactEvaluationRequest, T> g) {
        return obj -> g.apply((SubmitContactEvaluationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, SubmitContactEvaluationRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A unique identifier for the contact evaluation.
         * </p>
         * 
         * @param evaluationId
         *        A unique identifier for the contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);

        /**
         * <p>
         * A map of question identifiers to answer value.
         * </p>
         * 
         * @param answers
         *        A map of question identifiers to answer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answers(Map<String, EvaluationAnswerInput> answers);

        /**
         * <p>
         * A map of question identifiers to note value.
         * </p>
         * 
         * @param notes
         *        A map of question identifiers to note value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(Map<String, EvaluationNote> notes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String evaluationId;

        private Map<String, EvaluationAnswerInput> answers = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, EvaluationNote> notes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitContactEvaluationRequest model) {
            super(model);
            instanceId(model.instanceId);
            evaluationId(model.evaluationId);
            answers(model.answers);
            notes(model.notes);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final Map<String, EvaluationAnswerInput.Builder> getAnswers() {
            Map<String, EvaluationAnswerInput.Builder> result = EvaluationAnswersInputMapCopier.copyToBuilder(this.answers);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAnswers(Map<String, EvaluationAnswerInput.BuilderImpl> answers) {
            this.answers = EvaluationAnswersInputMapCopier.copyFromBuilder(answers);
        }

        @Override
        public final Builder answers(Map<String, EvaluationAnswerInput> answers) {
            this.answers = EvaluationAnswersInputMapCopier.copy(answers);
            return this;
        }

        public final Map<String, EvaluationNote.Builder> getNotes() {
            Map<String, EvaluationNote.Builder> result = EvaluationNotesMapCopier.copyToBuilder(this.notes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setNotes(Map<String, EvaluationNote.BuilderImpl> notes) {
            this.notes = EvaluationNotesMapCopier.copyFromBuilder(notes);
        }

        @Override
        public final Builder notes(Map<String, EvaluationNote> notes) {
            this.notes = EvaluationNotesMapCopier.copy(notes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitContactEvaluationRequest build() {
            return new SubmitContactEvaluationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
