/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request for which contact was successfully created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuccessfulRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<SuccessfulRequest.Builder, SuccessfulRequest> {
    private static final SdkField<String> REQUEST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestIdentifier").getter(getter(SuccessfulRequest::requestIdentifier))
            .setter(setter(Builder::requestIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestIdentifier").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(SuccessfulRequest::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_IDENTIFIER_FIELD,
            CONTACT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String requestIdentifier;

    private final String contactId;

    private SuccessfulRequest(BuilderImpl builder) {
        this.requestIdentifier = builder.requestIdentifier;
        this.contactId = builder.contactId;
    }

    /**
     * <p>
     * Request identifier provided in the API call in the ContactDataRequest to create a contact.
     * </p>
     * 
     * @return Request identifier provided in the API call in the ContactDataRequest to create a contact.
     */
    public final String requestIdentifier() {
        return requestIdentifier;
    }

    /**
     * <p>
     * The contactId of the contact that was created successfully.
     * </p>
     * 
     * @return The contactId of the contact that was created successfully.
     */
    public final String contactId() {
        return contactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requestIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuccessfulRequest)) {
            return false;
        }
        SuccessfulRequest other = (SuccessfulRequest) obj;
        return Objects.equals(requestIdentifier(), other.requestIdentifier()) && Objects.equals(contactId(), other.contactId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuccessfulRequest").add("RequestIdentifier", requestIdentifier()).add("ContactId", contactId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestIdentifier":
            return Optional.ofNullable(clazz.cast(requestIdentifier()));
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequestIdentifier", REQUEST_IDENTIFIER_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuccessfulRequest, T> g) {
        return obj -> g.apply((SuccessfulRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuccessfulRequest> {
        /**
         * <p>
         * Request identifier provided in the API call in the ContactDataRequest to create a contact.
         * </p>
         * 
         * @param requestIdentifier
         *        Request identifier provided in the API call in the ContactDataRequest to create a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestIdentifier(String requestIdentifier);

        /**
         * <p>
         * The contactId of the contact that was created successfully.
         * </p>
         * 
         * @param contactId
         *        The contactId of the contact that was created successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);
    }

    static final class BuilderImpl implements Builder {
        private String requestIdentifier;

        private String contactId;

        private BuilderImpl() {
        }

        private BuilderImpl(SuccessfulRequest model) {
            requestIdentifier(model.requestIdentifier);
            contactId(model.contactId);
        }

        public final String getRequestIdentifier() {
            return requestIdentifier;
        }

        public final void setRequestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
        }

        @Override
        public final Builder requestIdentifier(String requestIdentifier) {
            this.requestIdentifier = requestIdentifier;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        @Override
        public SuccessfulRequest build() {
            return new SuccessfulRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
