/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the threshold for service level metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThresholdV2 implements SdkPojo, Serializable, ToCopyableBuilder<ThresholdV2.Builder, ThresholdV2> {
    private static final SdkField<String> COMPARISON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Comparison").getter(getter(ThresholdV2::comparison)).setter(setter(Builder::comparison))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comparison").build()).build();

    private static final SdkField<Double> THRESHOLD_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThresholdValue").getter(getter(ThresholdV2::thresholdValue)).setter(setter(Builder::thresholdValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_FIELD,
            THRESHOLD_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String comparison;

    private final Double thresholdValue;

    private ThresholdV2(BuilderImpl builder) {
        this.comparison = builder.comparison;
        this.thresholdValue = builder.thresholdValue;
    }

    /**
     * <p>
     * The type of comparison. Currently, "less than" (LT), "less than equal" (LTE), and "greater than" (GT) comparisons
     * are supported.
     * </p>
     * 
     * @return The type of comparison. Currently, "less than" (LT), "less than equal" (LTE), and "greater than" (GT)
     *         comparisons are supported.
     */
    public final String comparison() {
        return comparison;
    }

    /**
     * <p>
     * The threshold value to compare.
     * </p>
     * 
     * @return The threshold value to compare.
     */
    public final Double thresholdValue() {
        return thresholdValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparison());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThresholdV2)) {
            return false;
        }
        ThresholdV2 other = (ThresholdV2) obj;
        return Objects.equals(comparison(), other.comparison()) && Objects.equals(thresholdValue(), other.thresholdValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThresholdV2").add("Comparison", comparison()).add("ThresholdValue", thresholdValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comparison":
            return Optional.ofNullable(clazz.cast(comparison()));
        case "ThresholdValue":
            return Optional.ofNullable(clazz.cast(thresholdValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Comparison", COMPARISON_FIELD);
        map.put("ThresholdValue", THRESHOLD_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThresholdV2, T> g) {
        return obj -> g.apply((ThresholdV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThresholdV2> {
        /**
         * <p>
         * The type of comparison. Currently, "less than" (LT), "less than equal" (LTE), and "greater than" (GT)
         * comparisons are supported.
         * </p>
         * 
         * @param comparison
         *        The type of comparison. Currently, "less than" (LT), "less than equal" (LTE), and "greater than" (GT)
         *        comparisons are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparison(String comparison);

        /**
         * <p>
         * The threshold value to compare.
         * </p>
         * 
         * @param thresholdValue
         *        The threshold value to compare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdValue(Double thresholdValue);
    }

    static final class BuilderImpl implements Builder {
        private String comparison;

        private Double thresholdValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ThresholdV2 model) {
            comparison(model.comparison);
            thresholdValue(model.thresholdValue);
        }

        public final String getComparison() {
            return comparison;
        }

        public final void setComparison(String comparison) {
            this.comparison = comparison;
        }

        @Override
        public final Builder comparison(String comparison) {
            this.comparison = comparison;
            return this;
        }

        public final Double getThresholdValue() {
            return thresholdValue;
        }

        public final void setThresholdValue(Double thresholdValue) {
            this.thresholdValue = thresholdValue;
        }

        @Override
        public final Builder thresholdValue(Double thresholdValue) {
            this.thresholdValue = thresholdValue;
            return this;
        }

        @Override
        public ThresholdV2 build() {
            return new ThresholdV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
