/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about traffic distribution groups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrafficDistributionGroupSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrafficDistributionGroupSummary.Builder, TrafficDistributionGroupSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(TrafficDistributionGroupSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TrafficDistributionGroupSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TrafficDistributionGroupSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(TrafficDistributionGroupSummary::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TrafficDistributionGroupSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(TrafficDistributionGroupSummary::isDefault))
            .setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, INSTANCE_ARN_FIELD, STATUS_FIELD, IS_DEFAULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String instanceArn;

    private final String status;

    private final Boolean isDefault;

    private TrafficDistributionGroupSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.instanceArn = builder.instanceArn;
        this.status = builder.status;
        this.isDefault = builder.isDefault;
    }

    /**
     * <p>
     * The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the
     * Region where the traffic distribution group was created. The ARN must be provided if the call is from the
     * replicated Region.
     * </p>
     * 
     * @return The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being
     *         called in the Region where the traffic distribution group was created. The ARN must be provided if the
     *         call is from the replicated Region.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the traffic distribution group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the traffic distribution group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the traffic distribution group.
     * </p>
     * 
     * @return The name of the traffic distribution group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the traffic distribution group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the traffic distribution group.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The status of the traffic distribution group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATION_IN_PROGRESS</code> means the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     * >CreateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> means the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     * >CreateTrafficDistributionGroup</a> operation has succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_FAILED</code> indicates that the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     * >CreateTrafficDistributionGroup</a> operation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> means the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
     * >DeleteTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETION_FAILED</code> means the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
     * >DeleteTrafficDistributionGroup</a> operation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> means the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html"
     * >UpdateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrafficDistributionGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the traffic distribution group. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATION_IN_PROGRESS</code> means the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     *         >CreateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> means the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     *         >CreateTrafficDistributionGroup</a> operation has succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_FAILED</code> indicates that the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     *         >CreateTrafficDistributionGroup</a> operation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_DELETION</code> means the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
     *         >DeleteTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETION_FAILED</code> means the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
     *         >DeleteTrafficDistributionGroup</a> operation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> means the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html"
     *         >UpdateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     *         </p>
     *         </li>
     * @see TrafficDistributionGroupStatus
     */
    public final TrafficDistributionGroupStatus status() {
        return TrafficDistributionGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the traffic distribution group.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATION_IN_PROGRESS</code> means the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     * >CreateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> means the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     * >CreateTrafficDistributionGroup</a> operation has succeeded.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATION_FAILED</code> indicates that the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     * >CreateTrafficDistributionGroup</a> operation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING_DELETION</code> means the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
     * >DeleteTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETION_FAILED</code> means the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
     * >DeleteTrafficDistributionGroup</a> operation has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATE_IN_PROGRESS</code> means the previous <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html"
     * >UpdateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TrafficDistributionGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the traffic distribution group. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATION_IN_PROGRESS</code> means the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     *         >CreateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> means the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     *         >CreateTrafficDistributionGroup</a> operation has succeeded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATION_FAILED</code> indicates that the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
     *         >CreateTrafficDistributionGroup</a> operation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING_DELETION</code> means the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
     *         >DeleteTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETION_FAILED</code> means the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
     *         >DeleteTrafficDistributionGroup</a> operation has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATE_IN_PROGRESS</code> means the previous <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html"
     *         >UpdateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
     *         </p>
     *         </li>
     * @see TrafficDistributionGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Whether this is the default traffic distribution group created during instance replication. The default traffic
     * distribution group cannot be deleted by the <code>DeleteTrafficDistributionGroup</code> API. The default traffic
     * distribution group is deleted as part of the process for deleting a replica.
     * </p>
     * 
     * @return Whether this is the default traffic distribution group created during instance replication. The default
     *         traffic distribution group cannot be deleted by the <code>DeleteTrafficDistributionGroup</code> API. The
     *         default traffic distribution group is deleted as part of the process for deleting a replica.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficDistributionGroupSummary)) {
            return false;
        }
        TrafficDistributionGroupSummary other = (TrafficDistributionGroupSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(instanceArn(), other.instanceArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(isDefault(), other.isDefault());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrafficDistributionGroupSummary").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("InstanceArn", instanceArn()).add("Status", statusAsString()).add("IsDefault", isDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficDistributionGroupSummary, T> g) {
        return obj -> g.apply((TrafficDistributionGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrafficDistributionGroupSummary> {
        /**
         * <p>
         * The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in
         * the Region where the traffic distribution group was created. The ARN must be provided if the call is from the
         * replicated Region.
         * </p>
         * 
         * @param id
         *        The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being
         *        called in the Region where the traffic distribution group was created. The ARN must be provided if the
         *        call is from the replicated Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the traffic distribution group.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the traffic distribution group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the traffic distribution group.
         * </p>
         * 
         * @param name
         *        The name of the traffic distribution group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the traffic distribution group.
         * </p>
         * 
         * @param instanceArn
         *        The Amazon Resource Name (ARN) of the traffic distribution group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The status of the traffic distribution group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATION_IN_PROGRESS</code> means the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         * >CreateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> means the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         * >CreateTrafficDistributionGroup</a> operation has succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_FAILED</code> indicates that the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         * >CreateTrafficDistributionGroup</a> operation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_DELETION</code> means the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
         * >DeleteTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETION_FAILED</code> means the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
         * >DeleteTrafficDistributionGroup</a> operation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> means the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html"
         * >UpdateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the traffic distribution group. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATION_IN_PROGRESS</code> means the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         *        >CreateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> means the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         *        >CreateTrafficDistributionGroup</a> operation has succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_FAILED</code> indicates that the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         *        >CreateTrafficDistributionGroup</a> operation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_DELETION</code> means the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
         *        >DeleteTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETION_FAILED</code> means the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
         *        >DeleteTrafficDistributionGroup</a> operation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> means the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html"
         *        >UpdateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         *        </p>
         *        </li>
         * @see TrafficDistributionGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficDistributionGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the traffic distribution group.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATION_IN_PROGRESS</code> means the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         * >CreateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> means the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         * >CreateTrafficDistributionGroup</a> operation has succeeded.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATION_FAILED</code> indicates that the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         * >CreateTrafficDistributionGroup</a> operation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING_DELETION</code> means the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
         * >DeleteTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETION_FAILED</code> means the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
         * >DeleteTrafficDistributionGroup</a> operation has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATE_IN_PROGRESS</code> means the previous <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html"
         * >UpdateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the traffic distribution group. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATION_IN_PROGRESS</code> means the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         *        >CreateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> means the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         *        >CreateTrafficDistributionGroup</a> operation has succeeded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATION_FAILED</code> indicates that the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html"
         *        >CreateTrafficDistributionGroup</a> operation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING_DELETION</code> means the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
         *        >DeleteTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETION_FAILED</code> means the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html"
         *        >DeleteTrafficDistributionGroup</a> operation has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATE_IN_PROGRESS</code> means the previous <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html"
         *        >UpdateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.
         *        </p>
         *        </li>
         * @see TrafficDistributionGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrafficDistributionGroupStatus
         */
        Builder status(TrafficDistributionGroupStatus status);

        /**
         * <p>
         * Whether this is the default traffic distribution group created during instance replication. The default
         * traffic distribution group cannot be deleted by the <code>DeleteTrafficDistributionGroup</code> API. The
         * default traffic distribution group is deleted as part of the process for deleting a replica.
         * </p>
         * 
         * @param isDefault
         *        Whether this is the default traffic distribution group created during instance replication. The
         *        default traffic distribution group cannot be deleted by the
         *        <code>DeleteTrafficDistributionGroup</code> API. The default traffic distribution group is deleted as
         *        part of the process for deleting a replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String instanceArn;

        private String status;

        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficDistributionGroupSummary model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            instanceArn(model.instanceArn);
            status(model.status);
            isDefault(model.isDefault);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TrafficDistributionGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @Override
        public TrafficDistributionGroupSummary build() {
            return new TrafficDistributionGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
