/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that defines search criteria base on words or phrases, participants in the Contact Lens conversational
 * analytics transcript.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranscriptCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<TranscriptCriteria.Builder, TranscriptCriteria> {
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(TranscriptCriteria::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<List<String>> SEARCH_TEXT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SearchText")
            .getter(getter(TranscriptCriteria::searchText))
            .setter(setter(Builder::searchText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchText").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchType").getter(getter(TranscriptCriteria::matchTypeAsString)).setter(setter(Builder::matchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ROLE_FIELD,
            SEARCH_TEXT_FIELD, MATCH_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String participantRole;

    private final List<String> searchText;

    private final String matchType;

    private TranscriptCriteria(BuilderImpl builder) {
        this.participantRole = builder.participantRole;
        this.searchText = builder.searchText;
        this.matchType = builder.matchType;
    }

    /**
     * <p>
     * The participant role in a transcript
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The participant role in a transcript
     * @see ParticipantRole
     */
    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * The participant role in a transcript
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The participant role in a transcript
     * @see ParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the SearchText property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSearchText() {
        return searchText != null && !(searchText instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The words or phrases used to search within a transcript.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSearchText} method.
     * </p>
     * 
     * @return The words or phrases used to search within a transcript.
     */
    public final List<String> searchText() {
        return searchText;
    }

    /**
     * <p>
     * The match type combining search criteria using multiple search texts in a transcript criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link SearchContactsMatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchTypeAsString}.
     * </p>
     * 
     * @return The match type combining search criteria using multiple search texts in a transcript criteria.
     * @see SearchContactsMatchType
     */
    public final SearchContactsMatchType matchType() {
        return SearchContactsMatchType.fromValue(matchType);
    }

    /**
     * <p>
     * The match type combining search criteria using multiple search texts in a transcript criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link SearchContactsMatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #matchTypeAsString}.
     * </p>
     * 
     * @return The match type combining search criteria using multiple search texts in a transcript criteria.
     * @see SearchContactsMatchType
     */
    public final String matchTypeAsString() {
        return matchType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSearchText() ? searchText() : null);
        hashCode = 31 * hashCode + Objects.hashCode(matchTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptCriteria)) {
            return false;
        }
        TranscriptCriteria other = (TranscriptCriteria) obj;
        return Objects.equals(participantRoleAsString(), other.participantRoleAsString())
                && hasSearchText() == other.hasSearchText() && Objects.equals(searchText(), other.searchText())
                && Objects.equals(matchTypeAsString(), other.matchTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranscriptCriteria").add("ParticipantRole", participantRoleAsString())
                .add("SearchText", searchText() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MatchType", matchTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        case "SearchText":
            return Optional.ofNullable(clazz.cast(searchText()));
        case "MatchType":
            return Optional.ofNullable(clazz.cast(matchTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
        map.put("SearchText", SEARCH_TEXT_FIELD);
        map.put("MatchType", MATCH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TranscriptCriteria, T> g) {
        return obj -> g.apply((TranscriptCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranscriptCriteria> {
        /**
         * <p>
         * The participant role in a transcript
         * </p>
         * 
         * @param participantRole
         *        The participant role in a transcript
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * The participant role in a transcript
         * </p>
         * 
         * @param participantRole
         *        The participant role in a transcript
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(ParticipantRole participantRole);

        /**
         * <p>
         * The words or phrases used to search within a transcript.
         * </p>
         * 
         * @param searchText
         *        The words or phrases used to search within a transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchText(Collection<String> searchText);

        /**
         * <p>
         * The words or phrases used to search within a transcript.
         * </p>
         * 
         * @param searchText
         *        The words or phrases used to search within a transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchText(String... searchText);

        /**
         * <p>
         * The match type combining search criteria using multiple search texts in a transcript criteria.
         * </p>
         * 
         * @param matchType
         *        The match type combining search criteria using multiple search texts in a transcript criteria.
         * @see SearchContactsMatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchContactsMatchType
         */
        Builder matchType(String matchType);

        /**
         * <p>
         * The match type combining search criteria using multiple search texts in a transcript criteria.
         * </p>
         * 
         * @param matchType
         *        The match type combining search criteria using multiple search texts in a transcript criteria.
         * @see SearchContactsMatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchContactsMatchType
         */
        Builder matchType(SearchContactsMatchType matchType);
    }

    static final class BuilderImpl implements Builder {
        private String participantRole;

        private List<String> searchText = DefaultSdkAutoConstructList.getInstance();

        private String matchType;

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptCriteria model) {
            participantRole(model.participantRole);
            searchText(model.searchText);
            matchType(model.matchType);
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final Collection<String> getSearchText() {
            if (searchText instanceof SdkAutoConstructList) {
                return null;
            }
            return searchText;
        }

        public final void setSearchText(Collection<String> searchText) {
            this.searchText = SearchTextListCopier.copy(searchText);
        }

        @Override
        public final Builder searchText(Collection<String> searchText) {
            this.searchText = SearchTextListCopier.copy(searchText);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchText(String... searchText) {
            searchText(Arrays.asList(searchText));
            return this;
        }

        public final String getMatchType() {
            return matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(SearchContactsMatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        @Override
        public TranscriptCriteria build() {
            return new TranscriptCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
