/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactFlowModuleMetadataRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateContactFlowModuleMetadataRequest.Builder, UpdateContactFlowModuleMetadataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateContactFlowModuleMetadataRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_FLOW_MODULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowModuleId").getter(getter(UpdateContactFlowModuleMetadataRequest::contactFlowModuleId))
            .setter(setter(Builder::contactFlowModuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowModuleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateContactFlowModuleMetadataRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateContactFlowModuleMetadataRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateContactFlowModuleMetadataRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_FLOW_MODULE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String contactFlowModuleId;

    private final String name;

    private final String description;

    private final String state;

    private UpdateContactFlowModuleMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactFlowModuleId = builder.contactFlowModuleId;
        this.name = builder.name;
        this.description = builder.description;
        this.state = builder.state;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     * 
     * @return The identifier of the flow module.
     */
    public final String contactFlowModuleId() {
        return contactFlowModuleId;
    }

    /**
     * <p>
     * The name of the flow module.
     * </p>
     * 
     * @return The name of the flow module.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the flow module.
     * </p>
     * 
     * @return The description of the flow module.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The state of flow module.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ContactFlowModuleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of flow module.
     * @see ContactFlowModuleState
     */
    public final ContactFlowModuleState state() {
        return ContactFlowModuleState.fromValue(state);
    }

    /**
     * <p>
     * The state of flow module.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ContactFlowModuleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of flow module.
     * @see ContactFlowModuleState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactFlowModuleMetadataRequest)) {
            return false;
        }
        UpdateContactFlowModuleMetadataRequest other = (UpdateContactFlowModuleMetadataRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(contactFlowModuleId(), other.contactFlowModuleId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContactFlowModuleMetadataRequest").add("InstanceId", instanceId())
                .add("ContactFlowModuleId", contactFlowModuleId()).add("Name", name()).add("Description", description())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactFlowModuleId":
            return Optional.ofNullable(clazz.cast(contactFlowModuleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactFlowModuleId", CONTACT_FLOW_MODULE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactFlowModuleMetadataRequest, T> g) {
        return obj -> g.apply((UpdateContactFlowModuleMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateContactFlowModuleMetadataRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the flow module.
         * </p>
         * 
         * @param contactFlowModuleId
         *        The identifier of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleId(String contactFlowModuleId);

        /**
         * <p>
         * The name of the flow module.
         * </p>
         * 
         * @param name
         *        The name of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the flow module.
         * </p>
         * 
         * @param description
         *        The description of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The state of flow module.
         * </p>
         * 
         * @param state
         *        The state of flow module.
         * @see ContactFlowModuleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowModuleState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of flow module.
         * </p>
         * 
         * @param state
         *        The state of flow module.
         * @see ContactFlowModuleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactFlowModuleState
         */
        Builder state(ContactFlowModuleState state);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactFlowModuleId;

        private String name;

        private String description;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactFlowModuleMetadataRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactFlowModuleId(model.contactFlowModuleId);
            name(model.name);
            description(model.description);
            state(model.state);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactFlowModuleId() {
            return contactFlowModuleId;
        }

        public final void setContactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
        }

        @Override
        public final Builder contactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ContactFlowModuleState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactFlowModuleMetadataRequest build() {
            return new UpdateContactFlowModuleMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
