/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactRoutingDataRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateContactRoutingDataRequest.Builder, UpdateContactRoutingDataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateContactRoutingDataRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(UpdateContactRoutingDataRequest::contactId))
            .setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactId").build()).build();

    private static final SdkField<Integer> QUEUE_TIME_ADJUSTMENT_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("QueueTimeAdjustmentSeconds")
            .getter(getter(UpdateContactRoutingDataRequest::queueTimeAdjustmentSeconds))
            .setter(setter(Builder::queueTimeAdjustmentSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueTimeAdjustmentSeconds").build())
            .build();

    private static final SdkField<Long> QUEUE_PRIORITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("QueuePriority").getter(getter(UpdateContactRoutingDataRequest::queuePriority))
            .setter(setter(Builder::queuePriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueuePriority").build()).build();

    private static final SdkField<RoutingCriteriaInput> ROUTING_CRITERIA_FIELD = SdkField
            .<RoutingCriteriaInput> builder(MarshallingType.SDK_POJO).memberName("RoutingCriteria")
            .getter(getter(UpdateContactRoutingDataRequest::routingCriteria)).setter(setter(Builder::routingCriteria))
            .constructor(RoutingCriteriaInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_ID_FIELD, QUEUE_TIME_ADJUSTMENT_SECONDS_FIELD, QUEUE_PRIORITY_FIELD, ROUTING_CRITERIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String contactId;

    private final Integer queueTimeAdjustmentSeconds;

    private final Long queuePriority;

    private final RoutingCriteriaInput routingCriteria;

    private UpdateContactRoutingDataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.queueTimeAdjustmentSeconds = builder.queueTimeAdjustmentSeconds;
        this.queuePriority = builder.queuePriority;
        this.routingCriteria = builder.routingCriteria;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the contact in this instance of Amazon Connect.
     * </p>
     * 
     * @return The identifier of the contact in this instance of Amazon Connect.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The number of seconds to add or subtract from the contact's routing age. Contacts are routed to agents on a
     * first-come, first-serve basis. This means that changing their amount of time in queue compared to others also
     * changes their position in queue.
     * </p>
     * 
     * @return The number of seconds to add or subtract from the contact's routing age. Contacts are routed to agents on
     *         a first-come, first-serve basis. This means that changing their amount of time in queue compared to
     *         others also changes their position in queue.
     */
    public final Integer queueTimeAdjustmentSeconds() {
        return queueTimeAdjustmentSeconds;
    }

    /**
     * <p>
     * Priority of the contact in the queue. The default priority for new contacts is 5. You can raise the priority of a
     * contact compared to other contacts in the queue by assigning them a higher priority, such as 1 or 2.
     * </p>
     * 
     * @return Priority of the contact in the queue. The default priority for new contacts is 5. You can raise the
     *         priority of a contact compared to other contacts in the queue by assigning them a higher priority, such
     *         as 1 or 2.
     */
    public final Long queuePriority() {
        return queuePriority;
    }

    /**
     * <p>
     * Updates the routing criteria on the contact. These properties can be used to change how a&#x2028; contact is
     * routed within the queue.
     * </p>
     * 
     * @return Updates the routing criteria on the contact. These properties can be used to change how a&#x2028; contact
     *         is routed within the queue.
     */
    public final RoutingCriteriaInput routingCriteria() {
        return routingCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(queueTimeAdjustmentSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(queuePriority());
        hashCode = 31 * hashCode + Objects.hashCode(routingCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactRoutingDataRequest)) {
            return false;
        }
        UpdateContactRoutingDataRequest other = (UpdateContactRoutingDataRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(contactId(), other.contactId())
                && Objects.equals(queueTimeAdjustmentSeconds(), other.queueTimeAdjustmentSeconds())
                && Objects.equals(queuePriority(), other.queuePriority())
                && Objects.equals(routingCriteria(), other.routingCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContactRoutingDataRequest").add("InstanceId", instanceId()).add("ContactId", contactId())
                .add("QueueTimeAdjustmentSeconds", queueTimeAdjustmentSeconds()).add("QueuePriority", queuePriority())
                .add("RoutingCriteria", routingCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "QueueTimeAdjustmentSeconds":
            return Optional.ofNullable(clazz.cast(queueTimeAdjustmentSeconds()));
        case "QueuePriority":
            return Optional.ofNullable(clazz.cast(queuePriority()));
        case "RoutingCriteria":
            return Optional.ofNullable(clazz.cast(routingCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("QueueTimeAdjustmentSeconds", QUEUE_TIME_ADJUSTMENT_SECONDS_FIELD);
        map.put("QueuePriority", QUEUE_PRIORITY_FIELD);
        map.put("RoutingCriteria", ROUTING_CRITERIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactRoutingDataRequest, T> g) {
        return obj -> g.apply((UpdateContactRoutingDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContactRoutingDataRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the contact in this instance of Amazon Connect.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact in this instance of Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The number of seconds to add or subtract from the contact's routing age. Contacts are routed to agents on a
         * first-come, first-serve basis. This means that changing their amount of time in queue compared to others also
         * changes their position in queue.
         * </p>
         * 
         * @param queueTimeAdjustmentSeconds
         *        The number of seconds to add or subtract from the contact's routing age. Contacts are routed to agents
         *        on a first-come, first-serve basis. This means that changing their amount of time in queue compared to
         *        others also changes their position in queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueTimeAdjustmentSeconds(Integer queueTimeAdjustmentSeconds);

        /**
         * <p>
         * Priority of the contact in the queue. The default priority for new contacts is 5. You can raise the priority
         * of a contact compared to other contacts in the queue by assigning them a higher priority, such as 1 or 2.
         * </p>
         * 
         * @param queuePriority
         *        Priority of the contact in the queue. The default priority for new contacts is 5. You can raise the
         *        priority of a contact compared to other contacts in the queue by assigning them a higher priority,
         *        such as 1 or 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuePriority(Long queuePriority);

        /**
         * <p>
         * Updates the routing criteria on the contact. These properties can be used to change how a&#x2028; contact is
         * routed within the queue.
         * </p>
         * 
         * @param routingCriteria
         *        Updates the routing criteria on the contact. These properties can be used to change how a&#x2028;
         *        contact is routed within the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingCriteria(RoutingCriteriaInput routingCriteria);

        /**
         * <p>
         * Updates the routing criteria on the contact. These properties can be used to change how a&#x2028; contact is
         * routed within the queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoutingCriteriaInput.Builder} avoiding
         * the need to create one manually via {@link RoutingCriteriaInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoutingCriteriaInput.Builder#build()} is called immediately and
         * its result is passed to {@link #routingCriteria(RoutingCriteriaInput)}.
         * 
         * @param routingCriteria
         *        a consumer that will call methods on {@link RoutingCriteriaInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingCriteria(RoutingCriteriaInput)
         */
        default Builder routingCriteria(Consumer<RoutingCriteriaInput.Builder> routingCriteria) {
            return routingCriteria(RoutingCriteriaInput.builder().applyMutation(routingCriteria).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactId;

        private Integer queueTimeAdjustmentSeconds;

        private Long queuePriority;

        private RoutingCriteriaInput routingCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactRoutingDataRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactId(model.contactId);
            queueTimeAdjustmentSeconds(model.queueTimeAdjustmentSeconds);
            queuePriority(model.queuePriority);
            routingCriteria(model.routingCriteria);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final Integer getQueueTimeAdjustmentSeconds() {
            return queueTimeAdjustmentSeconds;
        }

        public final void setQueueTimeAdjustmentSeconds(Integer queueTimeAdjustmentSeconds) {
            this.queueTimeAdjustmentSeconds = queueTimeAdjustmentSeconds;
        }

        @Override
        public final Builder queueTimeAdjustmentSeconds(Integer queueTimeAdjustmentSeconds) {
            this.queueTimeAdjustmentSeconds = queueTimeAdjustmentSeconds;
            return this;
        }

        public final Long getQueuePriority() {
            return queuePriority;
        }

        public final void setQueuePriority(Long queuePriority) {
            this.queuePriority = queuePriority;
        }

        @Override
        public final Builder queuePriority(Long queuePriority) {
            this.queuePriority = queuePriority;
            return this;
        }

        public final RoutingCriteriaInput.Builder getRoutingCriteria() {
            return routingCriteria != null ? routingCriteria.toBuilder() : null;
        }

        public final void setRoutingCriteria(RoutingCriteriaInput.BuilderImpl routingCriteria) {
            this.routingCriteria = routingCriteria != null ? routingCriteria.build() : null;
        }

        @Override
        public final Builder routingCriteria(RoutingCriteriaInput routingCriteria) {
            this.routingCriteria = routingCriteria;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactRoutingDataRequest build() {
            return new UpdateContactRoutingDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
