/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateParticipantAuthenticationRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateParticipantAuthenticationRequest.Builder, UpdateParticipantAuthenticationRequest> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateParticipantAuthenticationRequest::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateParticipantAuthenticationRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(UpdateParticipantAuthenticationRequest::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(UpdateParticipantAuthenticationRequest::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<String> ERROR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorDescription").getter(getter(UpdateParticipantAuthenticationRequest::errorDescription))
            .setter(setter(Builder::errorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            INSTANCE_ID_FIELD, CODE_FIELD, ERROR_FIELD, ERROR_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String state;

    private final String instanceId;

    private final String code;

    private final String error;

    private final String errorDescription;

    private UpdateParticipantAuthenticationRequest(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.instanceId = builder.instanceId;
        this.code = builder.code;
        this.error = builder.error;
        this.errorDescription = builder.errorDescription;
    }

    /**
     * <p>
     * The <code>state</code> query parameter that was provided by Cognito in the <code>redirectUri</code>. This will
     * also match the <code>state</code> parameter provided in the <code>AuthenticationUrl</code> from the <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetAuthenticationUrl.html"
     * >GetAuthenticationUrl</a> response.
     * </p>
     * 
     * @return The <code>state</code> query parameter that was provided by Cognito in the <code>redirectUri</code>. This
     *         will also match the <code>state</code> parameter provided in the <code>AuthenticationUrl</code> from the
     *         <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetAuthenticationUrl.html">
     *         GetAuthenticationUrl</a> response.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The <code>code</code> query parameter provided by Cognito in the <code>redirectUri</code>.
     * </p>
     * 
     * @return The <code>code</code> query parameter provided by Cognito in the <code>redirectUri</code>.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The <code>error</code> query parameter provided by Cognito in the <code>redirectUri</code>.
     * </p>
     * 
     * @return The <code>error</code> query parameter provided by Cognito in the <code>redirectUri</code>.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * The <code>error_description</code> parameter provided by Cognito in the <code>redirectUri</code>.
     * </p>
     * 
     * @return The <code>error_description</code> parameter provided by Cognito in the <code>redirectUri</code>.
     */
    public final String errorDescription() {
        return errorDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(errorDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParticipantAuthenticationRequest)) {
            return false;
        }
        UpdateParticipantAuthenticationRequest other = (UpdateParticipantAuthenticationRequest) obj;
        return Objects.equals(state(), other.state()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(code(), other.code()) && Objects.equals(error(), other.error())
                && Objects.equals(errorDescription(), other.errorDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateParticipantAuthenticationRequest").add("State", state()).add("InstanceId", instanceId())
                .add("Code", code() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Error", error() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ErrorDescription", errorDescription() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "ErrorDescription":
            return Optional.ofNullable(clazz.cast(errorDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("ErrorDescription", ERROR_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateParticipantAuthenticationRequest, T> g) {
        return obj -> g.apply((UpdateParticipantAuthenticationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateParticipantAuthenticationRequest> {
        /**
         * <p>
         * The <code>state</code> query parameter that was provided by Cognito in the <code>redirectUri</code>. This
         * will also match the <code>state</code> parameter provided in the <code>AuthenticationUrl</code> from the <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetAuthenticationUrl.html">
         * GetAuthenticationUrl</a> response.
         * </p>
         * 
         * @param state
         *        The <code>state</code> query parameter that was provided by Cognito in the <code>redirectUri</code>.
         *        This will also match the <code>state</code> parameter provided in the <code>AuthenticationUrl</code>
         *        from the <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetAuthenticationUrl.html"
         *        >GetAuthenticationUrl</a> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The <code>code</code> query parameter provided by Cognito in the <code>redirectUri</code>.
         * </p>
         * 
         * @param code
         *        The <code>code</code> query parameter provided by Cognito in the <code>redirectUri</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The <code>error</code> query parameter provided by Cognito in the <code>redirectUri</code>.
         * </p>
         * 
         * @param error
         *        The <code>error</code> query parameter provided by Cognito in the <code>redirectUri</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The <code>error_description</code> parameter provided by Cognito in the <code>redirectUri</code>.
         * </p>
         * 
         * @param errorDescription
         *        The <code>error_description</code> parameter provided by Cognito in the <code>redirectUri</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDescription(String errorDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String state;

        private String instanceId;

        private String code;

        private String error;

        private String errorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParticipantAuthenticationRequest model) {
            super(model);
            state(model.state);
            instanceId(model.instanceId);
            code(model.code);
            error(model.error);
            errorDescription(model.errorDescription);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getErrorDescription() {
            return errorDescription;
        }

        public final void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        @Override
        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateParticipantAuthenticationRequest build() {
            return new UpdateParticipantAuthenticationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
