/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQuickConnectConfigRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateQuickConnectConfigRequest.Builder, UpdateQuickConnectConfigRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateQuickConnectConfigRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> QUICK_CONNECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuickConnectId").getter(getter(UpdateQuickConnectConfigRequest::quickConnectId))
            .setter(setter(Builder::quickConnectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("QuickConnectId").build()).build();

    private static final SdkField<QuickConnectConfig> QUICK_CONNECT_CONFIG_FIELD = SdkField
            .<QuickConnectConfig> builder(MarshallingType.SDK_POJO).memberName("QuickConnectConfig")
            .getter(getter(UpdateQuickConnectConfigRequest::quickConnectConfig)).setter(setter(Builder::quickConnectConfig))
            .constructor(QuickConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            QUICK_CONNECT_ID_FIELD, QUICK_CONNECT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String quickConnectId;

    private final QuickConnectConfig quickConnectConfig;

    private UpdateQuickConnectConfigRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.quickConnectId = builder.quickConnectId;
        this.quickConnectConfig = builder.quickConnectConfig;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier for the quick connect.
     * </p>
     * 
     * @return The identifier for the quick connect.
     */
    public final String quickConnectId() {
        return quickConnectId;
    }

    /**
     * <p>
     * Information about the configuration settings for the quick connect.
     * </p>
     * 
     * @return Information about the configuration settings for the quick connect.
     */
    public final QuickConnectConfig quickConnectConfig() {
        return quickConnectConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(quickConnectId());
        hashCode = 31 * hashCode + Objects.hashCode(quickConnectConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQuickConnectConfigRequest)) {
            return false;
        }
        UpdateQuickConnectConfigRequest other = (UpdateQuickConnectConfigRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(quickConnectId(), other.quickConnectId())
                && Objects.equals(quickConnectConfig(), other.quickConnectConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQuickConnectConfigRequest").add("InstanceId", instanceId())
                .add("QuickConnectId", quickConnectId()).add("QuickConnectConfig", quickConnectConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "QuickConnectId":
            return Optional.ofNullable(clazz.cast(quickConnectId()));
        case "QuickConnectConfig":
            return Optional.ofNullable(clazz.cast(quickConnectConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("QuickConnectId", QUICK_CONNECT_ID_FIELD);
        map.put("QuickConnectConfig", QUICK_CONNECT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQuickConnectConfigRequest, T> g) {
        return obj -> g.apply((UpdateQuickConnectConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateQuickConnectConfigRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier for the quick connect.
         * </p>
         * 
         * @param quickConnectId
         *        The identifier for the quick connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectId(String quickConnectId);

        /**
         * <p>
         * Information about the configuration settings for the quick connect.
         * </p>
         * 
         * @param quickConnectConfig
         *        Information about the configuration settings for the quick connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickConnectConfig(QuickConnectConfig quickConnectConfig);

        /**
         * <p>
         * Information about the configuration settings for the quick connect.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuickConnectConfig.Builder} avoiding the
         * need to create one manually via {@link QuickConnectConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickConnectConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #quickConnectConfig(QuickConnectConfig)}.
         * 
         * @param quickConnectConfig
         *        a consumer that will call methods on {@link QuickConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quickConnectConfig(QuickConnectConfig)
         */
        default Builder quickConnectConfig(Consumer<QuickConnectConfig.Builder> quickConnectConfig) {
            return quickConnectConfig(QuickConnectConfig.builder().applyMutation(quickConnectConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String quickConnectId;

        private QuickConnectConfig quickConnectConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQuickConnectConfigRequest model) {
            super(model);
            instanceId(model.instanceId);
            quickConnectId(model.quickConnectId);
            quickConnectConfig(model.quickConnectConfig);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getQuickConnectId() {
            return quickConnectId;
        }

        public final void setQuickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
        }

        @Override
        public final Builder quickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
            return this;
        }

        public final QuickConnectConfig.Builder getQuickConnectConfig() {
            return quickConnectConfig != null ? quickConnectConfig.toBuilder() : null;
        }

        public final void setQuickConnectConfig(QuickConnectConfig.BuilderImpl quickConnectConfig) {
            this.quickConnectConfig = quickConnectConfig != null ? quickConnectConfig.build() : null;
        }

        @Override
        public final Builder quickConnectConfig(QuickConnectConfig quickConnectConfig) {
            this.quickConnectConfig = quickConnectConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQuickConnectConfigRequest build() {
            return new UpdateQuickConnectConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
