/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for the user data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserDataFilters implements SdkPojo, Serializable, ToCopyableBuilder<UserDataFilters.Builder, UserDataFilters> {
    private static final SdkField<List<String>> QUEUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Queues")
            .getter(getter(UserDataFilters::queues))
            .setter(setter(Builder::queues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ContactFilter> CONTACT_FILTER_FIELD = SdkField
            .<ContactFilter> builder(MarshallingType.SDK_POJO).memberName("ContactFilter")
            .getter(getter(UserDataFilters::contactFilter)).setter(setter(Builder::contactFilter))
            .constructor(ContactFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFilter").build()).build();

    private static final SdkField<List<String>> ROUTING_PROFILES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RoutingProfiles")
            .getter(getter(UserDataFilters::routingProfiles))
            .setter(setter(Builder::routingProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AGENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Agents")
            .getter(getter(UserDataFilters::agents))
            .setter(setter(Builder::agents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USER_HIERARCHY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserHierarchyGroups")
            .getter(getter(UserDataFilters::userHierarchyGroups))
            .setter(setter(Builder::userHierarchyGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserHierarchyGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUES_FIELD,
            CONTACT_FILTER_FIELD, ROUTING_PROFILES_FIELD, AGENTS_FIELD, USER_HIERARCHY_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> queues;

    private final ContactFilter contactFilter;

    private final List<String> routingProfiles;

    private final List<String> agents;

    private final List<String> userHierarchyGroups;

    private UserDataFilters(BuilderImpl builder) {
        this.queues = builder.queues;
        this.contactFilter = builder.contactFilter;
        this.routingProfiles = builder.routingProfiles;
        this.agents = builder.agents;
        this.userHierarchyGroups = builder.userHierarchyGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueues() {
        return queues != null && !(queues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 queues or ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueues} method.
     * </p>
     * 
     * @return A list of up to 100 queues or ARNs.
     */
    public final List<String> queues() {
        return queues;
    }

    /**
     * <p>
     * A filter for the user data based on the contact information that is associated to the user. It contains a list of
     * contact states.
     * </p>
     * 
     * @return A filter for the user data based on the contact information that is associated to the user. It contains a
     *         list of contact states.
     */
    public final ContactFilter contactFilter() {
        return contactFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingProfiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutingProfiles() {
        return routingProfiles != null && !(routingProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 routing profile IDs or ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingProfiles} method.
     * </p>
     * 
     * @return A list of up to 100 routing profile IDs or ARNs.
     */
    public final List<String> routingProfiles() {
        return routingProfiles;
    }

    /**
     * For responses, this returns true if the service returned a value for the Agents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgents() {
        return agents != null && !(agents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 100 agent IDs or ARNs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgents} method.
     * </p>
     * 
     * @return A list of up to 100 agent IDs or ARNs.
     */
    public final List<String> agents() {
        return agents;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserHierarchyGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserHierarchyGroups() {
        return userHierarchyGroups != null && !(userHierarchyGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A UserHierarchyGroup ID or ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserHierarchyGroups} method.
     * </p>
     * 
     * @return A UserHierarchyGroup ID or ARN.
     */
    public final List<String> userHierarchyGroups() {
        return userHierarchyGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasQueues() ? queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contactFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingProfiles() ? routingProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAgents() ? agents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserHierarchyGroups() ? userHierarchyGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDataFilters)) {
            return false;
        }
        UserDataFilters other = (UserDataFilters) obj;
        return hasQueues() == other.hasQueues() && Objects.equals(queues(), other.queues())
                && Objects.equals(contactFilter(), other.contactFilter()) && hasRoutingProfiles() == other.hasRoutingProfiles()
                && Objects.equals(routingProfiles(), other.routingProfiles()) && hasAgents() == other.hasAgents()
                && Objects.equals(agents(), other.agents()) && hasUserHierarchyGroups() == other.hasUserHierarchyGroups()
                && Objects.equals(userHierarchyGroups(), other.userHierarchyGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserDataFilters").add("Queues", hasQueues() ? queues() : null)
                .add("ContactFilter", contactFilter()).add("RoutingProfiles", hasRoutingProfiles() ? routingProfiles() : null)
                .add("Agents", hasAgents() ? agents() : null)
                .add("UserHierarchyGroups", hasUserHierarchyGroups() ? userHierarchyGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Queues":
            return Optional.ofNullable(clazz.cast(queues()));
        case "ContactFilter":
            return Optional.ofNullable(clazz.cast(contactFilter()));
        case "RoutingProfiles":
            return Optional.ofNullable(clazz.cast(routingProfiles()));
        case "Agents":
            return Optional.ofNullable(clazz.cast(agents()));
        case "UserHierarchyGroups":
            return Optional.ofNullable(clazz.cast(userHierarchyGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Queues", QUEUES_FIELD);
        map.put("ContactFilter", CONTACT_FILTER_FIELD);
        map.put("RoutingProfiles", ROUTING_PROFILES_FIELD);
        map.put("Agents", AGENTS_FIELD);
        map.put("UserHierarchyGroups", USER_HIERARCHY_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserDataFilters, T> g) {
        return obj -> g.apply((UserDataFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserDataFilters> {
        /**
         * <p>
         * A list of up to 100 queues or ARNs.
         * </p>
         * 
         * @param queues
         *        A list of up to 100 queues or ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(Collection<String> queues);

        /**
         * <p>
         * A list of up to 100 queues or ARNs.
         * </p>
         * 
         * @param queues
         *        A list of up to 100 queues or ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(String... queues);

        /**
         * <p>
         * A filter for the user data based on the contact information that is associated to the user. It contains a
         * list of contact states.
         * </p>
         * 
         * @param contactFilter
         *        A filter for the user data based on the contact information that is associated to the user. It
         *        contains a list of contact states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFilter(ContactFilter contactFilter);

        /**
         * <p>
         * A filter for the user data based on the contact information that is associated to the user. It contains a
         * list of contact states.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactFilter.Builder} avoiding the need
         * to create one manually via {@link ContactFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #contactFilter(ContactFilter)}.
         * 
         * @param contactFilter
         *        a consumer that will call methods on {@link ContactFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contactFilter(ContactFilter)
         */
        default Builder contactFilter(Consumer<ContactFilter.Builder> contactFilter) {
            return contactFilter(ContactFilter.builder().applyMutation(contactFilter).build());
        }

        /**
         * <p>
         * A list of up to 100 routing profile IDs or ARNs.
         * </p>
         * 
         * @param routingProfiles
         *        A list of up to 100 routing profile IDs or ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfiles(Collection<String> routingProfiles);

        /**
         * <p>
         * A list of up to 100 routing profile IDs or ARNs.
         * </p>
         * 
         * @param routingProfiles
         *        A list of up to 100 routing profile IDs or ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfiles(String... routingProfiles);

        /**
         * <p>
         * A list of up to 100 agent IDs or ARNs.
         * </p>
         * 
         * @param agents
         *        A list of up to 100 agent IDs or ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agents(Collection<String> agents);

        /**
         * <p>
         * A list of up to 100 agent IDs or ARNs.
         * </p>
         * 
         * @param agents
         *        A list of up to 100 agent IDs or ARNs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agents(String... agents);

        /**
         * <p>
         * A UserHierarchyGroup ID or ARN.
         * </p>
         * 
         * @param userHierarchyGroups
         *        A UserHierarchyGroup ID or ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userHierarchyGroups(Collection<String> userHierarchyGroups);

        /**
         * <p>
         * A UserHierarchyGroup ID or ARN.
         * </p>
         * 
         * @param userHierarchyGroups
         *        A UserHierarchyGroup ID or ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userHierarchyGroups(String... userHierarchyGroups);
    }

    static final class BuilderImpl implements Builder {
        private List<String> queues = DefaultSdkAutoConstructList.getInstance();

        private ContactFilter contactFilter;

        private List<String> routingProfiles = DefaultSdkAutoConstructList.getInstance();

        private List<String> agents = DefaultSdkAutoConstructList.getInstance();

        private List<String> userHierarchyGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserDataFilters model) {
            queues(model.queues);
            contactFilter(model.contactFilter);
            routingProfiles(model.routingProfiles);
            agents(model.agents);
            userHierarchyGroups(model.userHierarchyGroups);
        }

        public final Collection<String> getQueues() {
            if (queues instanceof SdkAutoConstructList) {
                return null;
            }
            return queues;
        }

        public final void setQueues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
        }

        @Override
        public final Builder queues(Collection<String> queues) {
            this.queues = QueuesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(String... queues) {
            queues(Arrays.asList(queues));
            return this;
        }

        public final ContactFilter.Builder getContactFilter() {
            return contactFilter != null ? contactFilter.toBuilder() : null;
        }

        public final void setContactFilter(ContactFilter.BuilderImpl contactFilter) {
            this.contactFilter = contactFilter != null ? contactFilter.build() : null;
        }

        @Override
        public final Builder contactFilter(ContactFilter contactFilter) {
            this.contactFilter = contactFilter;
            return this;
        }

        public final Collection<String> getRoutingProfiles() {
            if (routingProfiles instanceof SdkAutoConstructList) {
                return null;
            }
            return routingProfiles;
        }

        public final void setRoutingProfiles(Collection<String> routingProfiles) {
            this.routingProfiles = RoutingProfilesCopier.copy(routingProfiles);
        }

        @Override
        public final Builder routingProfiles(Collection<String> routingProfiles) {
            this.routingProfiles = RoutingProfilesCopier.copy(routingProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfiles(String... routingProfiles) {
            routingProfiles(Arrays.asList(routingProfiles));
            return this;
        }

        public final Collection<String> getAgents() {
            if (agents instanceof SdkAutoConstructList) {
                return null;
            }
            return agents;
        }

        public final void setAgents(Collection<String> agents) {
            this.agents = AgentsMinOneMaxHundredCopier.copy(agents);
        }

        @Override
        public final Builder agents(Collection<String> agents) {
            this.agents = AgentsMinOneMaxHundredCopier.copy(agents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agents(String... agents) {
            agents(Arrays.asList(agents));
            return this;
        }

        public final Collection<String> getUserHierarchyGroups() {
            if (userHierarchyGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return userHierarchyGroups;
        }

        public final void setUserHierarchyGroups(Collection<String> userHierarchyGroups) {
            this.userHierarchyGroups = UserDataHierarchyGroupsCopier.copy(userHierarchyGroups);
        }

        @Override
        public final Builder userHierarchyGroups(Collection<String> userHierarchyGroups) {
            this.userHierarchyGroups = UserDataHierarchyGroupsCopier.copy(userHierarchyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userHierarchyGroups(String... userHierarchyGroups) {
            userHierarchyGroups(Arrays.asList(userHierarchyGroups));
            return this;
        }

        @Override
        public UserDataFilters build() {
            return new UserDataFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
