/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about proficiency of a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserProficiency implements SdkPojo, Serializable, ToCopyableBuilder<UserProficiency.Builder, UserProficiency> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(UserProficiency::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeValue").getter(getter(UserProficiency::attributeValue)).setter(setter(Builder::attributeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()).build();

    private static final SdkField<Float> LEVEL_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("Level")
            .getter(getter(UserProficiency::level)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            ATTRIBUTE_VALUE_FIELD, LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String attributeValue;

    private final Float level;

    private UserProficiency(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
        this.level = builder.level;
    }

    /**
     * <p>
     * The name of user's proficiency. You must use name of predefined attribute present in the Amazon Connect instance.
     * </p>
     * 
     * @return The name of user's proficiency. You must use name of predefined attribute present in the Amazon Connect
     *         instance.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * The value of user's proficiency. You must use value of predefined attribute present in the Amazon Connect
     * instance.
     * </p>
     * 
     * @return The value of user's proficiency. You must use value of predefined attribute present in the Amazon Connect
     *         instance.
     */
    public final String attributeValue() {
        return attributeValue;
    }

    /**
     * <p>
     * The level of the proficiency. The valid values are 1, 2, 3, 4 and 5.
     * </p>
     * 
     * @return The level of the proficiency. The valid values are 1, 2, 3, 4 and 5.
     */
    public final Float level() {
        return level;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValue());
        hashCode = 31 * hashCode + Objects.hashCode(level());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserProficiency)) {
            return false;
        }
        UserProficiency other = (UserProficiency) obj;
        return Objects.equals(attributeName(), other.attributeName()) && Objects.equals(attributeValue(), other.attributeValue())
                && Objects.equals(level(), other.level());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserProficiency").add("AttributeName", attributeName()).add("AttributeValue", attributeValue())
                .add("Level", level()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "AttributeValue":
            return Optional.ofNullable(clazz.cast(attributeValue()));
        case "Level":
            return Optional.ofNullable(clazz.cast(level()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("AttributeValue", ATTRIBUTE_VALUE_FIELD);
        map.put("Level", LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserProficiency, T> g) {
        return obj -> g.apply((UserProficiency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserProficiency> {
        /**
         * <p>
         * The name of user's proficiency. You must use name of predefined attribute present in the Amazon Connect
         * instance.
         * </p>
         * 
         * @param attributeName
         *        The name of user's proficiency. You must use name of predefined attribute present in the Amazon
         *        Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * The value of user's proficiency. You must use value of predefined attribute present in the Amazon Connect
         * instance.
         * </p>
         * 
         * @param attributeValue
         *        The value of user's proficiency. You must use value of predefined attribute present in the Amazon
         *        Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValue(String attributeValue);

        /**
         * <p>
         * The level of the proficiency. The valid values are 1, 2, 3, 4 and 5.
         * </p>
         * 
         * @param level
         *        The level of the proficiency. The valid values are 1, 2, 3, 4 and 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level(Float level);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String attributeValue;

        private Float level;

        private BuilderImpl() {
        }

        private BuilderImpl(UserProficiency model) {
            attributeName(model.attributeName);
            attributeValue(model.attributeValue);
            level(model.level);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final String getAttributeValue() {
            return attributeValue;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final Float getLevel() {
            return level;
        }

        public final void setLevel(Float level) {
            this.level = level;
        }

        @Override
        public final Builder level(Float level) {
            this.level = level;
            return this;
        }

        @Override
        public UserProficiency build() {
            return new UserProficiency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
