/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters to be applied to search results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserSearchFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<UserSearchFilter.Builder, UserSearchFilter> {
    private static final SdkField<ControlPlaneTagFilter> TAG_FILTER_FIELD = SdkField
            .<ControlPlaneTagFilter> builder(MarshallingType.SDK_POJO).memberName("TagFilter")
            .getter(getter(UserSearchFilter::tagFilter)).setter(setter(Builder::tagFilter))
            .constructor(ControlPlaneTagFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagFilter").build()).build();

    private static final SdkField<ControlPlaneUserAttributeFilter> USER_ATTRIBUTE_FILTER_FIELD = SdkField
            .<ControlPlaneUserAttributeFilter> builder(MarshallingType.SDK_POJO).memberName("UserAttributeFilter")
            .getter(getter(UserSearchFilter::userAttributeFilter)).setter(setter(Builder::userAttributeFilter))
            .constructor(ControlPlaneUserAttributeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributeFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_FILTER_FIELD,
            USER_ATTRIBUTE_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ControlPlaneTagFilter tagFilter;

    private final ControlPlaneUserAttributeFilter userAttributeFilter;

    private UserSearchFilter(BuilderImpl builder) {
        this.tagFilter = builder.tagFilter;
        this.userAttributeFilter = builder.userAttributeFilter;
    }

    /**
     * Returns the value of the TagFilter property for this object.
     * 
     * @return The value of the TagFilter property for this object.
     */
    public final ControlPlaneTagFilter tagFilter() {
        return tagFilter;
    }

    /**
     * <p>
     * An object that can be used to specify Tag conditions or Hierarchy Group conditions inside the SearchFilter.
     * </p>
     * <p>
     * This accepts an <code>OR</code> of <code>AND</code> (List of List) input where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     * </p>
     * </li>
     * <li>
     * <p>
     * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Only one field can be populated. This object can’t be used along with TagFilter. Request can either contain
     * TagFilter or UserAttributeFilter if SearchFilter is specified, combination of both is not supported and such
     * request will throw AccessDeniedException.
     * </p>
     * </note>
     * 
     * @return An object that can be used to specify Tag conditions or Hierarchy Group conditions inside the
     *         SearchFilter.</p>
     *         <p>
     *         This accepts an <code>OR</code> of <code>AND</code> (List of List) input where:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The top level list specifies conditions that need to be applied with <code>OR</code> operator.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The inner list specifies conditions that need to be applied with <code>AND</code> operator.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Only one field can be populated. This object can’t be used along with TagFilter. Request can either
     *         contain TagFilter or UserAttributeFilter if SearchFilter is specified, combination of both is not
     *         supported and such request will throw AccessDeniedException.
     *         </p>
     */
    public final ControlPlaneUserAttributeFilter userAttributeFilter() {
        return userAttributeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tagFilter());
        hashCode = 31 * hashCode + Objects.hashCode(userAttributeFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSearchFilter)) {
            return false;
        }
        UserSearchFilter other = (UserSearchFilter) obj;
        return Objects.equals(tagFilter(), other.tagFilter())
                && Objects.equals(userAttributeFilter(), other.userAttributeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserSearchFilter").add("TagFilter", tagFilter())
                .add("UserAttributeFilter", userAttributeFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagFilter":
            return Optional.ofNullable(clazz.cast(tagFilter()));
        case "UserAttributeFilter":
            return Optional.ofNullable(clazz.cast(userAttributeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TagFilter", TAG_FILTER_FIELD);
        map.put("UserAttributeFilter", USER_ATTRIBUTE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserSearchFilter, T> g) {
        return obj -> g.apply((UserSearchFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserSearchFilter> {
        /**
         * Sets the value of the TagFilter property for this object.
         *
         * @param tagFilter
         *        The new value for the TagFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagFilter(ControlPlaneTagFilter tagFilter);

        /**
         * Sets the value of the TagFilter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ControlPlaneTagFilter.Builder} avoiding
         * the need to create one manually via {@link ControlPlaneTagFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ControlPlaneTagFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #tagFilter(ControlPlaneTagFilter)}.
         * 
         * @param tagFilter
         *        a consumer that will call methods on {@link ControlPlaneTagFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagFilter(ControlPlaneTagFilter)
         */
        default Builder tagFilter(Consumer<ControlPlaneTagFilter.Builder> tagFilter) {
            return tagFilter(ControlPlaneTagFilter.builder().applyMutation(tagFilter).build());
        }

        /**
         * <p>
         * An object that can be used to specify Tag conditions or Hierarchy Group conditions inside the SearchFilter.
         * </p>
         * <p>
         * This accepts an <code>OR</code> of <code>AND</code> (List of List) input where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Only one field can be populated. This object can’t be used along with TagFilter. Request can either contain
         * TagFilter or UserAttributeFilter if SearchFilter is specified, combination of both is not supported and such
         * request will throw AccessDeniedException.
         * </p>
         * </note>
         * 
         * @param userAttributeFilter
         *        An object that can be used to specify Tag conditions or Hierarchy Group conditions inside the
         *        SearchFilter.</p>
         *        <p>
         *        This accepts an <code>OR</code> of <code>AND</code> (List of List) input where:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The top level list specifies conditions that need to be applied with <code>OR</code> operator.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The inner list specifies conditions that need to be applied with <code>AND</code> operator.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Only one field can be populated. This object can’t be used along with TagFilter. Request can either
         *        contain TagFilter or UserAttributeFilter if SearchFilter is specified, combination of both is not
         *        supported and such request will throw AccessDeniedException.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttributeFilter(ControlPlaneUserAttributeFilter userAttributeFilter);

        /**
         * <p>
         * An object that can be used to specify Tag conditions or Hierarchy Group conditions inside the SearchFilter.
         * </p>
         * <p>
         * This accepts an <code>OR</code> of <code>AND</code> (List of List) input where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The top level list specifies conditions that need to be applied with <code>OR</code> operator.
         * </p>
         * </li>
         * <li>
         * <p>
         * The inner list specifies conditions that need to be applied with <code>AND</code> operator.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Only one field can be populated. This object can’t be used along with TagFilter. Request can either contain
         * TagFilter or UserAttributeFilter if SearchFilter is specified, combination of both is not supported and such
         * request will throw AccessDeniedException.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link ControlPlaneUserAttributeFilter.Builder} avoiding the need to create one manually via
         * {@link ControlPlaneUserAttributeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ControlPlaneUserAttributeFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #userAttributeFilter(ControlPlaneUserAttributeFilter)}.
         * 
         * @param userAttributeFilter
         *        a consumer that will call methods on {@link ControlPlaneUserAttributeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userAttributeFilter(ControlPlaneUserAttributeFilter)
         */
        default Builder userAttributeFilter(Consumer<ControlPlaneUserAttributeFilter.Builder> userAttributeFilter) {
            return userAttributeFilter(ControlPlaneUserAttributeFilter.builder().applyMutation(userAttributeFilter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ControlPlaneTagFilter tagFilter;

        private ControlPlaneUserAttributeFilter userAttributeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSearchFilter model) {
            tagFilter(model.tagFilter);
            userAttributeFilter(model.userAttributeFilter);
        }

        public final ControlPlaneTagFilter.Builder getTagFilter() {
            return tagFilter != null ? tagFilter.toBuilder() : null;
        }

        public final void setTagFilter(ControlPlaneTagFilter.BuilderImpl tagFilter) {
            this.tagFilter = tagFilter != null ? tagFilter.build() : null;
        }

        @Override
        public final Builder tagFilter(ControlPlaneTagFilter tagFilter) {
            this.tagFilter = tagFilter;
            return this;
        }

        public final ControlPlaneUserAttributeFilter.Builder getUserAttributeFilter() {
            return userAttributeFilter != null ? userAttributeFilter.toBuilder() : null;
        }

        public final void setUserAttributeFilter(ControlPlaneUserAttributeFilter.BuilderImpl userAttributeFilter) {
            this.userAttributeFilter = userAttributeFilter != null ? userAttributeFilter.build() : null;
        }

        @Override
        public final Builder userAttributeFilter(ControlPlaneUserAttributeFilter userAttributeFilter) {
            this.userAttributeFilter = userAttributeFilter;
            return this;
        }

        @Override
        public UserSearchFilter build() {
            return new UserSearchFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
