/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a view version's metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ViewVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ViewVersionSummary.Builder, ViewVersionSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ViewVersionSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ViewVersionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ViewVersionSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ViewVersionSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ViewVersionSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Version").getter(getter(ViewVersionSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(ViewVersionSummary::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, TYPE_FIELD, VERSION_FIELD, VERSION_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String description;

    private final String name;

    private final String type;

    private final Integer version;

    private final String versionDescription;

    private ViewVersionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.description = builder.description;
        this.name = builder.name;
        this.type = builder.type;
        this.version = builder.version;
        this.versionDescription = builder.versionDescription;
    }

    /**
     * <p>
     * The identifier of the view version.
     * </p>
     * 
     * @return The identifier of the view version.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the view version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the view version.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description of the view version.
     * </p>
     * 
     * @return The description of the view version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the view version.
     * </p>
     * 
     * @return The name of the view version.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the view version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the view version.
     * @see ViewType
     */
    public final ViewType type() {
        return ViewType.fromValue(type);
    }

    /**
     * <p>
     * The type of the view version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ViewType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the view version.
     * @see ViewType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The sequentially incremented version of the view version.
     * </p>
     * 
     * @return The sequentially incremented version of the view version.
     */
    public final Integer version() {
        return version;
    }

    /**
     * <p>
     * The description of the view version.
     * </p>
     * 
     * @return The description of the view version.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewVersionSummary)) {
            return false;
        }
        ViewVersionSummary other = (ViewVersionSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(version(), other.version())
                && Objects.equals(versionDescription(), other.versionDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ViewVersionSummary").add("Id", id()).add("Arn", arn()).add("Description", description())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("Version", version()).add("VersionDescription", versionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ViewVersionSummary, T> g) {
        return obj -> g.apply((ViewVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ViewVersionSummary> {
        /**
         * <p>
         * The identifier of the view version.
         * </p>
         * 
         * @param id
         *        The identifier of the view version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the view version.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the view version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description of the view version.
         * </p>
         * 
         * @param description
         *        The description of the view version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the view version.
         * </p>
         * 
         * @param name
         *        The name of the view version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the view version.
         * </p>
         * 
         * @param type
         *        The type of the view version.
         * @see ViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the view version.
         * </p>
         * 
         * @param type
         *        The type of the view version.
         * @see ViewType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ViewType
         */
        Builder type(ViewType type);

        /**
         * <p>
         * The sequentially incremented version of the view version.
         * </p>
         * 
         * @param version
         *        The sequentially incremented version of the view version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * The description of the view version.
         * </p>
         * 
         * @param versionDescription
         *        The description of the view version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String description;

        private String name;

        private String type;

        private Integer version;

        private String versionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewVersionSummary model) {
            id(model.id);
            arn(model.arn);
            description(model.description);
            name(model.name);
            type(model.type);
            version(model.version);
            versionDescription(model.versionDescription);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ViewType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        @Override
        public ViewVersionSummary build() {
            return new ViewVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
