/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ContactState;
import software.amazon.awssdk.services.connect.model.ContactStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactFilter> {
    private static final SdkField<List<String>> CONTACT_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactStates").getter(ContactFilter.getter(ContactFilter::contactStatesAsStrings)).setter(ContactFilter.setter(Builder::contactStatesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_STATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> contactStates;

    private ContactFilter(BuilderImpl builder) {
        this.contactStates = builder.contactStates;
    }

    public final List<ContactState> contactStates() {
        return ContactStatesCopier.copyStringToEnum(this.contactStates);
    }

    public final boolean hasContactStates() {
        return this.contactStates != null && !(this.contactStates instanceof SdkAutoConstructList);
    }

    public final List<String> contactStatesAsStrings() {
        return this.contactStates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactStates() ? this.contactStatesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFilter)) {
            return false;
        }
        ContactFilter other = (ContactFilter)obj;
        return this.hasContactStates() == other.hasContactStates() && Objects.equals(this.contactStatesAsStrings(), other.contactStatesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ContactFilter").add("ContactStates", this.hasContactStates() ? this.contactStatesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactStates": {
                return Optional.ofNullable(clazz.cast(this.contactStatesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ContactStates", CONTACT_STATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFilter, T> g) {
        return obj -> g.apply((ContactFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> contactStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFilter model) {
            this.contactStatesWithStrings(model.contactStates);
        }

        public final Collection<String> getContactStates() {
            if (this.contactStates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contactStates;
        }

        public final void setContactStates(Collection<String> contactStates) {
            this.contactStates = ContactStatesCopier.copy(contactStates);
        }

        @Override
        public final Builder contactStatesWithStrings(Collection<String> contactStates) {
            this.contactStates = ContactStatesCopier.copy(contactStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactStatesWithStrings(String ... contactStates) {
            this.contactStatesWithStrings(Arrays.asList(contactStates));
            return this;
        }

        @Override
        public final Builder contactStates(Collection<ContactState> contactStates) {
            this.contactStates = ContactStatesCopier.copyEnumToString(contactStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactStates(ContactState ... contactStates) {
            this.contactStates(Arrays.asList(contactStates));
            return this;
        }

        public ContactFilter build() {
            return new ContactFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactFilter> {
        public Builder contactStatesWithStrings(Collection<String> var1);

        public Builder contactStatesWithStrings(String ... var1);

        public Builder contactStates(Collection<ContactState> var1);

        public Builder contactStates(ContactState ... var1);
    }
}

