/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisTranscriptItemWithContent;
import software.amazon.awssdk.services.connect.model.RealTimeContactAnalysisTranscriptItemsWithContentCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RealTimeContactAnalysisIssueDetected
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RealTimeContactAnalysisIssueDetected> {
    private static final SdkField<List<RealTimeContactAnalysisTranscriptItemWithContent>> TRANSCRIPT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TranscriptItems").getter(RealTimeContactAnalysisIssueDetected.getter(RealTimeContactAnalysisIssueDetected::transcriptItems)).setter(RealTimeContactAnalysisIssueDetected.setter(Builder::transcriptItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RealTimeContactAnalysisTranscriptItemWithContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPT_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RealTimeContactAnalysisIssueDetected.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RealTimeContactAnalysisTranscriptItemWithContent> transcriptItems;

    private RealTimeContactAnalysisIssueDetected(BuilderImpl builder) {
        this.transcriptItems = builder.transcriptItems;
    }

    public final boolean hasTranscriptItems() {
        return this.transcriptItems != null && !(this.transcriptItems instanceof SdkAutoConstructList);
    }

    public final List<RealTimeContactAnalysisTranscriptItemWithContent> transcriptItems() {
        return this.transcriptItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTranscriptItems() ? this.transcriptItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealTimeContactAnalysisIssueDetected)) {
            return false;
        }
        RealTimeContactAnalysisIssueDetected other = (RealTimeContactAnalysisIssueDetected)obj;
        return this.hasTranscriptItems() == other.hasTranscriptItems() && Objects.equals(this.transcriptItems(), other.transcriptItems());
    }

    public final String toString() {
        return ToString.builder((String)"RealTimeContactAnalysisIssueDetected").add("TranscriptItems", this.hasTranscriptItems() ? this.transcriptItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranscriptItems": {
                return Optional.ofNullable(clazz.cast(this.transcriptItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<RealTimeContactAnalysisTranscriptItemWithContent>>> map = new HashMap<String, SdkField<List<RealTimeContactAnalysisTranscriptItemWithContent>>>();
        map.put("TranscriptItems", TRANSCRIPT_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealTimeContactAnalysisIssueDetected, T> g) {
        return obj -> g.apply((RealTimeContactAnalysisIssueDetected)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RealTimeContactAnalysisTranscriptItemWithContent> transcriptItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RealTimeContactAnalysisIssueDetected model) {
            this.transcriptItems(model.transcriptItems);
        }

        public final List<RealTimeContactAnalysisTranscriptItemWithContent.Builder> getTranscriptItems() {
            List<RealTimeContactAnalysisTranscriptItemWithContent.Builder> result = RealTimeContactAnalysisTranscriptItemsWithContentCopier.copyToBuilder(this.transcriptItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTranscriptItems(Collection<RealTimeContactAnalysisTranscriptItemWithContent.BuilderImpl> transcriptItems) {
            this.transcriptItems = RealTimeContactAnalysisTranscriptItemsWithContentCopier.copyFromBuilder(transcriptItems);
        }

        @Override
        public final Builder transcriptItems(Collection<RealTimeContactAnalysisTranscriptItemWithContent> transcriptItems) {
            this.transcriptItems = RealTimeContactAnalysisTranscriptItemsWithContentCopier.copy(transcriptItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcriptItems(RealTimeContactAnalysisTranscriptItemWithContent ... transcriptItems) {
            this.transcriptItems(Arrays.asList(transcriptItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transcriptItems(Consumer<RealTimeContactAnalysisTranscriptItemWithContent.Builder> ... transcriptItems) {
            this.transcriptItems(Stream.of(transcriptItems).map(c -> (RealTimeContactAnalysisTranscriptItemWithContent)((RealTimeContactAnalysisTranscriptItemWithContent.Builder)RealTimeContactAnalysisTranscriptItemWithContent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RealTimeContactAnalysisIssueDetected build() {
            return new RealTimeContactAnalysisIssueDetected(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RealTimeContactAnalysisIssueDetected> {
        public Builder transcriptItems(Collection<RealTimeContactAnalysisTranscriptItemWithContent> var1);

        public Builder transcriptItems(RealTimeContactAnalysisTranscriptItemWithContent ... var1);

        public Builder transcriptItems(Consumer<RealTimeContactAnalysisTranscriptItemWithContent.Builder> ... var1);
    }
}

