/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.TrafficDistributionGroupSummary;
import software.amazon.awssdk.services.connect.model.TrafficDistributionGroupSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrafficDistributionGroupsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListTrafficDistributionGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrafficDistributionGroupsResponse.getter(ListTrafficDistributionGroupsResponse::nextToken)).setter(ListTrafficDistributionGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<TrafficDistributionGroupSummary>> TRAFFIC_DISTRIBUTION_GROUP_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrafficDistributionGroupSummaryList").getter(ListTrafficDistributionGroupsResponse.getter(ListTrafficDistributionGroupsResponse::trafficDistributionGroupSummaryList)).setter(ListTrafficDistributionGroupsResponse.setter(Builder::trafficDistributionGroupSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficDistributionGroupSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficDistributionGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TRAFFIC_DISTRIBUTION_GROUP_SUMMARY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrafficDistributionGroupsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<TrafficDistributionGroupSummary> trafficDistributionGroupSummaryList;

    private ListTrafficDistributionGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trafficDistributionGroupSummaryList = builder.trafficDistributionGroupSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTrafficDistributionGroupSummaryList() {
        return this.trafficDistributionGroupSummaryList != null && !(this.trafficDistributionGroupSummaryList instanceof SdkAutoConstructList);
    }

    public final List<TrafficDistributionGroupSummary> trafficDistributionGroupSummaryList() {
        return this.trafficDistributionGroupSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrafficDistributionGroupSummaryList() ? this.trafficDistributionGroupSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficDistributionGroupsResponse)) {
            return false;
        }
        ListTrafficDistributionGroupsResponse other = (ListTrafficDistributionGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTrafficDistributionGroupSummaryList() == other.hasTrafficDistributionGroupSummaryList() && Objects.equals(this.trafficDistributionGroupSummaryList(), other.trafficDistributionGroupSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrafficDistributionGroupsResponse").add("NextToken", (Object)this.nextToken()).add("TrafficDistributionGroupSummaryList", this.hasTrafficDistributionGroupSummaryList() ? this.trafficDistributionGroupSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TrafficDistributionGroupSummaryList": {
                return Optional.ofNullable(clazz.cast(this.trafficDistributionGroupSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("TrafficDistributionGroupSummaryList", TRAFFIC_DISTRIBUTION_GROUP_SUMMARY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficDistributionGroupsResponse, T> g) {
        return obj -> g.apply((ListTrafficDistributionGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TrafficDistributionGroupSummary> trafficDistributionGroupSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficDistributionGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.trafficDistributionGroupSummaryList(model.trafficDistributionGroupSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrafficDistributionGroupSummary.Builder> getTrafficDistributionGroupSummaryList() {
            List<TrafficDistributionGroupSummary.Builder> result = TrafficDistributionGroupSummaryListCopier.copyToBuilder(this.trafficDistributionGroupSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficDistributionGroupSummaryList(Collection<TrafficDistributionGroupSummary.BuilderImpl> trafficDistributionGroupSummaryList) {
            this.trafficDistributionGroupSummaryList = TrafficDistributionGroupSummaryListCopier.copyFromBuilder(trafficDistributionGroupSummaryList);
        }

        @Override
        public final Builder trafficDistributionGroupSummaryList(Collection<TrafficDistributionGroupSummary> trafficDistributionGroupSummaryList) {
            this.trafficDistributionGroupSummaryList = TrafficDistributionGroupSummaryListCopier.copy(trafficDistributionGroupSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficDistributionGroupSummaryList(TrafficDistributionGroupSummary ... trafficDistributionGroupSummaryList) {
            this.trafficDistributionGroupSummaryList(Arrays.asList(trafficDistributionGroupSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficDistributionGroupSummaryList(Consumer<TrafficDistributionGroupSummary.Builder> ... trafficDistributionGroupSummaryList) {
            this.trafficDistributionGroupSummaryList(Stream.of(trafficDistributionGroupSummaryList).map(c -> (TrafficDistributionGroupSummary)((TrafficDistributionGroupSummary.Builder)TrafficDistributionGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrafficDistributionGroupsResponse build() {
            return new ListTrafficDistributionGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrafficDistributionGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder trafficDistributionGroupSummaryList(Collection<TrafficDistributionGroupSummary> var1);

        public Builder trafficDistributionGroupSummaryList(TrafficDistributionGroupSummary ... var1);

        public Builder trafficDistributionGroupSummaryList(Consumer<TrafficDistributionGroupSummary.Builder> ... var1);
    }
}

