/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListPromptsRequest;
import software.amazon.awssdk.services.connect.model.ListPromptsResponse;
import software.amazon.awssdk.services.connect.model.PromptSummary;

public class ListPromptsPublisher
implements SdkPublisher<ListPromptsResponse> {
    private final ConnectAsyncClient client;
    private final ListPromptsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPromptsPublisher(ConnectAsyncClient client, ListPromptsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPromptsPublisher(ConnectAsyncClient client, ListPromptsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPromptsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPromptsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PromptSummary> promptSummaryList() {
        Function<ListPromptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.promptSummaryList() != null) {
                return response.promptSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPromptsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPromptsResponseFetcher
    implements AsyncPageFetcher<ListPromptsResponse> {
        private ListPromptsResponseFetcher() {
        }

        public boolean hasNextPage(ListPromptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPromptsResponse> nextPage(ListPromptsResponse previousPage) {
            if (previousPage == null) {
                return ListPromptsPublisher.this.client.listPrompts(ListPromptsPublisher.this.firstRequest);
            }
            return ListPromptsPublisher.this.client.listPrompts((ListPromptsRequest)((Object)ListPromptsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

