/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.FailedRequest;
import software.amazon.awssdk.services.connect.model.FailedRequestListCopier;
import software.amazon.awssdk.services.connect.model.SuccessfulRequest;
import software.amazon.awssdk.services.connect.model.SuccessfulRequestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutContactResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, BatchPutContactResponse> {
    private static final SdkField<List<SuccessfulRequest>> SUCCESSFUL_REQUEST_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulRequestList").getter(BatchPutContactResponse.getter(BatchPutContactResponse::successfulRequestList)).setter(BatchPutContactResponse.setter(Builder::successfulRequestList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulRequestList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuccessfulRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FailedRequest>> FAILED_REQUEST_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedRequestList").getter(BatchPutContactResponse.getter(BatchPutContactResponse::failedRequestList)).setter(BatchPutContactResponse.setter(Builder::failedRequestList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRequestList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_REQUEST_LIST_FIELD, FAILED_REQUEST_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchPutContactResponse.memberNameToFieldInitializer();
    private final List<SuccessfulRequest> successfulRequestList;
    private final List<FailedRequest> failedRequestList;

    private BatchPutContactResponse(BuilderImpl builder) {
        super(builder);
        this.successfulRequestList = builder.successfulRequestList;
        this.failedRequestList = builder.failedRequestList;
    }

    public final boolean hasSuccessfulRequestList() {
        return this.successfulRequestList != null && !(this.successfulRequestList instanceof SdkAutoConstructList);
    }

    public final List<SuccessfulRequest> successfulRequestList() {
        return this.successfulRequestList;
    }

    public final boolean hasFailedRequestList() {
        return this.failedRequestList != null && !(this.failedRequestList instanceof SdkAutoConstructList);
    }

    public final List<FailedRequest> failedRequestList() {
        return this.failedRequestList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulRequestList() ? this.successfulRequestList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedRequestList() ? this.failedRequestList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutContactResponse)) {
            return false;
        }
        BatchPutContactResponse other = (BatchPutContactResponse)((Object)obj);
        return this.hasSuccessfulRequestList() == other.hasSuccessfulRequestList() && Objects.equals(this.successfulRequestList(), other.successfulRequestList()) && this.hasFailedRequestList() == other.hasFailedRequestList() && Objects.equals(this.failedRequestList(), other.failedRequestList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutContactResponse").add("SuccessfulRequestList", this.hasSuccessfulRequestList() ? this.successfulRequestList() : null).add("FailedRequestList", this.hasFailedRequestList() ? this.failedRequestList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfulRequestList": {
                return Optional.ofNullable(clazz.cast(this.successfulRequestList()));
            }
            case "FailedRequestList": {
                return Optional.ofNullable(clazz.cast(this.failedRequestList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SuccessfulRequestList", SUCCESSFUL_REQUEST_LIST_FIELD);
        map.put("FailedRequestList", FAILED_REQUEST_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutContactResponse, T> g) {
        return obj -> g.apply((BatchPutContactResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<SuccessfulRequest> successfulRequestList = DefaultSdkAutoConstructList.getInstance();
        private List<FailedRequest> failedRequestList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutContactResponse model) {
            super(model);
            this.successfulRequestList(model.successfulRequestList);
            this.failedRequestList(model.failedRequestList);
        }

        public final List<SuccessfulRequest.Builder> getSuccessfulRequestList() {
            List<SuccessfulRequest.Builder> result = SuccessfulRequestListCopier.copyToBuilder(this.successfulRequestList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulRequestList(Collection<SuccessfulRequest.BuilderImpl> successfulRequestList) {
            this.successfulRequestList = SuccessfulRequestListCopier.copyFromBuilder(successfulRequestList);
        }

        @Override
        public final Builder successfulRequestList(Collection<SuccessfulRequest> successfulRequestList) {
            this.successfulRequestList = SuccessfulRequestListCopier.copy(successfulRequestList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulRequestList(SuccessfulRequest ... successfulRequestList) {
            this.successfulRequestList(Arrays.asList(successfulRequestList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulRequestList(Consumer<SuccessfulRequest.Builder> ... successfulRequestList) {
            this.successfulRequestList(Stream.of(successfulRequestList).map(c -> (SuccessfulRequest)((SuccessfulRequest.Builder)SuccessfulRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FailedRequest.Builder> getFailedRequestList() {
            List<FailedRequest.Builder> result = FailedRequestListCopier.copyToBuilder(this.failedRequestList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedRequestList(Collection<FailedRequest.BuilderImpl> failedRequestList) {
            this.failedRequestList = FailedRequestListCopier.copyFromBuilder(failedRequestList);
        }

        @Override
        public final Builder failedRequestList(Collection<FailedRequest> failedRequestList) {
            this.failedRequestList = FailedRequestListCopier.copy(failedRequestList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequestList(FailedRequest ... failedRequestList) {
            this.failedRequestList(Arrays.asList(failedRequestList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequestList(Consumer<FailedRequest.Builder> ... failedRequestList) {
            this.failedRequestList(Stream.of(failedRequestList).map(c -> (FailedRequest)((FailedRequest.Builder)FailedRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchPutContactResponse build() {
            return new BatchPutContactResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutContactResponse> {
        public Builder successfulRequestList(Collection<SuccessfulRequest> var1);

        public Builder successfulRequestList(SuccessfulRequest ... var1);

        public Builder successfulRequestList(Consumer<SuccessfulRequest.Builder> ... var1);

        public Builder failedRequestList(Collection<FailedRequest> var1);

        public Builder failedRequestList(FailedRequest ... var1);

        public Builder failedRequestList(Consumer<FailedRequest.Builder> ... var1);
    }
}

