/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AllowedAccessControlTagsCopier;
import software.amazon.awssdk.services.connect.model.Application;
import software.amazon.awssdk.services.connect.model.ApplicationsCopier;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.HierarchyRestrictedResourceListCopier;
import software.amazon.awssdk.services.connect.model.PermissionsListCopier;
import software.amazon.awssdk.services.connect.model.TagRestrictedResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityProfileRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateSecurityProfileRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::description)).setter(UpdateSecurityProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::permissions)).setter(UpdateSecurityProfileRequest.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityProfileId").getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::securityProfileId)).setter(UpdateSecurityProfileRequest.setter(Builder::securityProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SecurityProfileId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::instanceId)).setter(UpdateSecurityProfileRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<Map<String, String>> ALLOWED_ACCESS_CONTROL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AllowedAccessControlTags").getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::allowedAccessControlTags)).setter(UpdateSecurityProfileRequest.setter(Builder::allowedAccessControlTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAccessControlTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAG_RESTRICTED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagRestrictedResources").getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::tagRestrictedResources)).setter(UpdateSecurityProfileRequest.setter(Builder::tagRestrictedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagRestrictedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Application>> APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Applications").getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::applications)).setter(UpdateSecurityProfileRequest.setter(Builder::applications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Application::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> HIERARCHY_RESTRICTED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HierarchyRestrictedResources").getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::hierarchyRestrictedResources)).setter(UpdateSecurityProfileRequest.setter(Builder::hierarchyRestrictedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyRestrictedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowedAccessControlHierarchyGroupId").getter(UpdateSecurityProfileRequest.getter(UpdateSecurityProfileRequest::allowedAccessControlHierarchyGroupId)).setter(UpdateSecurityProfileRequest.setter(Builder::allowedAccessControlHierarchyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedAccessControlHierarchyGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, PERMISSIONS_FIELD, SECURITY_PROFILE_ID_FIELD, INSTANCE_ID_FIELD, ALLOWED_ACCESS_CONTROL_TAGS_FIELD, TAG_RESTRICTED_RESOURCES_FIELD, APPLICATIONS_FIELD, HIERARCHY_RESTRICTED_RESOURCES_FIELD, ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSecurityProfileRequest.memberNameToFieldInitializer();
    private final String description;
    private final List<String> permissions;
    private final String securityProfileId;
    private final String instanceId;
    private final Map<String, String> allowedAccessControlTags;
    private final List<String> tagRestrictedResources;
    private final List<Application> applications;
    private final List<String> hierarchyRestrictedResources;
    private final String allowedAccessControlHierarchyGroupId;

    private UpdateSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.permissions = builder.permissions;
        this.securityProfileId = builder.securityProfileId;
        this.instanceId = builder.instanceId;
        this.allowedAccessControlTags = builder.allowedAccessControlTags;
        this.tagRestrictedResources = builder.tagRestrictedResources;
        this.applications = builder.applications;
        this.hierarchyRestrictedResources = builder.hierarchyRestrictedResources;
        this.allowedAccessControlHierarchyGroupId = builder.allowedAccessControlHierarchyGroupId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissions() {
        return this.permissions;
    }

    public final String securityProfileId() {
        return this.securityProfileId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final boolean hasAllowedAccessControlTags() {
        return this.allowedAccessControlTags != null && !(this.allowedAccessControlTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> allowedAccessControlTags() {
        return this.allowedAccessControlTags;
    }

    public final boolean hasTagRestrictedResources() {
        return this.tagRestrictedResources != null && !(this.tagRestrictedResources instanceof SdkAutoConstructList);
    }

    public final List<String> tagRestrictedResources() {
        return this.tagRestrictedResources;
    }

    public final boolean hasApplications() {
        return this.applications != null && !(this.applications instanceof SdkAutoConstructList);
    }

    public final List<Application> applications() {
        return this.applications;
    }

    public final boolean hasHierarchyRestrictedResources() {
        return this.hierarchyRestrictedResources != null && !(this.hierarchyRestrictedResources instanceof SdkAutoConstructList);
    }

    public final List<String> hierarchyRestrictedResources() {
        return this.hierarchyRestrictedResources;
    }

    public final String allowedAccessControlHierarchyGroupId() {
        return this.allowedAccessControlHierarchyGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAccessControlTags() ? this.allowedAccessControlTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagRestrictedResources() ? this.tagRestrictedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplications() ? this.applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHierarchyRestrictedResources() ? this.hierarchyRestrictedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedAccessControlHierarchyGroupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileRequest)) {
            return false;
        }
        UpdateSecurityProfileRequest other = (UpdateSecurityProfileRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.securityProfileId(), other.securityProfileId()) && Objects.equals(this.instanceId(), other.instanceId()) && this.hasAllowedAccessControlTags() == other.hasAllowedAccessControlTags() && Objects.equals(this.allowedAccessControlTags(), other.allowedAccessControlTags()) && this.hasTagRestrictedResources() == other.hasTagRestrictedResources() && Objects.equals(this.tagRestrictedResources(), other.tagRestrictedResources()) && this.hasApplications() == other.hasApplications() && Objects.equals(this.applications(), other.applications()) && this.hasHierarchyRestrictedResources() == other.hasHierarchyRestrictedResources() && Objects.equals(this.hierarchyRestrictedResources(), other.hierarchyRestrictedResources()) && Objects.equals(this.allowedAccessControlHierarchyGroupId(), other.allowedAccessControlHierarchyGroupId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSecurityProfileRequest").add("Description", (Object)this.description()).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("SecurityProfileId", (Object)this.securityProfileId()).add("InstanceId", (Object)this.instanceId()).add("AllowedAccessControlTags", this.hasAllowedAccessControlTags() ? this.allowedAccessControlTags() : null).add("TagRestrictedResources", this.hasTagRestrictedResources() ? this.tagRestrictedResources() : null).add("Applications", this.hasApplications() ? this.applications() : null).add("HierarchyRestrictedResources", this.hasHierarchyRestrictedResources() ? this.hierarchyRestrictedResources() : null).add("AllowedAccessControlHierarchyGroupId", (Object)this.allowedAccessControlHierarchyGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "SecurityProfileId": {
                return Optional.ofNullable(clazz.cast(this.securityProfileId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "AllowedAccessControlTags": {
                return Optional.ofNullable(clazz.cast(this.allowedAccessControlTags()));
            }
            case "TagRestrictedResources": {
                return Optional.ofNullable(clazz.cast(this.tagRestrictedResources()));
            }
            case "Applications": {
                return Optional.ofNullable(clazz.cast(this.applications()));
            }
            case "HierarchyRestrictedResources": {
                return Optional.ofNullable(clazz.cast(this.hierarchyRestrictedResources()));
            }
            case "AllowedAccessControlHierarchyGroupId": {
                return Optional.ofNullable(clazz.cast(this.allowedAccessControlHierarchyGroupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("SecurityProfileId", SECURITY_PROFILE_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("AllowedAccessControlTags", ALLOWED_ACCESS_CONTROL_TAGS_FIELD);
        map.put("TagRestrictedResources", TAG_RESTRICTED_RESOURCES_FIELD);
        map.put("Applications", APPLICATIONS_FIELD);
        map.put("HierarchyRestrictedResources", HIERARCHY_RESTRICTED_RESOURCES_FIELD);
        map.put("AllowedAccessControlHierarchyGroupId", ALLOWED_ACCESS_CONTROL_HIERARCHY_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityProfileRequest, T> g) {
        return obj -> g.apply((UpdateSecurityProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String description;
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();
        private String securityProfileId;
        private String instanceId;
        private Map<String, String> allowedAccessControlTags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> tagRestrictedResources = DefaultSdkAutoConstructList.getInstance();
        private List<Application> applications = DefaultSdkAutoConstructList.getInstance();
        private List<String> hierarchyRestrictedResources = DefaultSdkAutoConstructList.getInstance();
        private String allowedAccessControlHierarchyGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityProfileRequest model) {
            super(model);
            this.description(model.description);
            this.permissions(model.permissions);
            this.securityProfileId(model.securityProfileId);
            this.instanceId(model.instanceId);
            this.allowedAccessControlTags(model.allowedAccessControlTags);
            this.tagRestrictedResources(model.tagRestrictedResources);
            this.applications(model.applications);
            this.hierarchyRestrictedResources(model.hierarchyRestrictedResources);
            this.allowedAccessControlHierarchyGroupId(model.allowedAccessControlHierarchyGroupId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
        }

        @Override
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(String ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final String getSecurityProfileId() {
            return this.securityProfileId;
        }

        public final void setSecurityProfileId(String securityProfileId) {
            this.securityProfileId = securityProfileId;
        }

        @Override
        public final Builder securityProfileId(String securityProfileId) {
            this.securityProfileId = securityProfileId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Map<String, String> getAllowedAccessControlTags() {
            if (this.allowedAccessControlTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.allowedAccessControlTags;
        }

        public final void setAllowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
            this.allowedAccessControlTags = AllowedAccessControlTagsCopier.copy(allowedAccessControlTags);
        }

        @Override
        public final Builder allowedAccessControlTags(Map<String, String> allowedAccessControlTags) {
            this.allowedAccessControlTags = AllowedAccessControlTagsCopier.copy(allowedAccessControlTags);
            return this;
        }

        public final Collection<String> getTagRestrictedResources() {
            if (this.tagRestrictedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tagRestrictedResources;
        }

        public final void setTagRestrictedResources(Collection<String> tagRestrictedResources) {
            this.tagRestrictedResources = TagRestrictedResourceListCopier.copy(tagRestrictedResources);
        }

        @Override
        public final Builder tagRestrictedResources(Collection<String> tagRestrictedResources) {
            this.tagRestrictedResources = TagRestrictedResourceListCopier.copy(tagRestrictedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagRestrictedResources(String ... tagRestrictedResources) {
            this.tagRestrictedResources(Arrays.asList(tagRestrictedResources));
            return this;
        }

        public final List<Application.Builder> getApplications() {
            List<Application.Builder> result = ApplicationsCopier.copyToBuilder(this.applications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplications(Collection<Application.BuilderImpl> applications) {
            this.applications = ApplicationsCopier.copyFromBuilder(applications);
        }

        @Override
        public final Builder applications(Collection<Application> applications) {
            this.applications = ApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Application ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(Consumer<Application.Builder> ... applications) {
            this.applications(Stream.of(applications).map(c -> (Application)((Application.Builder)Application.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getHierarchyRestrictedResources() {
            if (this.hierarchyRestrictedResources instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hierarchyRestrictedResources;
        }

        public final void setHierarchyRestrictedResources(Collection<String> hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources = HierarchyRestrictedResourceListCopier.copy(hierarchyRestrictedResources);
        }

        @Override
        public final Builder hierarchyRestrictedResources(Collection<String> hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources = HierarchyRestrictedResourceListCopier.copy(hierarchyRestrictedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchyRestrictedResources(String ... hierarchyRestrictedResources) {
            this.hierarchyRestrictedResources(Arrays.asList(hierarchyRestrictedResources));
            return this;
        }

        public final String getAllowedAccessControlHierarchyGroupId() {
            return this.allowedAccessControlHierarchyGroupId;
        }

        public final void setAllowedAccessControlHierarchyGroupId(String allowedAccessControlHierarchyGroupId) {
            this.allowedAccessControlHierarchyGroupId = allowedAccessControlHierarchyGroupId;
        }

        @Override
        public final Builder allowedAccessControlHierarchyGroupId(String allowedAccessControlHierarchyGroupId) {
            this.allowedAccessControlHierarchyGroupId = allowedAccessControlHierarchyGroupId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityProfileRequest build() {
            return new UpdateSecurityProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSecurityProfileRequest> {
        public Builder description(String var1);

        public Builder permissions(Collection<String> var1);

        public Builder permissions(String ... var1);

        public Builder securityProfileId(String var1);

        public Builder instanceId(String var1);

        public Builder allowedAccessControlTags(Map<String, String> var1);

        public Builder tagRestrictedResources(Collection<String> var1);

        public Builder tagRestrictedResources(String ... var1);

        public Builder applications(Collection<Application> var1);

        public Builder applications(Application ... var1);

        public Builder applications(Consumer<Application.Builder> ... var1);

        public Builder hierarchyRestrictedResources(Collection<String> var1);

        public Builder hierarchyRestrictedResources(String ... var1);

        public Builder allowedAccessControlHierarchyGroupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

