/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteContactFlowVersionRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, DeleteContactFlowVersionRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(DeleteContactFlowVersionRequest.getter(DeleteContactFlowVersionRequest::instanceId)).setter(DeleteContactFlowVersionRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(DeleteContactFlowVersionRequest.getter(DeleteContactFlowVersionRequest::contactFlowId)).setter(DeleteContactFlowVersionRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowId").build()}).build();
    private static final SdkField<Long> CONTACT_FLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ContactFlowVersion").getter(DeleteContactFlowVersionRequest.getter(DeleteContactFlowVersionRequest::contactFlowVersion)).setter(DeleteContactFlowVersionRequest.setter(Builder::contactFlowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_FLOW_ID_FIELD, CONTACT_FLOW_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteContactFlowVersionRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String contactFlowId;
    private final Long contactFlowVersion;

    private DeleteContactFlowVersionRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactFlowId = builder.contactFlowId;
        this.contactFlowVersion = builder.contactFlowVersion;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final Long contactFlowVersion() {
        return this.contactFlowVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteContactFlowVersionRequest)) {
            return false;
        }
        DeleteContactFlowVersionRequest other = (DeleteContactFlowVersionRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.contactFlowVersion(), other.contactFlowVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteContactFlowVersionRequest").add("InstanceId", (Object)this.instanceId()).add("ContactFlowId", (Object)this.contactFlowId()).add("ContactFlowVersion", (Object)this.contactFlowVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "ContactFlowVersion": {
                return Optional.ofNullable(clazz.cast(this.contactFlowVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("ContactFlowVersion", CONTACT_FLOW_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteContactFlowVersionRequest, T> g) {
        return obj -> g.apply((DeleteContactFlowVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactFlowId;
        private Long contactFlowVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteContactFlowVersionRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactFlowId(model.contactFlowId);
            this.contactFlowVersion(model.contactFlowVersion);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final Long getContactFlowVersion() {
            return this.contactFlowVersion;
        }

        public final void setContactFlowVersion(Long contactFlowVersion) {
            this.contactFlowVersion = contactFlowVersion;
        }

        @Override
        public final Builder contactFlowVersion(Long contactFlowVersion) {
            this.contactFlowVersion = contactFlowVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteContactFlowVersionRequest build() {
            return new DeleteContactFlowVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteContactFlowVersionRequest> {
        public Builder instanceId(String var1);

        public Builder contactFlowId(String var1);

        public Builder contactFlowVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

