/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.Step;
import software.amazon.awssdk.services.connect.model.StepsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutingCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutingCriteria> {
    private static final SdkField<List<Step>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Steps").getter(RoutingCriteria.getter(RoutingCriteria::steps)).setter(RoutingCriteria.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> ACTIVATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ActivationTimestamp").getter(RoutingCriteria.getter(RoutingCriteria::activationTimestamp)).setter(RoutingCriteria.setter(Builder::activationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationTimestamp").build()}).build();
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Index").getter(RoutingCriteria.getter(RoutingCriteria::index)).setter(RoutingCriteria.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD, ACTIVATION_TIMESTAMP_FIELD, INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RoutingCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Step> steps;
    private final Instant activationTimestamp;
    private final Integer index;

    private RoutingCriteria(BuilderImpl builder) {
        this.steps = builder.steps;
        this.activationTimestamp = builder.activationTimestamp;
        this.index = builder.index;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<Step> steps() {
        return this.steps;
    }

    public final Instant activationTimestamp() {
        return this.activationTimestamp;
    }

    public final Integer index() {
        return this.index;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.activationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingCriteria)) {
            return false;
        }
        RoutingCriteria other = (RoutingCriteria)obj;
        return this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && Objects.equals(this.activationTimestamp(), other.activationTimestamp()) && Objects.equals(this.index(), other.index());
    }

    public final String toString() {
        return ToString.builder((String)"RoutingCriteria").add("Steps", this.hasSteps() ? this.steps() : null).add("ActivationTimestamp", (Object)this.activationTimestamp()).add("Index", (Object)this.index()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "ActivationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.activationTimestamp()));
            }
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Steps", STEPS_FIELD);
        map.put("ActivationTimestamp", ACTIVATION_TIMESTAMP_FIELD);
        map.put("Index", INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingCriteria, T> g) {
        return obj -> g.apply((RoutingCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();
        private Instant activationTimestamp;
        private Integer index;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingCriteria model) {
            this.steps(model.steps);
            this.activationTimestamp(model.activationTimestamp);
            this.index(model.index);
        }

        public final List<Step.Builder> getSteps() {
            List<Step.Builder> result = StepsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Step ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getActivationTimestamp() {
            return this.activationTimestamp;
        }

        public final void setActivationTimestamp(Instant activationTimestamp) {
            this.activationTimestamp = activationTimestamp;
        }

        @Override
        public final Builder activationTimestamp(Instant activationTimestamp) {
            this.activationTimestamp = activationTimestamp;
            return this;
        }

        public final Integer getIndex() {
            return this.index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public RoutingCriteria build() {
            return new RoutingCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutingCriteria> {
        public Builder steps(Collection<Step> var1);

        public Builder steps(Step ... var1);

        public Builder steps(Consumer<Step.Builder> ... var1);

        public Builder activationTimestamp(Instant var1);

        public Builder index(Integer var1);
    }
}

