/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the agent who accepted the contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentInfo implements SdkPojo, Serializable, ToCopyableBuilder<AgentInfo.Builder, AgentInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AgentInfo::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> CONNECTED_TO_AGENT_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("ConnectedToAgentTimestamp")
            .getter(getter(AgentInfo::connectedToAgentTimestamp)).setter(setter(Builder::connectedToAgentTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedToAgentTimestamp").build())
            .build();

    private static final SdkField<Integer> AGENT_PAUSE_DURATION_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AgentPauseDurationInSeconds")
            .getter(getter(AgentInfo::agentPauseDurationInSeconds))
            .setter(setter(Builder::agentPauseDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentPauseDurationInSeconds")
                    .build()).build();

    private static final SdkField<HierarchyGroups> HIERARCHY_GROUPS_FIELD = SdkField
            .<HierarchyGroups> builder(MarshallingType.SDK_POJO).memberName("HierarchyGroups")
            .getter(getter(AgentInfo::hierarchyGroups)).setter(setter(Builder::hierarchyGroups))
            .constructor(HierarchyGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroups").build()).build();

    private static final SdkField<DeviceInfo> DEVICE_INFO_FIELD = SdkField.<DeviceInfo> builder(MarshallingType.SDK_POJO)
            .memberName("DeviceInfo").getter(getter(AgentInfo::deviceInfo)).setter(setter(Builder::deviceInfo))
            .constructor(DeviceInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceInfo").build()).build();

    private static final SdkField<ParticipantCapabilities> CAPABILITIES_FIELD = SdkField
            .<ParticipantCapabilities> builder(MarshallingType.SDK_POJO).memberName("Capabilities")
            .getter(getter(AgentInfo::capabilities)).setter(setter(Builder::capabilities))
            .constructor(ParticipantCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()).build();

    private static final SdkField<Integer> AFTER_CONTACT_WORK_DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("AfterContactWorkDuration")
            .getter(getter(AgentInfo::afterContactWorkDuration)).setter(setter(Builder::afterContactWorkDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterContactWorkDuration").build())
            .build();

    private static final SdkField<Instant> AFTER_CONTACT_WORK_START_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AfterContactWorkStartTimestamp")
            .getter(getter(AgentInfo::afterContactWorkStartTimestamp))
            .setter(setter(Builder::afterContactWorkStartTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterContactWorkStartTimestamp")
                    .build()).build();

    private static final SdkField<Instant> AFTER_CONTACT_WORK_END_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AfterContactWorkEndTimestamp")
            .getter(getter(AgentInfo::afterContactWorkEndTimestamp))
            .setter(setter(Builder::afterContactWorkEndTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterContactWorkEndTimestamp")
                    .build()).build();

    private static final SdkField<Integer> AGENT_INITIATED_HOLD_DURATION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AgentInitiatedHoldDuration")
            .getter(getter(AgentInfo::agentInitiatedHoldDuration))
            .setter(setter(Builder::agentInitiatedHoldDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentInitiatedHoldDuration").build())
            .build();

    private static final SdkField<List<StateTransition>> STATE_TRANSITIONS_FIELD = SdkField
            .<List<StateTransition>> builder(MarshallingType.LIST)
            .memberName("StateTransitions")
            .getter(getter(AgentInfo::stateTransitions))
            .setter(setter(Builder::stateTransitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StateTransition> builder(MarshallingType.SDK_POJO)
                                            .constructor(StateTransition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CONNECTED_TO_AGENT_TIMESTAMP_FIELD, AGENT_PAUSE_DURATION_IN_SECONDS_FIELD, HIERARCHY_GROUPS_FIELD, DEVICE_INFO_FIELD,
            CAPABILITIES_FIELD, AFTER_CONTACT_WORK_DURATION_FIELD, AFTER_CONTACT_WORK_START_TIMESTAMP_FIELD,
            AFTER_CONTACT_WORK_END_TIMESTAMP_FIELD, AGENT_INITIATED_HOLD_DURATION_FIELD, STATE_TRANSITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Instant connectedToAgentTimestamp;

    private final Integer agentPauseDurationInSeconds;

    private final HierarchyGroups hierarchyGroups;

    private final DeviceInfo deviceInfo;

    private final ParticipantCapabilities capabilities;

    private final Integer afterContactWorkDuration;

    private final Instant afterContactWorkStartTimestamp;

    private final Instant afterContactWorkEndTimestamp;

    private final Integer agentInitiatedHoldDuration;

    private final List<StateTransition> stateTransitions;

    private AgentInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.connectedToAgentTimestamp = builder.connectedToAgentTimestamp;
        this.agentPauseDurationInSeconds = builder.agentPauseDurationInSeconds;
        this.hierarchyGroups = builder.hierarchyGroups;
        this.deviceInfo = builder.deviceInfo;
        this.capabilities = builder.capabilities;
        this.afterContactWorkDuration = builder.afterContactWorkDuration;
        this.afterContactWorkStartTimestamp = builder.afterContactWorkStartTimestamp;
        this.afterContactWorkEndTimestamp = builder.afterContactWorkEndTimestamp;
        this.agentInitiatedHoldDuration = builder.agentInitiatedHoldDuration;
        this.stateTransitions = builder.stateTransitions;
    }

    /**
     * <p>
     * The identifier of the agent who accepted the contact.
     * </p>
     * 
     * @return The identifier of the agent who accepted the contact.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The timestamp when the contact was connected to the agent.
     * </p>
     * 
     * @return The timestamp when the contact was connected to the agent.
     */
    public final Instant connectedToAgentTimestamp() {
        return connectedToAgentTimestamp;
    }

    /**
     * <p>
     * Agent pause duration for a contact in seconds.
     * </p>
     * 
     * @return Agent pause duration for a contact in seconds.
     */
    public final Integer agentPauseDurationInSeconds() {
        return agentPauseDurationInSeconds;
    }

    /**
     * <p>
     * The agent hierarchy groups for the agent.
     * </p>
     * 
     * @return The agent hierarchy groups for the agent.
     */
    public final HierarchyGroups hierarchyGroups() {
        return hierarchyGroups;
    }

    /**
     * <p>
     * Information regarding Agent’s device.
     * </p>
     * 
     * @return Information regarding Agent’s device.
     */
    public final DeviceInfo deviceInfo() {
        return deviceInfo;
    }

    /**
     * Returns the value of the Capabilities property for this object.
     * 
     * @return The value of the Capabilities property for this object.
     */
    public final ParticipantCapabilities capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * The difference in time, in whole seconds, between <code>AfterContactWorkStartTimestamp</code> and
     * <code>AfterContactWorkEndTimestamp</code>.
     * </p>
     * 
     * @return The difference in time, in whole seconds, between <code>AfterContactWorkStartTimestamp</code> and
     *         <code>AfterContactWorkEndTimestamp</code>.
     */
    public final Integer afterContactWorkDuration() {
        return afterContactWorkDuration;
    }

    /**
     * <p>
     * The date and time when the agent started doing After Contact Work for the contact, in UTC time.
     * </p>
     * 
     * @return The date and time when the agent started doing After Contact Work for the contact, in UTC time.
     */
    public final Instant afterContactWorkStartTimestamp() {
        return afterContactWorkStartTimestamp;
    }

    /**
     * <p>
     * The date and time when the agent ended After Contact Work for the contact, in UTC time. In cases when agent
     * finishes doing <code>AfterContactWork</code> for chat contacts and switches their activity status to offline or
     * equivalent without clearing the contact in CCP, discrepancies may be noticed for
     * <code>AfterContactWorkEndTimestamp</code>.
     * </p>
     * 
     * @return The date and time when the agent ended After Contact Work for the contact, in UTC time. In cases when
     *         agent finishes doing <code>AfterContactWork</code> for chat contacts and switches their activity status
     *         to offline or equivalent without clearing the contact in CCP, discrepancies may be noticed for
     *         <code>AfterContactWorkEndTimestamp</code>.
     */
    public final Instant afterContactWorkEndTimestamp() {
        return afterContactWorkEndTimestamp;
    }

    /**
     * <p>
     * The total hold duration in seconds initiated by the agent.
     * </p>
     * 
     * @return The total hold duration in seconds initiated by the agent.
     */
    public final Integer agentInitiatedHoldDuration() {
        return agentInitiatedHoldDuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the StateTransitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStateTransitions() {
        return stateTransitions != null && !(stateTransitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>StateTransition</code> for a supervisor.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStateTransitions} method.
     * </p>
     * 
     * @return List of <code>StateTransition</code> for a supervisor.
     */
    public final List<StateTransition> stateTransitions() {
        return stateTransitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(connectedToAgentTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(agentPauseDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyGroups());
        hashCode = 31 * hashCode + Objects.hashCode(deviceInfo());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(afterContactWorkDuration());
        hashCode = 31 * hashCode + Objects.hashCode(afterContactWorkStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(afterContactWorkEndTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(agentInitiatedHoldDuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasStateTransitions() ? stateTransitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentInfo)) {
            return false;
        }
        AgentInfo other = (AgentInfo) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(connectedToAgentTimestamp(), other.connectedToAgentTimestamp())
                && Objects.equals(agentPauseDurationInSeconds(), other.agentPauseDurationInSeconds())
                && Objects.equals(hierarchyGroups(), other.hierarchyGroups()) && Objects.equals(deviceInfo(), other.deviceInfo())
                && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(afterContactWorkDuration(), other.afterContactWorkDuration())
                && Objects.equals(afterContactWorkStartTimestamp(), other.afterContactWorkStartTimestamp())
                && Objects.equals(afterContactWorkEndTimestamp(), other.afterContactWorkEndTimestamp())
                && Objects.equals(agentInitiatedHoldDuration(), other.agentInitiatedHoldDuration())
                && hasStateTransitions() == other.hasStateTransitions()
                && Objects.equals(stateTransitions(), other.stateTransitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentInfo").add("Id", id()).add("ConnectedToAgentTimestamp", connectedToAgentTimestamp())
                .add("AgentPauseDurationInSeconds", agentPauseDurationInSeconds()).add("HierarchyGroups", hierarchyGroups())
                .add("DeviceInfo", deviceInfo()).add("Capabilities", capabilities())
                .add("AfterContactWorkDuration", afterContactWorkDuration())
                .add("AfterContactWorkStartTimestamp", afterContactWorkStartTimestamp())
                .add("AfterContactWorkEndTimestamp", afterContactWorkEndTimestamp())
                .add("AgentInitiatedHoldDuration", agentInitiatedHoldDuration())
                .add("StateTransitions", hasStateTransitions() ? stateTransitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ConnectedToAgentTimestamp":
            return Optional.ofNullable(clazz.cast(connectedToAgentTimestamp()));
        case "AgentPauseDurationInSeconds":
            return Optional.ofNullable(clazz.cast(agentPauseDurationInSeconds()));
        case "HierarchyGroups":
            return Optional.ofNullable(clazz.cast(hierarchyGroups()));
        case "DeviceInfo":
            return Optional.ofNullable(clazz.cast(deviceInfo()));
        case "Capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "AfterContactWorkDuration":
            return Optional.ofNullable(clazz.cast(afterContactWorkDuration()));
        case "AfterContactWorkStartTimestamp":
            return Optional.ofNullable(clazz.cast(afterContactWorkStartTimestamp()));
        case "AfterContactWorkEndTimestamp":
            return Optional.ofNullable(clazz.cast(afterContactWorkEndTimestamp()));
        case "AgentInitiatedHoldDuration":
            return Optional.ofNullable(clazz.cast(agentInitiatedHoldDuration()));
        case "StateTransitions":
            return Optional.ofNullable(clazz.cast(stateTransitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ConnectedToAgentTimestamp", CONNECTED_TO_AGENT_TIMESTAMP_FIELD);
        map.put("AgentPauseDurationInSeconds", AGENT_PAUSE_DURATION_IN_SECONDS_FIELD);
        map.put("HierarchyGroups", HIERARCHY_GROUPS_FIELD);
        map.put("DeviceInfo", DEVICE_INFO_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("AfterContactWorkDuration", AFTER_CONTACT_WORK_DURATION_FIELD);
        map.put("AfterContactWorkStartTimestamp", AFTER_CONTACT_WORK_START_TIMESTAMP_FIELD);
        map.put("AfterContactWorkEndTimestamp", AFTER_CONTACT_WORK_END_TIMESTAMP_FIELD);
        map.put("AgentInitiatedHoldDuration", AGENT_INITIATED_HOLD_DURATION_FIELD);
        map.put("StateTransitions", STATE_TRANSITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentInfo, T> g) {
        return obj -> g.apply((AgentInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentInfo> {
        /**
         * <p>
         * The identifier of the agent who accepted the contact.
         * </p>
         * 
         * @param id
         *        The identifier of the agent who accepted the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The timestamp when the contact was connected to the agent.
         * </p>
         * 
         * @param connectedToAgentTimestamp
         *        The timestamp when the contact was connected to the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectedToAgentTimestamp(Instant connectedToAgentTimestamp);

        /**
         * <p>
         * Agent pause duration for a contact in seconds.
         * </p>
         * 
         * @param agentPauseDurationInSeconds
         *        Agent pause duration for a contact in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentPauseDurationInSeconds(Integer agentPauseDurationInSeconds);

        /**
         * <p>
         * The agent hierarchy groups for the agent.
         * </p>
         * 
         * @param hierarchyGroups
         *        The agent hierarchy groups for the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyGroups(HierarchyGroups hierarchyGroups);

        /**
         * <p>
         * The agent hierarchy groups for the agent.
         * </p>
         * This is a convenience method that creates an instance of the {@link HierarchyGroups.Builder} avoiding the
         * need to create one manually via {@link HierarchyGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HierarchyGroups.Builder#build()} is called immediately and its
         * result is passed to {@link #hierarchyGroups(HierarchyGroups)}.
         * 
         * @param hierarchyGroups
         *        a consumer that will call methods on {@link HierarchyGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchyGroups(HierarchyGroups)
         */
        default Builder hierarchyGroups(Consumer<HierarchyGroups.Builder> hierarchyGroups) {
            return hierarchyGroups(HierarchyGroups.builder().applyMutation(hierarchyGroups).build());
        }

        /**
         * <p>
         * Information regarding Agent’s device.
         * </p>
         * 
         * @param deviceInfo
         *        Information regarding Agent’s device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceInfo(DeviceInfo deviceInfo);

        /**
         * <p>
         * Information regarding Agent’s device.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceInfo.Builder} avoiding the need to
         * create one manually via {@link DeviceInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #deviceInfo(DeviceInfo)}.
         * 
         * @param deviceInfo
         *        a consumer that will call methods on {@link DeviceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceInfo(DeviceInfo)
         */
        default Builder deviceInfo(Consumer<DeviceInfo.Builder> deviceInfo) {
            return deviceInfo(DeviceInfo.builder().applyMutation(deviceInfo).build());
        }

        /**
         * Sets the value of the Capabilities property for this object.
         *
         * @param capabilities
         *        The new value for the Capabilities property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(ParticipantCapabilities capabilities);

        /**
         * Sets the value of the Capabilities property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ParticipantCapabilities.Builder} avoiding
         * the need to create one manually via {@link ParticipantCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipantCapabilities.Builder#build()} is called immediately
         * and its result is passed to {@link #capabilities(ParticipantCapabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link ParticipantCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(ParticipantCapabilities)
         */
        default Builder capabilities(Consumer<ParticipantCapabilities.Builder> capabilities) {
            return capabilities(ParticipantCapabilities.builder().applyMutation(capabilities).build());
        }

        /**
         * <p>
         * The difference in time, in whole seconds, between <code>AfterContactWorkStartTimestamp</code> and
         * <code>AfterContactWorkEndTimestamp</code>.
         * </p>
         * 
         * @param afterContactWorkDuration
         *        The difference in time, in whole seconds, between <code>AfterContactWorkStartTimestamp</code> and
         *        <code>AfterContactWorkEndTimestamp</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterContactWorkDuration(Integer afterContactWorkDuration);

        /**
         * <p>
         * The date and time when the agent started doing After Contact Work for the contact, in UTC time.
         * </p>
         * 
         * @param afterContactWorkStartTimestamp
         *        The date and time when the agent started doing After Contact Work for the contact, in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterContactWorkStartTimestamp(Instant afterContactWorkStartTimestamp);

        /**
         * <p>
         * The date and time when the agent ended After Contact Work for the contact, in UTC time. In cases when agent
         * finishes doing <code>AfterContactWork</code> for chat contacts and switches their activity status to offline
         * or equivalent without clearing the contact in CCP, discrepancies may be noticed for
         * <code>AfterContactWorkEndTimestamp</code>.
         * </p>
         * 
         * @param afterContactWorkEndTimestamp
         *        The date and time when the agent ended After Contact Work for the contact, in UTC time. In cases when
         *        agent finishes doing <code>AfterContactWork</code> for chat contacts and switches their activity
         *        status to offline or equivalent without clearing the contact in CCP, discrepancies may be noticed for
         *        <code>AfterContactWorkEndTimestamp</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterContactWorkEndTimestamp(Instant afterContactWorkEndTimestamp);

        /**
         * <p>
         * The total hold duration in seconds initiated by the agent.
         * </p>
         * 
         * @param agentInitiatedHoldDuration
         *        The total hold duration in seconds initiated by the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentInitiatedHoldDuration(Integer agentInitiatedHoldDuration);

        /**
         * <p>
         * List of <code>StateTransition</code> for a supervisor.
         * </p>
         * 
         * @param stateTransitions
         *        List of <code>StateTransition</code> for a supervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitions(Collection<StateTransition> stateTransitions);

        /**
         * <p>
         * List of <code>StateTransition</code> for a supervisor.
         * </p>
         * 
         * @param stateTransitions
         *        List of <code>StateTransition</code> for a supervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateTransitions(StateTransition... stateTransitions);

        /**
         * <p>
         * List of <code>StateTransition</code> for a supervisor.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.StateTransition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.StateTransition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.StateTransition.Builder#build()} is called immediately
         * and its result is passed to {@link #stateTransitions(List<StateTransition>)}.
         * 
         * @param stateTransitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.StateTransition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stateTransitions(java.util.Collection<StateTransition>)
         */
        Builder stateTransitions(Consumer<StateTransition.Builder>... stateTransitions);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Instant connectedToAgentTimestamp;

        private Integer agentPauseDurationInSeconds;

        private HierarchyGroups hierarchyGroups;

        private DeviceInfo deviceInfo;

        private ParticipantCapabilities capabilities;

        private Integer afterContactWorkDuration;

        private Instant afterContactWorkStartTimestamp;

        private Instant afterContactWorkEndTimestamp;

        private Integer agentInitiatedHoldDuration;

        private List<StateTransition> stateTransitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AgentInfo model) {
            id(model.id);
            connectedToAgentTimestamp(model.connectedToAgentTimestamp);
            agentPauseDurationInSeconds(model.agentPauseDurationInSeconds);
            hierarchyGroups(model.hierarchyGroups);
            deviceInfo(model.deviceInfo);
            capabilities(model.capabilities);
            afterContactWorkDuration(model.afterContactWorkDuration);
            afterContactWorkStartTimestamp(model.afterContactWorkStartTimestamp);
            afterContactWorkEndTimestamp(model.afterContactWorkEndTimestamp);
            agentInitiatedHoldDuration(model.agentInitiatedHoldDuration);
            stateTransitions(model.stateTransitions);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getConnectedToAgentTimestamp() {
            return connectedToAgentTimestamp;
        }

        public final void setConnectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
        }

        @Override
        public final Builder connectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
            return this;
        }

        public final Integer getAgentPauseDurationInSeconds() {
            return agentPauseDurationInSeconds;
        }

        public final void setAgentPauseDurationInSeconds(Integer agentPauseDurationInSeconds) {
            this.agentPauseDurationInSeconds = agentPauseDurationInSeconds;
        }

        @Override
        public final Builder agentPauseDurationInSeconds(Integer agentPauseDurationInSeconds) {
            this.agentPauseDurationInSeconds = agentPauseDurationInSeconds;
            return this;
        }

        public final HierarchyGroups.Builder getHierarchyGroups() {
            return hierarchyGroups != null ? hierarchyGroups.toBuilder() : null;
        }

        public final void setHierarchyGroups(HierarchyGroups.BuilderImpl hierarchyGroups) {
            this.hierarchyGroups = hierarchyGroups != null ? hierarchyGroups.build() : null;
        }

        @Override
        public final Builder hierarchyGroups(HierarchyGroups hierarchyGroups) {
            this.hierarchyGroups = hierarchyGroups;
            return this;
        }

        public final DeviceInfo.Builder getDeviceInfo() {
            return deviceInfo != null ? deviceInfo.toBuilder() : null;
        }

        public final void setDeviceInfo(DeviceInfo.BuilderImpl deviceInfo) {
            this.deviceInfo = deviceInfo != null ? deviceInfo.build() : null;
        }

        @Override
        public final Builder deviceInfo(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public final ParticipantCapabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(ParticipantCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(ParticipantCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final Integer getAfterContactWorkDuration() {
            return afterContactWorkDuration;
        }

        public final void setAfterContactWorkDuration(Integer afterContactWorkDuration) {
            this.afterContactWorkDuration = afterContactWorkDuration;
        }

        @Override
        public final Builder afterContactWorkDuration(Integer afterContactWorkDuration) {
            this.afterContactWorkDuration = afterContactWorkDuration;
            return this;
        }

        public final Instant getAfterContactWorkStartTimestamp() {
            return afterContactWorkStartTimestamp;
        }

        public final void setAfterContactWorkStartTimestamp(Instant afterContactWorkStartTimestamp) {
            this.afterContactWorkStartTimestamp = afterContactWorkStartTimestamp;
        }

        @Override
        public final Builder afterContactWorkStartTimestamp(Instant afterContactWorkStartTimestamp) {
            this.afterContactWorkStartTimestamp = afterContactWorkStartTimestamp;
            return this;
        }

        public final Instant getAfterContactWorkEndTimestamp() {
            return afterContactWorkEndTimestamp;
        }

        public final void setAfterContactWorkEndTimestamp(Instant afterContactWorkEndTimestamp) {
            this.afterContactWorkEndTimestamp = afterContactWorkEndTimestamp;
        }

        @Override
        public final Builder afterContactWorkEndTimestamp(Instant afterContactWorkEndTimestamp) {
            this.afterContactWorkEndTimestamp = afterContactWorkEndTimestamp;
            return this;
        }

        public final Integer getAgentInitiatedHoldDuration() {
            return agentInitiatedHoldDuration;
        }

        public final void setAgentInitiatedHoldDuration(Integer agentInitiatedHoldDuration) {
            this.agentInitiatedHoldDuration = agentInitiatedHoldDuration;
        }

        @Override
        public final Builder agentInitiatedHoldDuration(Integer agentInitiatedHoldDuration) {
            this.agentInitiatedHoldDuration = agentInitiatedHoldDuration;
            return this;
        }

        public final List<StateTransition.Builder> getStateTransitions() {
            List<StateTransition.Builder> result = StateTransitionsCopier.copyToBuilder(this.stateTransitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStateTransitions(Collection<StateTransition.BuilderImpl> stateTransitions) {
            this.stateTransitions = StateTransitionsCopier.copyFromBuilder(stateTransitions);
        }

        @Override
        public final Builder stateTransitions(Collection<StateTransition> stateTransitions) {
            this.stateTransitions = StateTransitionsCopier.copy(stateTransitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTransitions(StateTransition... stateTransitions) {
            stateTransitions(Arrays.asList(stateTransitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTransitions(Consumer<StateTransition.Builder>... stateTransitions) {
            stateTransitions(Stream.of(stateTransitions).map(c -> StateTransition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AgentInfo build() {
            return new AgentInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
