/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This API is in preview release for Amazon Connect and is subject to change.
 * </p>
 * <p>
 * Information about associations that are successfully created: <code>DataSetId</code>, <code>TargetAccountId</code>,
 * <code>ResourceShareId</code>, <code>ResourceShareArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsDataAssociationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsDataAssociationResult.Builder, AnalyticsDataAssociationResult> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(AnalyticsDataAssociationResult::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> TARGET_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetAccountId").getter(getter(AnalyticsDataAssociationResult::targetAccountId))
            .setter(setter(Builder::targetAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAccountId").build()).build();

    private static final SdkField<String> RESOURCE_SHARE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceShareId").getter(getter(AnalyticsDataAssociationResult::resourceShareId))
            .setter(setter(Builder::resourceShareId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShareId").build()).build();

    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceShareArn").getter(getter(AnalyticsDataAssociationResult::resourceShareArn))
            .setter(setter(Builder::resourceShareArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShareArn").build()).build();

    private static final SdkField<String> RESOURCE_SHARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceShareStatus").getter(getter(AnalyticsDataAssociationResult::resourceShareStatus))
            .setter(setter(Builder::resourceShareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShareStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD,
            TARGET_ACCOUNT_ID_FIELD, RESOURCE_SHARE_ID_FIELD, RESOURCE_SHARE_ARN_FIELD, RESOURCE_SHARE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSetId;

    private final String targetAccountId;

    private final String resourceShareId;

    private final String resourceShareArn;

    private final String resourceShareStatus;

    private AnalyticsDataAssociationResult(BuilderImpl builder) {
        this.dataSetId = builder.dataSetId;
        this.targetAccountId = builder.targetAccountId;
        this.resourceShareId = builder.resourceShareId;
        this.resourceShareArn = builder.resourceShareArn;
        this.resourceShareStatus = builder.resourceShareStatus;
    }

    /**
     * <p>
     * The identifier of the dataset.
     * </p>
     * 
     * @return The identifier of the dataset.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The identifier of the target account.
     * </p>
     * 
     * @return The identifier of the target account.
     */
    public final String targetAccountId() {
        return targetAccountId;
    }

    /**
     * <p>
     * The Resource Access Manager share ID.
     * </p>
     * 
     * @return The Resource Access Manager share ID.
     */
    public final String resourceShareId() {
        return resourceShareId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Resource Access Manager share.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Resource Access Manager share.
     */
    public final String resourceShareArn() {
        return resourceShareArn;
    }

    /**
     * <p>
     * The Amazon Web Services Resource Access Manager status of association.
     * </p>
     * 
     * @return The Amazon Web Services Resource Access Manager status of association.
     */
    public final String resourceShareStatus() {
        return resourceShareStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceShareStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsDataAssociationResult)) {
            return false;
        }
        AnalyticsDataAssociationResult other = (AnalyticsDataAssociationResult) obj;
        return Objects.equals(dataSetId(), other.dataSetId()) && Objects.equals(targetAccountId(), other.targetAccountId())
                && Objects.equals(resourceShareId(), other.resourceShareId())
                && Objects.equals(resourceShareArn(), other.resourceShareArn())
                && Objects.equals(resourceShareStatus(), other.resourceShareStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsDataAssociationResult").add("DataSetId", dataSetId())
                .add("TargetAccountId", targetAccountId()).add("ResourceShareId", resourceShareId())
                .add("ResourceShareArn", resourceShareArn()).add("ResourceShareStatus", resourceShareStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "TargetAccountId":
            return Optional.ofNullable(clazz.cast(targetAccountId()));
        case "ResourceShareId":
            return Optional.ofNullable(clazz.cast(resourceShareId()));
        case "ResourceShareArn":
            return Optional.ofNullable(clazz.cast(resourceShareArn()));
        case "ResourceShareStatus":
            return Optional.ofNullable(clazz.cast(resourceShareStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("TargetAccountId", TARGET_ACCOUNT_ID_FIELD);
        map.put("ResourceShareId", RESOURCE_SHARE_ID_FIELD);
        map.put("ResourceShareArn", RESOURCE_SHARE_ARN_FIELD);
        map.put("ResourceShareStatus", RESOURCE_SHARE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsDataAssociationResult, T> g) {
        return obj -> g.apply((AnalyticsDataAssociationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsDataAssociationResult> {
        /**
         * <p>
         * The identifier of the dataset.
         * </p>
         * 
         * @param dataSetId
         *        The identifier of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The identifier of the target account.
         * </p>
         * 
         * @param targetAccountId
         *        The identifier of the target account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountId(String targetAccountId);

        /**
         * <p>
         * The Resource Access Manager share ID.
         * </p>
         * 
         * @param resourceShareId
         *        The Resource Access Manager share ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareId(String resourceShareId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Resource Access Manager share.
         * </p>
         * 
         * @param resourceShareArn
         *        The Amazon Resource Name (ARN) of the Resource Access Manager share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareArn(String resourceShareArn);

        /**
         * <p>
         * The Amazon Web Services Resource Access Manager status of association.
         * </p>
         * 
         * @param resourceShareStatus
         *        The Amazon Web Services Resource Access Manager status of association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceShareStatus(String resourceShareStatus);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetId;

        private String targetAccountId;

        private String resourceShareId;

        private String resourceShareArn;

        private String resourceShareStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsDataAssociationResult model) {
            dataSetId(model.dataSetId);
            targetAccountId(model.targetAccountId);
            resourceShareId(model.resourceShareId);
            resourceShareArn(model.resourceShareArn);
            resourceShareStatus(model.resourceShareStatus);
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getTargetAccountId() {
            return targetAccountId;
        }

        public final void setTargetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
        }

        @Override
        public final Builder targetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
            return this;
        }

        public final String getResourceShareId() {
            return resourceShareId;
        }

        public final void setResourceShareId(String resourceShareId) {
            this.resourceShareId = resourceShareId;
        }

        @Override
        public final Builder resourceShareId(String resourceShareId) {
            this.resourceShareId = resourceShareId;
            return this;
        }

        public final String getResourceShareArn() {
            return resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        public final String getResourceShareStatus() {
            return resourceShareStatus;
        }

        public final void setResourceShareStatus(String resourceShareStatus) {
            this.resourceShareStatus = resourceShareStatus;
        }

        @Override
        public final Builder resourceShareStatus(String resourceShareStatus) {
            this.resourceShareStatus = resourceShareStatus;
            return this;
        }

        @Override
        public AnalyticsDataAssociationResult build() {
            return new AnalyticsDataAssociationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
