/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of the answering machine detection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnswerMachineDetectionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AnswerMachineDetectionConfig.Builder, AnswerMachineDetectionConfig> {
    private static final SdkField<Boolean> ENABLE_ANSWER_MACHINE_DETECTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableAnswerMachineDetection")
            .getter(getter(AnswerMachineDetectionConfig::enableAnswerMachineDetection))
            .setter(setter(Builder::enableAnswerMachineDetection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAnswerMachineDetection")
                    .build()).build();

    private static final SdkField<Boolean> AWAIT_ANSWER_MACHINE_PROMPT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AwaitAnswerMachinePrompt")
            .getter(getter(AnswerMachineDetectionConfig::awaitAnswerMachinePrompt))
            .setter(setter(Builder::awaitAnswerMachinePrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwaitAnswerMachinePrompt").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_ANSWER_MACHINE_DETECTION_FIELD, AWAIT_ANSWER_MACHINE_PROMPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableAnswerMachineDetection;

    private final Boolean awaitAnswerMachinePrompt;

    private AnswerMachineDetectionConfig(BuilderImpl builder) {
        this.enableAnswerMachineDetection = builder.enableAnswerMachineDetection;
        this.awaitAnswerMachinePrompt = builder.awaitAnswerMachinePrompt;
    }

    /**
     * <p>
     * The flag to indicate if answer machine detection analysis needs to be performed for a voice call. If set to
     * <code>true</code>, <code>TrafficType</code> must be set as <code>CAMPAIGN</code>.
     * </p>
     * 
     * @return The flag to indicate if answer machine detection analysis needs to be performed for a voice call. If set
     *         to <code>true</code>, <code>TrafficType</code> must be set as <code>CAMPAIGN</code>.
     */
    public final Boolean enableAnswerMachineDetection() {
        return enableAnswerMachineDetection;
    }

    /**
     * <p>
     * Wait for the answering machine prompt.
     * </p>
     * 
     * @return Wait for the answering machine prompt.
     */
    public final Boolean awaitAnswerMachinePrompt() {
        return awaitAnswerMachinePrompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableAnswerMachineDetection());
        hashCode = 31 * hashCode + Objects.hashCode(awaitAnswerMachinePrompt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnswerMachineDetectionConfig)) {
            return false;
        }
        AnswerMachineDetectionConfig other = (AnswerMachineDetectionConfig) obj;
        return Objects.equals(enableAnswerMachineDetection(), other.enableAnswerMachineDetection())
                && Objects.equals(awaitAnswerMachinePrompt(), other.awaitAnswerMachinePrompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnswerMachineDetectionConfig")
                .add("EnableAnswerMachineDetection", enableAnswerMachineDetection())
                .add("AwaitAnswerMachinePrompt", awaitAnswerMachinePrompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableAnswerMachineDetection":
            return Optional.ofNullable(clazz.cast(enableAnswerMachineDetection()));
        case "AwaitAnswerMachinePrompt":
            return Optional.ofNullable(clazz.cast(awaitAnswerMachinePrompt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableAnswerMachineDetection", ENABLE_ANSWER_MACHINE_DETECTION_FIELD);
        map.put("AwaitAnswerMachinePrompt", AWAIT_ANSWER_MACHINE_PROMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnswerMachineDetectionConfig, T> g) {
        return obj -> g.apply((AnswerMachineDetectionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnswerMachineDetectionConfig> {
        /**
         * <p>
         * The flag to indicate if answer machine detection analysis needs to be performed for a voice call. If set to
         * <code>true</code>, <code>TrafficType</code> must be set as <code>CAMPAIGN</code>.
         * </p>
         * 
         * @param enableAnswerMachineDetection
         *        The flag to indicate if answer machine detection analysis needs to be performed for a voice call. If
         *        set to <code>true</code>, <code>TrafficType</code> must be set as <code>CAMPAIGN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAnswerMachineDetection(Boolean enableAnswerMachineDetection);

        /**
         * <p>
         * Wait for the answering machine prompt.
         * </p>
         * 
         * @param awaitAnswerMachinePrompt
         *        Wait for the answering machine prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awaitAnswerMachinePrompt(Boolean awaitAnswerMachinePrompt);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableAnswerMachineDetection;

        private Boolean awaitAnswerMachinePrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(AnswerMachineDetectionConfig model) {
            enableAnswerMachineDetection(model.enableAnswerMachineDetection);
            awaitAnswerMachinePrompt(model.awaitAnswerMachinePrompt);
        }

        public final Boolean getEnableAnswerMachineDetection() {
            return enableAnswerMachineDetection;
        }

        public final void setEnableAnswerMachineDetection(Boolean enableAnswerMachineDetection) {
            this.enableAnswerMachineDetection = enableAnswerMachineDetection;
        }

        @Override
        public final Builder enableAnswerMachineDetection(Boolean enableAnswerMachineDetection) {
            this.enableAnswerMachineDetection = enableAnswerMachineDetection;
            return this;
        }

        public final Boolean getAwaitAnswerMachinePrompt() {
            return awaitAnswerMachinePrompt;
        }

        public final void setAwaitAnswerMachinePrompt(Boolean awaitAnswerMachinePrompt) {
            this.awaitAnswerMachinePrompt = awaitAnswerMachinePrompt;
        }

        @Override
        public final Builder awaitAnswerMachinePrompt(Boolean awaitAnswerMachinePrompt) {
            this.awaitAnswerMachinePrompt = awaitAnswerMachinePrompt;
            return this;
        }

        @Override
        public AnswerMachineDetectionConfig build() {
            return new AnswerMachineDetectionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
