/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contact summary of a contact in contact tree associated with unique identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatedContactSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociatedContactSummary.Builder, AssociatedContactSummary> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(AssociatedContactSummary::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactArn").getter(getter(AssociatedContactSummary::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final SdkField<Instant> INITIATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InitiationTimestamp").getter(getter(AssociatedContactSummary::initiationTimestamp))
            .setter(setter(Builder::initiationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTimestamp").build())
            .build();

    private static final SdkField<Instant> DISCONNECT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DisconnectTimestamp").getter(getter(AssociatedContactSummary::disconnectTimestamp))
            .setter(setter(Builder::disconnectTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimestamp").build())
            .build();

    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialContactId").getter(getter(AssociatedContactSummary::initialContactId))
            .setter(setter(Builder::initialContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()).build();

    private static final SdkField<String> PREVIOUS_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreviousContactId").getter(getter(AssociatedContactSummary::previousContactId))
            .setter(setter(Builder::previousContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousContactId").build()).build();

    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedContactId").getter(getter(AssociatedContactSummary::relatedContactId))
            .setter(setter(Builder::relatedContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()).build();

    private static final SdkField<String> INITIATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitiationMethod").getter(getter(AssociatedContactSummary::initiationMethodAsString))
            .setter(setter(Builder::initiationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethod").build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(AssociatedContactSummary::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            CONTACT_ARN_FIELD, INITIATION_TIMESTAMP_FIELD, DISCONNECT_TIMESTAMP_FIELD, INITIAL_CONTACT_ID_FIELD,
            PREVIOUS_CONTACT_ID_FIELD, RELATED_CONTACT_ID_FIELD, INITIATION_METHOD_FIELD, CHANNEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactId;

    private final String contactArn;

    private final Instant initiationTimestamp;

    private final Instant disconnectTimestamp;

    private final String initialContactId;

    private final String previousContactId;

    private final String relatedContactId;

    private final String initiationMethod;

    private final String channel;

    private AssociatedContactSummary(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.contactArn = builder.contactArn;
        this.initiationTimestamp = builder.initiationTimestamp;
        this.disconnectTimestamp = builder.disconnectTimestamp;
        this.initialContactId = builder.initialContactId;
        this.previousContactId = builder.previousContactId;
        this.relatedContactId = builder.relatedContactId;
        this.initiationMethod = builder.initiationMethod;
        this.channel = builder.channel;
    }

    /**
     * <p>
     * The identifier of the contact in this instance of Amazon Connect.
     * </p>
     * 
     * @return The identifier of the contact in this instance of Amazon Connect.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact
     */
    public final String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The date and time this contact was initiated, in UTC time.
     * </p>
     * 
     * @return The date and time this contact was initiated, in UTC time.
     */
    public final Instant initiationTimestamp() {
        return initiationTimestamp;
    }

    /**
     * <p>
     * The date and time that the customer endpoint disconnected from the current contact, in UTC time. In transfer
     * scenarios, the DisconnectTimestamp of the previous contact indicates the date and time when that contact ended.
     * </p>
     * 
     * @return The date and time that the customer endpoint disconnected from the current contact, in UTC time. In
     *         transfer scenarios, the DisconnectTimestamp of the previous contact indicates the date and time when that
     *         contact ended.
     */
    public final Instant disconnectTimestamp() {
        return disconnectTimestamp;
    }

    /**
     * <p>
     * If this contact is related to other contacts, this is the ID of the initial contact.
     * </p>
     * 
     * @return If this contact is related to other contacts, this is the ID of the initial contact.
     */
    public final String initialContactId() {
        return initialContactId;
    }

    /**
     * <p>
     * If this contact is not the first contact, this is the ID of the previous contact.
     * </p>
     * 
     * @return If this contact is not the first contact, this is the ID of the previous contact.
     */
    public final String previousContactId() {
        return previousContactId;
    }

    /**
     * <p>
     * The contactId that is related to this contact.
     * </p>
     * 
     * @return The contactId that is related to this contact.
     */
    public final String relatedContactId() {
        return relatedContactId;
    }

    /**
     * <p>
     * Indicates how the contact was initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiationMethod}
     * will return {@link ContactInitiationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #initiationMethodAsString}.
     * </p>
     * 
     * @return Indicates how the contact was initiated.
     * @see ContactInitiationMethod
     */
    public final ContactInitiationMethod initiationMethod() {
        return ContactInitiationMethod.fromValue(initiationMethod);
    }

    /**
     * <p>
     * Indicates how the contact was initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiationMethod}
     * will return {@link ContactInitiationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #initiationMethodAsString}.
     * </p>
     * 
     * @return Indicates how the contact was initiated.
     * @see ContactInitiationMethod
     */
    public final String initiationMethodAsString() {
        return initiationMethod;
    }

    /**
     * <p>
     * How the contact reached your contact center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return How the contact reached your contact center.
     * @see Channel
     */
    public final Channel channel() {
        return Channel.fromValue(channel);
    }

    /**
     * <p>
     * How the contact reached your contact center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return How the contact reached your contact center.
     * @see Channel
     */
    public final String channelAsString() {
        return channel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(initiationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(previousContactId());
        hashCode = 31 * hashCode + Objects.hashCode(relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(initiationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedContactSummary)) {
            return false;
        }
        AssociatedContactSummary other = (AssociatedContactSummary) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(contactArn(), other.contactArn())
                && Objects.equals(initiationTimestamp(), other.initiationTimestamp())
                && Objects.equals(disconnectTimestamp(), other.disconnectTimestamp())
                && Objects.equals(initialContactId(), other.initialContactId())
                && Objects.equals(previousContactId(), other.previousContactId())
                && Objects.equals(relatedContactId(), other.relatedContactId())
                && Objects.equals(initiationMethodAsString(), other.initiationMethodAsString())
                && Objects.equals(channelAsString(), other.channelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatedContactSummary").add("ContactId", contactId()).add("ContactArn", contactArn())
                .add("InitiationTimestamp", initiationTimestamp()).add("DisconnectTimestamp", disconnectTimestamp())
                .add("InitialContactId", initialContactId()).add("PreviousContactId", previousContactId())
                .add("RelatedContactId", relatedContactId()).add("InitiationMethod", initiationMethodAsString())
                .add("Channel", channelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "InitiationTimestamp":
            return Optional.ofNullable(clazz.cast(initiationTimestamp()));
        case "DisconnectTimestamp":
            return Optional.ofNullable(clazz.cast(disconnectTimestamp()));
        case "InitialContactId":
            return Optional.ofNullable(clazz.cast(initialContactId()));
        case "PreviousContactId":
            return Optional.ofNullable(clazz.cast(previousContactId()));
        case "RelatedContactId":
            return Optional.ofNullable(clazz.cast(relatedContactId()));
        case "InitiationMethod":
            return Optional.ofNullable(clazz.cast(initiationMethodAsString()));
        case "Channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("ContactArn", CONTACT_ARN_FIELD);
        map.put("InitiationTimestamp", INITIATION_TIMESTAMP_FIELD);
        map.put("DisconnectTimestamp", DISCONNECT_TIMESTAMP_FIELD);
        map.put("InitialContactId", INITIAL_CONTACT_ID_FIELD);
        map.put("PreviousContactId", PREVIOUS_CONTACT_ID_FIELD);
        map.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
        map.put("InitiationMethod", INITIATION_METHOD_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociatedContactSummary, T> g) {
        return obj -> g.apply((AssociatedContactSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociatedContactSummary> {
        /**
         * <p>
         * The identifier of the contact in this instance of Amazon Connect.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact in this instance of Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact
         * </p>
         * 
         * @param contactArn
         *        The Amazon Resource Name (ARN) of the contact
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The date and time this contact was initiated, in UTC time.
         * </p>
         * 
         * @param initiationTimestamp
         *        The date and time this contact was initiated, in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiationTimestamp(Instant initiationTimestamp);

        /**
         * <p>
         * The date and time that the customer endpoint disconnected from the current contact, in UTC time. In transfer
         * scenarios, the DisconnectTimestamp of the previous contact indicates the date and time when that contact
         * ended.
         * </p>
         * 
         * @param disconnectTimestamp
         *        The date and time that the customer endpoint disconnected from the current contact, in UTC time. In
         *        transfer scenarios, the DisconnectTimestamp of the previous contact indicates the date and time when
         *        that contact ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimestamp(Instant disconnectTimestamp);

        /**
         * <p>
         * If this contact is related to other contacts, this is the ID of the initial contact.
         * </p>
         * 
         * @param initialContactId
         *        If this contact is related to other contacts, this is the ID of the initial contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialContactId(String initialContactId);

        /**
         * <p>
         * If this contact is not the first contact, this is the ID of the previous contact.
         * </p>
         * 
         * @param previousContactId
         *        If this contact is not the first contact, this is the ID of the previous contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousContactId(String previousContactId);

        /**
         * <p>
         * The contactId that is related to this contact.
         * </p>
         * 
         * @param relatedContactId
         *        The contactId that is related to this contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedContactId(String relatedContactId);

        /**
         * <p>
         * Indicates how the contact was initiated.
         * </p>
         * 
         * @param initiationMethod
         *        Indicates how the contact was initiated.
         * @see ContactInitiationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactInitiationMethod
         */
        Builder initiationMethod(String initiationMethod);

        /**
         * <p>
         * Indicates how the contact was initiated.
         * </p>
         * 
         * @param initiationMethod
         *        Indicates how the contact was initiated.
         * @see ContactInitiationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactInitiationMethod
         */
        Builder initiationMethod(ContactInitiationMethod initiationMethod);

        /**
         * <p>
         * How the contact reached your contact center.
         * </p>
         * 
         * @param channel
         *        How the contact reached your contact center.
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(String channel);

        /**
         * <p>
         * How the contact reached your contact center.
         * </p>
         * 
         * @param channel
         *        How the contact reached your contact center.
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(Channel channel);
    }

    static final class BuilderImpl implements Builder {
        private String contactId;

        private String contactArn;

        private Instant initiationTimestamp;

        private Instant disconnectTimestamp;

        private String initialContactId;

        private String previousContactId;

        private String relatedContactId;

        private String initiationMethod;

        private String channel;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedContactSummary model) {
            contactId(model.contactId);
            contactArn(model.contactArn);
            initiationTimestamp(model.initiationTimestamp);
            disconnectTimestamp(model.disconnectTimestamp);
            initialContactId(model.initialContactId);
            previousContactId(model.previousContactId);
            relatedContactId(model.relatedContactId);
            initiationMethod(model.initiationMethod);
            channel(model.channel);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final Instant getInitiationTimestamp() {
            return initiationTimestamp;
        }

        public final void setInitiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
        }

        @Override
        public final Builder initiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
            return this;
        }

        public final Instant getDisconnectTimestamp() {
            return disconnectTimestamp;
        }

        public final void setDisconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
        }

        @Override
        public final Builder disconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
            return this;
        }

        public final String getInitialContactId() {
            return initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getPreviousContactId() {
            return previousContactId;
        }

        public final void setPreviousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
        }

        @Override
        public final Builder previousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
            return this;
        }

        public final String getRelatedContactId() {
            return relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final String getInitiationMethod() {
            return initiationMethod;
        }

        public final void setInitiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
        }

        @Override
        public final Builder initiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
            return this;
        }

        @Override
        public final Builder initiationMethod(ContactInitiationMethod initiationMethod) {
            this.initiationMethod(initiationMethod == null ? null : initiationMethod.toString());
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        @Override
        public AssociatedContactSummary build() {
            return new AssociatedContactSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
