/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information of returned contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactSearchSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactSearchSummary.Builder, ContactSearchSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ContactSearchSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ContactSearchSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialContactId").getter(getter(ContactSearchSummary::initialContactId))
            .setter(setter(Builder::initialContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialContactId").build()).build();

    private static final SdkField<String> PREVIOUS_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreviousContactId").getter(getter(ContactSearchSummary::previousContactId))
            .setter(setter(Builder::previousContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousContactId").build()).build();

    private static final SdkField<String> INITIATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitiationMethod").getter(getter(ContactSearchSummary::initiationMethodAsString))
            .setter(setter(Builder::initiationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethod").build()).build();

    private static final SdkField<String> CHANNEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Channel")
            .getter(getter(ContactSearchSummary::channelAsString)).setter(setter(Builder::channel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()).build();

    private static final SdkField<ContactSearchSummaryQueueInfo> QUEUE_INFO_FIELD = SdkField
            .<ContactSearchSummaryQueueInfo> builder(MarshallingType.SDK_POJO).memberName("QueueInfo")
            .getter(getter(ContactSearchSummary::queueInfo)).setter(setter(Builder::queueInfo))
            .constructor(ContactSearchSummaryQueueInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueInfo").build()).build();

    private static final SdkField<ContactSearchSummaryAgentInfo> AGENT_INFO_FIELD = SdkField
            .<ContactSearchSummaryAgentInfo> builder(MarshallingType.SDK_POJO).memberName("AgentInfo")
            .getter(getter(ContactSearchSummary::agentInfo)).setter(setter(Builder::agentInfo))
            .constructor(ContactSearchSummaryAgentInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentInfo").build()).build();

    private static final SdkField<Instant> INITIATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InitiationTimestamp").getter(getter(ContactSearchSummary::initiationTimestamp))
            .setter(setter(Builder::initiationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationTimestamp").build())
            .build();

    private static final SdkField<Instant> DISCONNECT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DisconnectTimestamp").getter(getter(ContactSearchSummary::disconnectTimestamp))
            .setter(setter(Builder::disconnectTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimestamp").build())
            .build();

    private static final SdkField<Instant> SCHEDULED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScheduledTimestamp").getter(getter(ContactSearchSummary::scheduledTimestamp))
            .setter(setter(Builder::scheduledTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTimestamp").build())
            .build();

    private static final SdkField<Map<String, ContactSearchSummarySegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField
            .<Map<String, ContactSearchSummarySegmentAttributeValue>> builder(MarshallingType.MAP)
            .memberName("SegmentAttributes")
            .getter(getter(ContactSearchSummary::segmentAttributes))
            .setter(setter(Builder::segmentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ContactSearchSummarySegmentAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactSearchSummarySegmentAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            INITIAL_CONTACT_ID_FIELD, PREVIOUS_CONTACT_ID_FIELD, INITIATION_METHOD_FIELD, CHANNEL_FIELD, QUEUE_INFO_FIELD,
            AGENT_INFO_FIELD, INITIATION_TIMESTAMP_FIELD, DISCONNECT_TIMESTAMP_FIELD, SCHEDULED_TIMESTAMP_FIELD,
            SEGMENT_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String initialContactId;

    private final String previousContactId;

    private final String initiationMethod;

    private final String channel;

    private final ContactSearchSummaryQueueInfo queueInfo;

    private final ContactSearchSummaryAgentInfo agentInfo;

    private final Instant initiationTimestamp;

    private final Instant disconnectTimestamp;

    private final Instant scheduledTimestamp;

    private final Map<String, ContactSearchSummarySegmentAttributeValue> segmentAttributes;

    private ContactSearchSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.initialContactId = builder.initialContactId;
        this.previousContactId = builder.previousContactId;
        this.initiationMethod = builder.initiationMethod;
        this.channel = builder.channel;
        this.queueInfo = builder.queueInfo;
        this.agentInfo = builder.agentInfo;
        this.initiationTimestamp = builder.initiationTimestamp;
        this.disconnectTimestamp = builder.disconnectTimestamp;
        this.scheduledTimestamp = builder.scheduledTimestamp;
        this.segmentAttributes = builder.segmentAttributes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The identifier of the contact summary.
     * </p>
     * 
     * @return The identifier of the contact summary.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * If this contact is related to other contacts, this is the ID of the initial contact.
     * </p>
     * 
     * @return If this contact is related to other contacts, this is the ID of the initial contact.
     */
    public final String initialContactId() {
        return initialContactId;
    }

    /**
     * <p>
     * If this contact is not the first contact, this is the ID of the previous contact.
     * </p>
     * 
     * @return If this contact is not the first contact, this is the ID of the previous contact.
     */
    public final String previousContactId() {
        return previousContactId;
    }

    /**
     * <p>
     * Indicates how the contact was initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiationMethod}
     * will return {@link ContactInitiationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #initiationMethodAsString}.
     * </p>
     * 
     * @return Indicates how the contact was initiated.
     * @see ContactInitiationMethod
     */
    public final ContactInitiationMethod initiationMethod() {
        return ContactInitiationMethod.fromValue(initiationMethod);
    }

    /**
     * <p>
     * Indicates how the contact was initiated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiationMethod}
     * will return {@link ContactInitiationMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #initiationMethodAsString}.
     * </p>
     * 
     * @return Indicates how the contact was initiated.
     * @see ContactInitiationMethod
     */
    public final String initiationMethodAsString() {
        return initiationMethod;
    }

    /**
     * <p>
     * How the contact reached your contact center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return How the contact reached your contact center.
     * @see Channel
     */
    public final Channel channel() {
        return Channel.fromValue(channel);
    }

    /**
     * <p>
     * How the contact reached your contact center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channel} will
     * return {@link Channel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelAsString}.
     * </p>
     * 
     * @return How the contact reached your contact center.
     * @see Channel
     */
    public final String channelAsString() {
        return channel;
    }

    /**
     * <p>
     * If this contact was queued, this contains information about the queue.
     * </p>
     * 
     * @return If this contact was queued, this contains information about the queue.
     */
    public final ContactSearchSummaryQueueInfo queueInfo() {
        return queueInfo;
    }

    /**
     * <p>
     * Information about the agent who accepted the contact.
     * </p>
     * 
     * @return Information about the agent who accepted the contact.
     */
    public final ContactSearchSummaryAgentInfo agentInfo() {
        return agentInfo;
    }

    /**
     * <p>
     * The date and time this contact was initiated, in UTC time. For <code>INBOUND</code>, this is when the contact
     * arrived. For <code>OUTBOUND</code>, this is when the agent began dialing. For <code>CALLBACK</code>, this is when
     * the callback contact was created. For <code>TRANSFER</code> and <code>QUEUE_TRANSFER</code>, this is when the
     * transfer was initiated. For API, this is when the request arrived. For <code>EXTERNAL_OUTBOUND</code>, this is
     * when the agent started dialing the external participant. For <code>MONITOR</code>, this is when the supervisor
     * started listening to a contact.
     * </p>
     * 
     * @return The date and time this contact was initiated, in UTC time. For <code>INBOUND</code>, this is when the
     *         contact arrived. For <code>OUTBOUND</code>, this is when the agent began dialing. For
     *         <code>CALLBACK</code>, this is when the callback contact was created. For <code>TRANSFER</code> and
     *         <code>QUEUE_TRANSFER</code>, this is when the transfer was initiated. For API, this is when the request
     *         arrived. For <code>EXTERNAL_OUTBOUND</code>, this is when the agent started dialing the external
     *         participant. For <code>MONITOR</code>, this is when the supervisor started listening to a contact.
     */
    public final Instant initiationTimestamp() {
        return initiationTimestamp;
    }

    /**
     * <p>
     * The timestamp when the customer endpoint disconnected from Amazon Connect.
     * </p>
     * 
     * @return The timestamp when the customer endpoint disconnected from Amazon Connect.
     */
    public final Instant disconnectTimestamp() {
        return disconnectTimestamp;
    }

    /**
     * <p>
     * The timestamp, in Unix epoch time format, at which to start running the inbound flow.
     * </p>
     * 
     * @return The timestamp, in Unix epoch time format, at which to start running the inbound flow.
     */
    public final Instant scheduledTimestamp() {
        return scheduledTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSegmentAttributes() {
        return segmentAttributes != null && !(segmentAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Set of segment attributes for a contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentAttributes} method.
     * </p>
     * 
     * @return Set of segment attributes for a contact.
     */
    public final Map<String, ContactSearchSummarySegmentAttributeValue> segmentAttributes() {
        return segmentAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(previousContactId());
        hashCode = 31 * hashCode + Objects.hashCode(initiationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(agentInfo());
        hashCode = 31 * hashCode + Objects.hashCode(initiationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentAttributes() ? segmentAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactSearchSummary)) {
            return false;
        }
        ContactSearchSummary other = (ContactSearchSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(initialContactId(), other.initialContactId())
                && Objects.equals(previousContactId(), other.previousContactId())
                && Objects.equals(initiationMethodAsString(), other.initiationMethodAsString())
                && Objects.equals(channelAsString(), other.channelAsString()) && Objects.equals(queueInfo(), other.queueInfo())
                && Objects.equals(agentInfo(), other.agentInfo())
                && Objects.equals(initiationTimestamp(), other.initiationTimestamp())
                && Objects.equals(disconnectTimestamp(), other.disconnectTimestamp())
                && Objects.equals(scheduledTimestamp(), other.scheduledTimestamp())
                && hasSegmentAttributes() == other.hasSegmentAttributes()
                && Objects.equals(segmentAttributes(), other.segmentAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactSearchSummary").add("Arn", arn()).add("Id", id())
                .add("InitialContactId", initialContactId()).add("PreviousContactId", previousContactId())
                .add("InitiationMethod", initiationMethodAsString()).add("Channel", channelAsString())
                .add("QueueInfo", queueInfo()).add("AgentInfo", agentInfo()).add("InitiationTimestamp", initiationTimestamp())
                .add("DisconnectTimestamp", disconnectTimestamp()).add("ScheduledTimestamp", scheduledTimestamp())
                .add("SegmentAttributes", segmentAttributes() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InitialContactId":
            return Optional.ofNullable(clazz.cast(initialContactId()));
        case "PreviousContactId":
            return Optional.ofNullable(clazz.cast(previousContactId()));
        case "InitiationMethod":
            return Optional.ofNullable(clazz.cast(initiationMethodAsString()));
        case "Channel":
            return Optional.ofNullable(clazz.cast(channelAsString()));
        case "QueueInfo":
            return Optional.ofNullable(clazz.cast(queueInfo()));
        case "AgentInfo":
            return Optional.ofNullable(clazz.cast(agentInfo()));
        case "InitiationTimestamp":
            return Optional.ofNullable(clazz.cast(initiationTimestamp()));
        case "DisconnectTimestamp":
            return Optional.ofNullable(clazz.cast(disconnectTimestamp()));
        case "ScheduledTimestamp":
            return Optional.ofNullable(clazz.cast(scheduledTimestamp()));
        case "SegmentAttributes":
            return Optional.ofNullable(clazz.cast(segmentAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("InitialContactId", INITIAL_CONTACT_ID_FIELD);
        map.put("PreviousContactId", PREVIOUS_CONTACT_ID_FIELD);
        map.put("InitiationMethod", INITIATION_METHOD_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        map.put("QueueInfo", QUEUE_INFO_FIELD);
        map.put("AgentInfo", AGENT_INFO_FIELD);
        map.put("InitiationTimestamp", INITIATION_TIMESTAMP_FIELD);
        map.put("DisconnectTimestamp", DISCONNECT_TIMESTAMP_FIELD);
        map.put("ScheduledTimestamp", SCHEDULED_TIMESTAMP_FIELD);
        map.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactSearchSummary, T> g) {
        return obj -> g.apply((ContactSearchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactSearchSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The identifier of the contact summary.
         * </p>
         * 
         * @param id
         *        The identifier of the contact summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * If this contact is related to other contacts, this is the ID of the initial contact.
         * </p>
         * 
         * @param initialContactId
         *        If this contact is related to other contacts, this is the ID of the initial contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialContactId(String initialContactId);

        /**
         * <p>
         * If this contact is not the first contact, this is the ID of the previous contact.
         * </p>
         * 
         * @param previousContactId
         *        If this contact is not the first contact, this is the ID of the previous contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousContactId(String previousContactId);

        /**
         * <p>
         * Indicates how the contact was initiated.
         * </p>
         * 
         * @param initiationMethod
         *        Indicates how the contact was initiated.
         * @see ContactInitiationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactInitiationMethod
         */
        Builder initiationMethod(String initiationMethod);

        /**
         * <p>
         * Indicates how the contact was initiated.
         * </p>
         * 
         * @param initiationMethod
         *        Indicates how the contact was initiated.
         * @see ContactInitiationMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactInitiationMethod
         */
        Builder initiationMethod(ContactInitiationMethod initiationMethod);

        /**
         * <p>
         * How the contact reached your contact center.
         * </p>
         * 
         * @param channel
         *        How the contact reached your contact center.
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(String channel);

        /**
         * <p>
         * How the contact reached your contact center.
         * </p>
         * 
         * @param channel
         *        How the contact reached your contact center.
         * @see Channel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Channel
         */
        Builder channel(Channel channel);

        /**
         * <p>
         * If this contact was queued, this contains information about the queue.
         * </p>
         * 
         * @param queueInfo
         *        If this contact was queued, this contains information about the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueInfo(ContactSearchSummaryQueueInfo queueInfo);

        /**
         * <p>
         * If this contact was queued, this contains information about the queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactSearchSummaryQueueInfo.Builder}
         * avoiding the need to create one manually via {@link ContactSearchSummaryQueueInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactSearchSummaryQueueInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #queueInfo(ContactSearchSummaryQueueInfo)}.
         * 
         * @param queueInfo
         *        a consumer that will call methods on {@link ContactSearchSummaryQueueInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueInfo(ContactSearchSummaryQueueInfo)
         */
        default Builder queueInfo(Consumer<ContactSearchSummaryQueueInfo.Builder> queueInfo) {
            return queueInfo(ContactSearchSummaryQueueInfo.builder().applyMutation(queueInfo).build());
        }

        /**
         * <p>
         * Information about the agent who accepted the contact.
         * </p>
         * 
         * @param agentInfo
         *        Information about the agent who accepted the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentInfo(ContactSearchSummaryAgentInfo agentInfo);

        /**
         * <p>
         * Information about the agent who accepted the contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContactSearchSummaryAgentInfo.Builder}
         * avoiding the need to create one manually via {@link ContactSearchSummaryAgentInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContactSearchSummaryAgentInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #agentInfo(ContactSearchSummaryAgentInfo)}.
         * 
         * @param agentInfo
         *        a consumer that will call methods on {@link ContactSearchSummaryAgentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentInfo(ContactSearchSummaryAgentInfo)
         */
        default Builder agentInfo(Consumer<ContactSearchSummaryAgentInfo.Builder> agentInfo) {
            return agentInfo(ContactSearchSummaryAgentInfo.builder().applyMutation(agentInfo).build());
        }

        /**
         * <p>
         * The date and time this contact was initiated, in UTC time. For <code>INBOUND</code>, this is when the contact
         * arrived. For <code>OUTBOUND</code>, this is when the agent began dialing. For <code>CALLBACK</code>, this is
         * when the callback contact was created. For <code>TRANSFER</code> and <code>QUEUE_TRANSFER</code>, this is
         * when the transfer was initiated. For API, this is when the request arrived. For
         * <code>EXTERNAL_OUTBOUND</code>, this is when the agent started dialing the external participant. For
         * <code>MONITOR</code>, this is when the supervisor started listening to a contact.
         * </p>
         * 
         * @param initiationTimestamp
         *        The date and time this contact was initiated, in UTC time. For <code>INBOUND</code>, this is when the
         *        contact arrived. For <code>OUTBOUND</code>, this is when the agent began dialing. For
         *        <code>CALLBACK</code>, this is when the callback contact was created. For <code>TRANSFER</code> and
         *        <code>QUEUE_TRANSFER</code>, this is when the transfer was initiated. For API, this is when the
         *        request arrived. For <code>EXTERNAL_OUTBOUND</code>, this is when the agent started dialing the
         *        external participant. For <code>MONITOR</code>, this is when the supervisor started listening to a
         *        contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiationTimestamp(Instant initiationTimestamp);

        /**
         * <p>
         * The timestamp when the customer endpoint disconnected from Amazon Connect.
         * </p>
         * 
         * @param disconnectTimestamp
         *        The timestamp when the customer endpoint disconnected from Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimestamp(Instant disconnectTimestamp);

        /**
         * <p>
         * The timestamp, in Unix epoch time format, at which to start running the inbound flow.
         * </p>
         * 
         * @param scheduledTimestamp
         *        The timestamp, in Unix epoch time format, at which to start running the inbound flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledTimestamp(Instant scheduledTimestamp);

        /**
         * <p>
         * Set of segment attributes for a contact.
         * </p>
         * 
         * @param segmentAttributes
         *        Set of segment attributes for a contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentAttributes(Map<String, ContactSearchSummarySegmentAttributeValue> segmentAttributes);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String initialContactId;

        private String previousContactId;

        private String initiationMethod;

        private String channel;

        private ContactSearchSummaryQueueInfo queueInfo;

        private ContactSearchSummaryAgentInfo agentInfo;

        private Instant initiationTimestamp;

        private Instant disconnectTimestamp;

        private Instant scheduledTimestamp;

        private Map<String, ContactSearchSummarySegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContactSearchSummary model) {
            arn(model.arn);
            id(model.id);
            initialContactId(model.initialContactId);
            previousContactId(model.previousContactId);
            initiationMethod(model.initiationMethod);
            channel(model.channel);
            queueInfo(model.queueInfo);
            agentInfo(model.agentInfo);
            initiationTimestamp(model.initiationTimestamp);
            disconnectTimestamp(model.disconnectTimestamp);
            scheduledTimestamp(model.scheduledTimestamp);
            segmentAttributes(model.segmentAttributes);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getInitialContactId() {
            return initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getPreviousContactId() {
            return previousContactId;
        }

        public final void setPreviousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
        }

        @Override
        public final Builder previousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
            return this;
        }

        public final String getInitiationMethod() {
            return initiationMethod;
        }

        public final void setInitiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
        }

        @Override
        public final Builder initiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
            return this;
        }

        @Override
        public final Builder initiationMethod(ContactInitiationMethod initiationMethod) {
            this.initiationMethod(initiationMethod == null ? null : initiationMethod.toString());
            return this;
        }

        public final String getChannel() {
            return channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final ContactSearchSummaryQueueInfo.Builder getQueueInfo() {
            return queueInfo != null ? queueInfo.toBuilder() : null;
        }

        public final void setQueueInfo(ContactSearchSummaryQueueInfo.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        @Override
        public final Builder queueInfo(ContactSearchSummaryQueueInfo queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final ContactSearchSummaryAgentInfo.Builder getAgentInfo() {
            return agentInfo != null ? agentInfo.toBuilder() : null;
        }

        public final void setAgentInfo(ContactSearchSummaryAgentInfo.BuilderImpl agentInfo) {
            this.agentInfo = agentInfo != null ? agentInfo.build() : null;
        }

        @Override
        public final Builder agentInfo(ContactSearchSummaryAgentInfo agentInfo) {
            this.agentInfo = agentInfo;
            return this;
        }

        public final Instant getInitiationTimestamp() {
            return initiationTimestamp;
        }

        public final void setInitiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
        }

        @Override
        public final Builder initiationTimestamp(Instant initiationTimestamp) {
            this.initiationTimestamp = initiationTimestamp;
            return this;
        }

        public final Instant getDisconnectTimestamp() {
            return disconnectTimestamp;
        }

        public final void setDisconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
        }

        @Override
        public final Builder disconnectTimestamp(Instant disconnectTimestamp) {
            this.disconnectTimestamp = disconnectTimestamp;
            return this;
        }

        public final Instant getScheduledTimestamp() {
            return scheduledTimestamp;
        }

        public final void setScheduledTimestamp(Instant scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
        }

        @Override
        public final Builder scheduledTimestamp(Instant scheduledTimestamp) {
            this.scheduledTimestamp = scheduledTimestamp;
            return this;
        }

        public final Map<String, ContactSearchSummarySegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, ContactSearchSummarySegmentAttributeValue.Builder> result = ContactSearchSummarySegmentAttributesCopier
                    .copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(
                Map<String, ContactSearchSummarySegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = ContactSearchSummarySegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, ContactSearchSummarySegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = ContactSearchSummarySegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        @Override
        public ContactSearchSummary build() {
            return new ContactSearchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
