/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of a segment attribute. This is structured as a map with a single key-value pair. The key 'valueString'
 * indicates that the attribute type is a string, and its corresponding value is the actual string value of the segment
 * attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactSearchSummarySegmentAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactSearchSummarySegmentAttributeValue.Builder, ContactSearchSummarySegmentAttributeValue> {
    private static final SdkField<String> VALUE_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueString").getter(getter(ContactSearchSummarySegmentAttributeValue::valueString))
            .setter(setter(Builder::valueString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_STRING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String valueString;

    private ContactSearchSummarySegmentAttributeValue(BuilderImpl builder) {
        this.valueString = builder.valueString;
    }

    /**
     * <p>
     * The value of a segment attribute represented as a string.
     * </p>
     * 
     * @return The value of a segment attribute represented as a string.
     */
    public final String valueString() {
        return valueString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valueString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactSearchSummarySegmentAttributeValue)) {
            return false;
        }
        ContactSearchSummarySegmentAttributeValue other = (ContactSearchSummarySegmentAttributeValue) obj;
        return Objects.equals(valueString(), other.valueString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactSearchSummarySegmentAttributeValue").add("ValueString", valueString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValueString":
            return Optional.ofNullable(clazz.cast(valueString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ValueString", VALUE_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactSearchSummarySegmentAttributeValue, T> g) {
        return obj -> g.apply((ContactSearchSummarySegmentAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactSearchSummarySegmentAttributeValue> {
        /**
         * <p>
         * The value of a segment attribute represented as a string.
         * </p>
         * 
         * @param valueString
         *        The value of a segment attribute represented as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueString(String valueString);
    }

    static final class BuilderImpl implements Builder {
        private String valueString;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactSearchSummarySegmentAttributeValue model) {
            valueString(model.valueString);
        }

        public final String getValueString() {
            return valueString;
        }

        public final void setValueString(String valueString) {
            this.valueString = valueString;
        }

        @Override
        public final Builder valueString(String valueString) {
            this.valueString = valueString;
            return this;
        }

        @Override
        public ContactSearchSummarySegmentAttributeValue build() {
            return new ContactSearchSummarySegmentAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
