/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAgentStatusResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateAgentStatusResponse.Builder, CreateAgentStatusResponse> {
    private static final SdkField<String> AGENT_STATUS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentStatusARN").getter(getter(CreateAgentStatusResponse::agentStatusARN))
            .setter(setter(Builder::agentStatusARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatusARN").build()).build();

    private static final SdkField<String> AGENT_STATUS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentStatusId").getter(getter(CreateAgentStatusResponse::agentStatusId))
            .setter(setter(Builder::agentStatusId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentStatusId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_STATUS_ARN_FIELD,
            AGENT_STATUS_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String agentStatusARN;

    private final String agentStatusId;

    private CreateAgentStatusResponse(BuilderImpl builder) {
        super(builder);
        this.agentStatusARN = builder.agentStatusARN;
        this.agentStatusId = builder.agentStatusId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the agent status.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the agent status.
     */
    public final String agentStatusARN() {
        return agentStatusARN;
    }

    /**
     * <p>
     * The identifier of the agent status.
     * </p>
     * 
     * @return The identifier of the agent status.
     */
    public final String agentStatusId() {
        return agentStatusId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentStatusARN());
        hashCode = 31 * hashCode + Objects.hashCode(agentStatusId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAgentStatusResponse)) {
            return false;
        }
        CreateAgentStatusResponse other = (CreateAgentStatusResponse) obj;
        return Objects.equals(agentStatusARN(), other.agentStatusARN()) && Objects.equals(agentStatusId(), other.agentStatusId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAgentStatusResponse").add("AgentStatusARN", agentStatusARN())
                .add("AgentStatusId", agentStatusId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentStatusARN":
            return Optional.ofNullable(clazz.cast(agentStatusARN()));
        case "AgentStatusId":
            return Optional.ofNullable(clazz.cast(agentStatusId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AgentStatusARN", AGENT_STATUS_ARN_FIELD);
        map.put("AgentStatusId", AGENT_STATUS_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAgentStatusResponse, T> g) {
        return obj -> g.apply((CreateAgentStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAgentStatusResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the agent status.
         * </p>
         * 
         * @param agentStatusARN
         *        The Amazon Resource Name (ARN) of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentStatusARN(String agentStatusARN);

        /**
         * <p>
         * The identifier of the agent status.
         * </p>
         * 
         * @param agentStatusId
         *        The identifier of the agent status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentStatusId(String agentStatusId);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String agentStatusARN;

        private String agentStatusId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAgentStatusResponse model) {
            super(model);
            agentStatusARN(model.agentStatusARN);
            agentStatusId(model.agentStatusId);
        }

        public final String getAgentStatusARN() {
            return agentStatusARN;
        }

        public final void setAgentStatusARN(String agentStatusARN) {
            this.agentStatusARN = agentStatusARN;
        }

        @Override
        public final Builder agentStatusARN(String agentStatusARN) {
            this.agentStatusARN = agentStatusARN;
            return this;
        }

        public final String getAgentStatusId() {
            return agentStatusId;
        }

        public final void setAgentStatusId(String agentStatusId) {
            this.agentStatusId = agentStatusId;
        }

        @Override
        public final Builder agentStatusId(String agentStatusId) {
            this.agentStatusId = agentStatusId;
            return this;
        }

        @Override
        public CreateAgentStatusResponse build() {
            return new CreateAgentStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
