/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRoutingProfileRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateRoutingProfileRequest.Builder, CreateRoutingProfileRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateRoutingProfileRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateRoutingProfileRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateRoutingProfileRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEFAULT_OUTBOUND_QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultOutboundQueueId").getter(getter(CreateRoutingProfileRequest::defaultOutboundQueueId))
            .setter(setter(Builder::defaultOutboundQueueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOutboundQueueId").build())
            .build();

    private static final SdkField<List<RoutingProfileQueueConfig>> QUEUE_CONFIGS_FIELD = SdkField
            .<List<RoutingProfileQueueConfig>> builder(MarshallingType.LIST)
            .memberName("QueueConfigs")
            .getter(getter(CreateRoutingProfileRequest::queueConfigs))
            .setter(setter(Builder::queueConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutingProfileQueueConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutingProfileQueueConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MediaConcurrency>> MEDIA_CONCURRENCIES_FIELD = SdkField
            .<List<MediaConcurrency>> builder(MarshallingType.LIST)
            .memberName("MediaConcurrencies")
            .getter(getter(CreateRoutingProfileRequest::mediaConcurrencies))
            .setter(setter(Builder::mediaConcurrencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaConcurrencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaConcurrency> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaConcurrency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateRoutingProfileRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> AGENT_AVAILABILITY_TIMER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentAvailabilityTimer").getter(getter(CreateRoutingProfileRequest::agentAvailabilityTimerAsString))
            .setter(setter(Builder::agentAvailabilityTimer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentAvailabilityTimer").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, DEFAULT_OUTBOUND_QUEUE_ID_FIELD, QUEUE_CONFIGS_FIELD, MEDIA_CONCURRENCIES_FIELD, TAGS_FIELD,
            AGENT_AVAILABILITY_TIMER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String name;

    private final String description;

    private final String defaultOutboundQueueId;

    private final List<RoutingProfileQueueConfig> queueConfigs;

    private final List<MediaConcurrency> mediaConcurrencies;

    private final Map<String, String> tags;

    private final String agentAvailabilityTimer;

    private CreateRoutingProfileRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.description = builder.description;
        this.defaultOutboundQueueId = builder.defaultOutboundQueueId;
        this.queueConfigs = builder.queueConfigs;
        this.mediaConcurrencies = builder.mediaConcurrencies;
        this.tags = builder.tags;
        this.agentAvailabilityTimer = builder.agentAvailabilityTimer;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the routing profile. Must not be more than 127 characters.
     * </p>
     * 
     * @return The name of the routing profile. Must not be more than 127 characters.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Description of the routing profile. Must not be more than 250 characters.
     * </p>
     * 
     * @return Description of the routing profile. Must not be more than 250 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The default outbound queue for the routing profile.
     * </p>
     * 
     * @return The default outbound queue for the routing profile.
     */
    public final String defaultOutboundQueueId() {
        return defaultOutboundQueueId;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueueConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueueConfigs() {
        return queueConfigs != null && !(queueConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound
     * calls.
     * </p>
     * <p>
     * The limit of 10 array members applies to the maximum number of <code>RoutingProfileQueueConfig</code> objects
     * that can be passed during a CreateRoutingProfile API request. It is different from the quota of 50 queues per
     * routing profile per instance that is listed in <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect
     * service quotas</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueueConfigs} method.
     * </p>
     * 
     * @return The inbound queues associated with the routing profile. If no queue is added, the agent can make only
     *         outbound calls.</p>
     *         <p>
     *         The limit of 10 array members applies to the maximum number of <code>RoutingProfileQueueConfig</code>
     *         objects that can be passed during a CreateRoutingProfile API request. It is different from the quota of
     *         50 queues per routing profile per instance that is listed in <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect service quotas</a>.
     */
    public final List<RoutingProfileQueueConfig> queueConfigs() {
        return queueConfigs;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaConcurrencies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaConcurrencies() {
        return mediaConcurrencies != null && !(mediaConcurrencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaConcurrencies} method.
     * </p>
     * 
     * @return The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
     */
    public final List<MediaConcurrency> mediaConcurrencies() {
        return mediaConcurrencies;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "Tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Whether agents with this routing profile will have their routing order calculated based on <i>longest idle
     * time</i> or <i>time since their last inbound contact</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentAvailabilityTimer} will return {@link AgentAvailabilityTimer#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #agentAvailabilityTimerAsString}.
     * </p>
     * 
     * @return Whether agents with this routing profile will have their routing order calculated based on <i>longest
     *         idle time</i> or <i>time since their last inbound contact</i>.
     * @see AgentAvailabilityTimer
     */
    public final AgentAvailabilityTimer agentAvailabilityTimer() {
        return AgentAvailabilityTimer.fromValue(agentAvailabilityTimer);
    }

    /**
     * <p>
     * Whether agents with this routing profile will have their routing order calculated based on <i>longest idle
     * time</i> or <i>time since their last inbound contact</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #agentAvailabilityTimer} will return {@link AgentAvailabilityTimer#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #agentAvailabilityTimerAsString}.
     * </p>
     * 
     * @return Whether agents with this routing profile will have their routing order calculated based on <i>longest
     *         idle time</i> or <i>time since their last inbound contact</i>.
     * @see AgentAvailabilityTimer
     */
    public final String agentAvailabilityTimerAsString() {
        return agentAvailabilityTimer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOutboundQueueId());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueueConfigs() ? queueConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaConcurrencies() ? mediaConcurrencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(agentAvailabilityTimerAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoutingProfileRequest)) {
            return false;
        }
        CreateRoutingProfileRequest other = (CreateRoutingProfileRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(defaultOutboundQueueId(), other.defaultOutboundQueueId())
                && hasQueueConfigs() == other.hasQueueConfigs() && Objects.equals(queueConfigs(), other.queueConfigs())
                && hasMediaConcurrencies() == other.hasMediaConcurrencies()
                && Objects.equals(mediaConcurrencies(), other.mediaConcurrencies()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(agentAvailabilityTimerAsString(), other.agentAvailabilityTimerAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRoutingProfileRequest").add("InstanceId", instanceId()).add("Name", name())
                .add("Description", description()).add("DefaultOutboundQueueId", defaultOutboundQueueId())
                .add("QueueConfigs", hasQueueConfigs() ? queueConfigs() : null)
                .add("MediaConcurrencies", hasMediaConcurrencies() ? mediaConcurrencies() : null)
                .add("Tags", hasTags() ? tags() : null).add("AgentAvailabilityTimer", agentAvailabilityTimerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultOutboundQueueId":
            return Optional.ofNullable(clazz.cast(defaultOutboundQueueId()));
        case "QueueConfigs":
            return Optional.ofNullable(clazz.cast(queueConfigs()));
        case "MediaConcurrencies":
            return Optional.ofNullable(clazz.cast(mediaConcurrencies()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AgentAvailabilityTimer":
            return Optional.ofNullable(clazz.cast(agentAvailabilityTimerAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DefaultOutboundQueueId", DEFAULT_OUTBOUND_QUEUE_ID_FIELD);
        map.put("QueueConfigs", QUEUE_CONFIGS_FIELD);
        map.put("MediaConcurrencies", MEDIA_CONCURRENCIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AgentAvailabilityTimer", AGENT_AVAILABILITY_TIMER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRoutingProfileRequest, T> g) {
        return obj -> g.apply((CreateRoutingProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRoutingProfileRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the routing profile. Must not be more than 127 characters.
         * </p>
         * 
         * @param name
         *        The name of the routing profile. Must not be more than 127 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description of the routing profile. Must not be more than 250 characters.
         * </p>
         * 
         * @param description
         *        Description of the routing profile. Must not be more than 250 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The default outbound queue for the routing profile.
         * </p>
         * 
         * @param defaultOutboundQueueId
         *        The default outbound queue for the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOutboundQueueId(String defaultOutboundQueueId);

        /**
         * <p>
         * The inbound queues associated with the routing profile. If no queue is added, the agent can make only
         * outbound calls.
         * </p>
         * <p>
         * The limit of 10 array members applies to the maximum number of <code>RoutingProfileQueueConfig</code> objects
         * that can be passed during a CreateRoutingProfile API request. It is different from the quota of 50 queues per
         * routing profile per instance that is listed in <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
         * Connect service quotas</a>.
         * </p>
         * 
         * @param queueConfigs
         *        The inbound queues associated with the routing profile. If no queue is added, the agent can make only
         *        outbound calls.</p>
         *        <p>
         *        The limit of 10 array members applies to the maximum number of <code>RoutingProfileQueueConfig</code>
         *        objects that can be passed during a CreateRoutingProfile API request. It is different from the quota
         *        of 50 queues per routing profile per instance that is listed in <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
         *        Connect service quotas</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfigs(Collection<RoutingProfileQueueConfig> queueConfigs);

        /**
         * <p>
         * The inbound queues associated with the routing profile. If no queue is added, the agent can make only
         * outbound calls.
         * </p>
         * <p>
         * The limit of 10 array members applies to the maximum number of <code>RoutingProfileQueueConfig</code> objects
         * that can be passed during a CreateRoutingProfile API request. It is different from the quota of 50 queues per
         * routing profile per instance that is listed in <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
         * Connect service quotas</a>.
         * </p>
         * 
         * @param queueConfigs
         *        The inbound queues associated with the routing profile. If no queue is added, the agent can make only
         *        outbound calls.</p>
         *        <p>
         *        The limit of 10 array members applies to the maximum number of <code>RoutingProfileQueueConfig</code>
         *        objects that can be passed during a CreateRoutingProfile API request. It is different from the quota
         *        of 50 queues per routing profile per instance that is listed in <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
         *        Connect service quotas</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfigs(RoutingProfileQueueConfig... queueConfigs);

        /**
         * <p>
         * The inbound queues associated with the routing profile. If no queue is added, the agent can make only
         * outbound calls.
         * </p>
         * <p>
         * The limit of 10 array members applies to the maximum number of <code>RoutingProfileQueueConfig</code> objects
         * that can be passed during a CreateRoutingProfile API request. It is different from the quota of 50 queues per
         * routing profile per instance that is listed in <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
         * Connect service quotas</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #queueConfigs(List<RoutingProfileQueueConfig>)}.
         * 
         * @param queueConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueConfigs(java.util.Collection<RoutingProfileQueueConfig>)
         */
        Builder queueConfigs(Consumer<RoutingProfileQueueConfig.Builder>... queueConfigs);

        /**
         * <p>
         * The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * </p>
         * 
         * @param mediaConcurrencies
         *        The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies);

        /**
         * <p>
         * The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * </p>
         * 
         * @param mediaConcurrencies
         *        The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConcurrencies(MediaConcurrency... mediaConcurrencies);

        /**
         * <p>
         * The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.MediaConcurrency.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.MediaConcurrency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.MediaConcurrency.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaConcurrencies(List<MediaConcurrency>)}.
         * 
         * @param mediaConcurrencies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.MediaConcurrency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConcurrencies(java.util.Collection<MediaConcurrency>)
         */
        Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder>... mediaConcurrencies);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "Tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "Tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Whether agents with this routing profile will have their routing order calculated based on <i>longest idle
         * time</i> or <i>time since their last inbound contact</i>.
         * </p>
         * 
         * @param agentAvailabilityTimer
         *        Whether agents with this routing profile will have their routing order calculated based on <i>longest
         *        idle time</i> or <i>time since their last inbound contact</i>.
         * @see AgentAvailabilityTimer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentAvailabilityTimer
         */
        Builder agentAvailabilityTimer(String agentAvailabilityTimer);

        /**
         * <p>
         * Whether agents with this routing profile will have their routing order calculated based on <i>longest idle
         * time</i> or <i>time since their last inbound contact</i>.
         * </p>
         * 
         * @param agentAvailabilityTimer
         *        Whether agents with this routing profile will have their routing order calculated based on <i>longest
         *        idle time</i> or <i>time since their last inbound contact</i>.
         * @see AgentAvailabilityTimer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentAvailabilityTimer
         */
        Builder agentAvailabilityTimer(AgentAvailabilityTimer agentAvailabilityTimer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String name;

        private String description;

        private String defaultOutboundQueueId;

        private List<RoutingProfileQueueConfig> queueConfigs = DefaultSdkAutoConstructList.getInstance();

        private List<MediaConcurrency> mediaConcurrencies = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String agentAvailabilityTimer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoutingProfileRequest model) {
            super(model);
            instanceId(model.instanceId);
            name(model.name);
            description(model.description);
            defaultOutboundQueueId(model.defaultOutboundQueueId);
            queueConfigs(model.queueConfigs);
            mediaConcurrencies(model.mediaConcurrencies);
            tags(model.tags);
            agentAvailabilityTimer(model.agentAvailabilityTimer);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultOutboundQueueId() {
            return defaultOutboundQueueId;
        }

        public final void setDefaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
        }

        @Override
        public final Builder defaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
            return this;
        }

        public final List<RoutingProfileQueueConfig.Builder> getQueueConfigs() {
            List<RoutingProfileQueueConfig.Builder> result = RoutingProfileQueueConfigListCopier.copyToBuilder(this.queueConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueueConfigs(Collection<RoutingProfileQueueConfig.BuilderImpl> queueConfigs) {
            this.queueConfigs = RoutingProfileQueueConfigListCopier.copyFromBuilder(queueConfigs);
        }

        @Override
        public final Builder queueConfigs(Collection<RoutingProfileQueueConfig> queueConfigs) {
            this.queueConfigs = RoutingProfileQueueConfigListCopier.copy(queueConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigs(RoutingProfileQueueConfig... queueConfigs) {
            queueConfigs(Arrays.asList(queueConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigs(Consumer<RoutingProfileQueueConfig.Builder>... queueConfigs) {
            queueConfigs(Stream.of(queueConfigs).map(c -> RoutingProfileQueueConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<MediaConcurrency.Builder> getMediaConcurrencies() {
            List<MediaConcurrency.Builder> result = MediaConcurrenciesCopier.copyToBuilder(this.mediaConcurrencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaConcurrencies(Collection<MediaConcurrency.BuilderImpl> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copyFromBuilder(mediaConcurrencies);
        }

        @Override
        public final Builder mediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copy(mediaConcurrencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(MediaConcurrency... mediaConcurrencies) {
            mediaConcurrencies(Arrays.asList(mediaConcurrencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder>... mediaConcurrencies) {
            mediaConcurrencies(Stream.of(mediaConcurrencies).map(c -> MediaConcurrency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getAgentAvailabilityTimer() {
            return agentAvailabilityTimer;
        }

        public final void setAgentAvailabilityTimer(String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
        }

        @Override
        public final Builder agentAvailabilityTimer(String agentAvailabilityTimer) {
            this.agentAvailabilityTimer = agentAvailabilityTimer;
            return this;
        }

        @Override
        public final Builder agentAvailabilityTimer(AgentAvailabilityTimer agentAvailabilityTimer) {
            this.agentAvailabilityTimer(agentAvailabilityTimer == null ? null : agentAvailabilityTimer.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRoutingProfileRequest build() {
            return new CreateRoutingProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
