/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVocabularyResponse extends ConnectResponse implements
        ToCopyableBuilder<DeleteVocabularyResponse.Builder, DeleteVocabularyResponse> {
    private static final SdkField<String> VOCABULARY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyArn").getter(getter(DeleteVocabularyResponse::vocabularyArn))
            .setter(setter(Builder::vocabularyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyArn").build()).build();

    private static final SdkField<String> VOCABULARY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VocabularyId").getter(getter(DeleteVocabularyResponse::vocabularyId))
            .setter(setter(Builder::vocabularyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DeleteVocabularyResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_ARN_FIELD,
            VOCABULARY_ID_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String vocabularyArn;

    private final String vocabularyId;

    private final String state;

    private DeleteVocabularyResponse(BuilderImpl builder) {
        super(builder);
        this.vocabularyArn = builder.vocabularyArn;
        this.vocabularyId = builder.vocabularyId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom vocabulary.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom vocabulary.
     */
    public final String vocabularyArn() {
        return vocabularyArn;
    }

    /**
     * <p>
     * The identifier of the custom vocabulary.
     * </p>
     * 
     * @return The identifier of the custom vocabulary.
     */
    public final String vocabularyId() {
        return vocabularyId;
    }

    /**
     * <p>
     * The current state of the custom vocabulary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the custom vocabulary.
     * @see VocabularyState
     */
    public final VocabularyState state() {
        return VocabularyState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the custom vocabulary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VocabularyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the custom vocabulary.
     * @see VocabularyState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyArn());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVocabularyResponse)) {
            return false;
        }
        DeleteVocabularyResponse other = (DeleteVocabularyResponse) obj;
        return Objects.equals(vocabularyArn(), other.vocabularyArn()) && Objects.equals(vocabularyId(), other.vocabularyId())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVocabularyResponse").add("VocabularyArn", vocabularyArn())
                .add("VocabularyId", vocabularyId()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VocabularyArn":
            return Optional.ofNullable(clazz.cast(vocabularyArn()));
        case "VocabularyId":
            return Optional.ofNullable(clazz.cast(vocabularyId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VocabularyArn", VOCABULARY_ARN_FIELD);
        map.put("VocabularyId", VOCABULARY_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVocabularyResponse, T> g) {
        return obj -> g.apply((DeleteVocabularyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVocabularyResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom vocabulary.
         * </p>
         * 
         * @param vocabularyArn
         *        The Amazon Resource Name (ARN) of the custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyArn(String vocabularyArn);

        /**
         * <p>
         * The identifier of the custom vocabulary.
         * </p>
         * 
         * @param vocabularyId
         *        The identifier of the custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyId(String vocabularyId);

        /**
         * <p>
         * The current state of the custom vocabulary.
         * </p>
         * 
         * @param state
         *        The current state of the custom vocabulary.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the custom vocabulary.
         * </p>
         * 
         * @param state
         *        The current state of the custom vocabulary.
         * @see VocabularyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VocabularyState
         */
        Builder state(VocabularyState state);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String vocabularyArn;

        private String vocabularyId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVocabularyResponse model) {
            super(model);
            vocabularyArn(model.vocabularyArn);
            vocabularyId(model.vocabularyId);
            state(model.state);
        }

        public final String getVocabularyArn() {
            return vocabularyArn;
        }

        public final void setVocabularyArn(String vocabularyArn) {
            this.vocabularyArn = vocabularyArn;
        }

        @Override
        public final Builder vocabularyArn(String vocabularyArn) {
            this.vocabularyArn = vocabularyArn;
            return this;
        }

        public final String getVocabularyId() {
            return vocabularyId;
        }

        public final void setVocabularyId(String vocabularyId) {
            this.vocabularyId = vocabularyId;
        }

        @Override
        public final Builder vocabularyId(String vocabularyId) {
            this.vocabularyId = vocabularyId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VocabularyState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public DeleteVocabularyResponse build() {
            return new DeleteVocabularyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
