/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about output answers for a contact evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationAnswerOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationAnswerOutput.Builder, EvaluationAnswerOutput> {
    private static final SdkField<EvaluationAnswerData> VALUE_FIELD = SdkField
            .<EvaluationAnswerData> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(EvaluationAnswerOutput::value)).setter(setter(Builder::value))
            .constructor(EvaluationAnswerData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<EvaluationAnswerData> SYSTEM_SUGGESTED_VALUE_FIELD = SdkField
            .<EvaluationAnswerData> builder(MarshallingType.SDK_POJO).memberName("SystemSuggestedValue")
            .getter(getter(EvaluationAnswerOutput::systemSuggestedValue)).setter(setter(Builder::systemSuggestedValue))
            .constructor(EvaluationAnswerData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemSuggestedValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD,
            SYSTEM_SUGGESTED_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationAnswerData value;

    private final EvaluationAnswerData systemSuggestedValue;

    private EvaluationAnswerOutput(BuilderImpl builder) {
        this.value = builder.value;
        this.systemSuggestedValue = builder.systemSuggestedValue;
    }

    /**
     * <p>
     * The value for an answer in a contact evaluation.
     * </p>
     * 
     * @return The value for an answer in a contact evaluation.
     */
    public final EvaluationAnswerData value() {
        return value;
    }

    /**
     * <p>
     * The system suggested value for an answer in a contact evaluation.
     * </p>
     * 
     * @return The system suggested value for an answer in a contact evaluation.
     */
    public final EvaluationAnswerData systemSuggestedValue() {
        return systemSuggestedValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(systemSuggestedValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationAnswerOutput)) {
            return false;
        }
        EvaluationAnswerOutput other = (EvaluationAnswerOutput) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(systemSuggestedValue(), other.systemSuggestedValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationAnswerOutput").add("Value", value())
                .add("SystemSuggestedValue", systemSuggestedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "SystemSuggestedValue":
            return Optional.ofNullable(clazz.cast(systemSuggestedValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("SystemSuggestedValue", SYSTEM_SUGGESTED_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationAnswerOutput, T> g) {
        return obj -> g.apply((EvaluationAnswerOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationAnswerOutput> {
        /**
         * <p>
         * The value for an answer in a contact evaluation.
         * </p>
         * 
         * @param value
         *        The value for an answer in a contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(EvaluationAnswerData value);

        /**
         * <p>
         * The value for an answer in a contact evaluation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationAnswerData.Builder} avoiding
         * the need to create one manually via {@link EvaluationAnswerData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationAnswerData.Builder#build()} is called immediately and
         * its result is passed to {@link #value(EvaluationAnswerData)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link EvaluationAnswerData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(EvaluationAnswerData)
         */
        default Builder value(Consumer<EvaluationAnswerData.Builder> value) {
            return value(EvaluationAnswerData.builder().applyMutation(value).build());
        }

        /**
         * <p>
         * The system suggested value for an answer in a contact evaluation.
         * </p>
         * 
         * @param systemSuggestedValue
         *        The system suggested value for an answer in a contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemSuggestedValue(EvaluationAnswerData systemSuggestedValue);

        /**
         * <p>
         * The system suggested value for an answer in a contact evaluation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationAnswerData.Builder} avoiding
         * the need to create one manually via {@link EvaluationAnswerData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationAnswerData.Builder#build()} is called immediately and
         * its result is passed to {@link #systemSuggestedValue(EvaluationAnswerData)}.
         * 
         * @param systemSuggestedValue
         *        a consumer that will call methods on {@link EvaluationAnswerData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #systemSuggestedValue(EvaluationAnswerData)
         */
        default Builder systemSuggestedValue(Consumer<EvaluationAnswerData.Builder> systemSuggestedValue) {
            return systemSuggestedValue(EvaluationAnswerData.builder().applyMutation(systemSuggestedValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EvaluationAnswerData value;

        private EvaluationAnswerData systemSuggestedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationAnswerOutput model) {
            value(model.value);
            systemSuggestedValue(model.systemSuggestedValue);
        }

        public final EvaluationAnswerData.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(EvaluationAnswerData.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(EvaluationAnswerData value) {
            this.value = value;
            return this;
        }

        public final EvaluationAnswerData.Builder getSystemSuggestedValue() {
            return systemSuggestedValue != null ? systemSuggestedValue.toBuilder() : null;
        }

        public final void setSystemSuggestedValue(EvaluationAnswerData.BuilderImpl systemSuggestedValue) {
            this.systemSuggestedValue = systemSuggestedValue != null ? systemSuggestedValue.build() : null;
        }

        @Override
        public final Builder systemSuggestedValue(EvaluationAnswerData systemSuggestedValue) {
            this.systemSuggestedValue = systemSuggestedValue;
            return this;
        }

        @Override
        public EvaluationAnswerOutput build() {
            return new EvaluationAnswerOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
