/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata information about a contact evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationMetadata.Builder, EvaluationMetadata> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(EvaluationMetadata::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluatorArn").getter(getter(EvaluationMetadata::evaluatorArn)).setter(setter(Builder::evaluatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatorArn").build()).build();

    private static final SdkField<String> CONTACT_AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactAgentId").getter(getter(EvaluationMetadata::contactAgentId))
            .setter(setter(Builder::contactAgentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactAgentId").build()).build();

    private static final SdkField<EvaluationScore> SCORE_FIELD = SdkField.<EvaluationScore> builder(MarshallingType.SDK_POJO)
            .memberName("Score").getter(getter(EvaluationMetadata::score)).setter(setter(Builder::score))
            .constructor(EvaluationScore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            EVALUATOR_ARN_FIELD, CONTACT_AGENT_ID_FIELD, SCORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactId;

    private final String evaluatorArn;

    private final String contactAgentId;

    private final EvaluationScore score;

    private EvaluationMetadata(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.evaluatorArn = builder.evaluatorArn;
        this.contactAgentId = builder.contactAgentId;
        this.score = builder.score;
    }

    /**
     * <p>
     * The identifier of the contact in this instance of Amazon Connect.
     * </p>
     * 
     * @return The identifier of the contact in this instance of Amazon Connect.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who last updated the evaluation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who last updated the evaluation.
     */
    public final String evaluatorArn() {
        return evaluatorArn;
    }

    /**
     * <p>
     * The identifier of the agent who performed the contact.
     * </p>
     * 
     * @return The identifier of the agent who performed the contact.
     */
    public final String contactAgentId() {
        return contactAgentId;
    }

    /**
     * <p>
     * The overall score of the contact evaluation.
     * </p>
     * 
     * @return The overall score of the contact evaluation.
     */
    public final EvaluationScore score() {
        return score;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(contactAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationMetadata)) {
            return false;
        }
        EvaluationMetadata other = (EvaluationMetadata) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(evaluatorArn(), other.evaluatorArn())
                && Objects.equals(contactAgentId(), other.contactAgentId()) && Objects.equals(score(), other.score());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationMetadata").add("ContactId", contactId()).add("EvaluatorArn", evaluatorArn())
                .add("ContactAgentId", contactAgentId()).add("Score", score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "EvaluatorArn":
            return Optional.ofNullable(clazz.cast(evaluatorArn()));
        case "ContactAgentId":
            return Optional.ofNullable(clazz.cast(contactAgentId()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("EvaluatorArn", EVALUATOR_ARN_FIELD);
        map.put("ContactAgentId", CONTACT_AGENT_ID_FIELD);
        map.put("Score", SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationMetadata, T> g) {
        return obj -> g.apply((EvaluationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationMetadata> {
        /**
         * <p>
         * The identifier of the contact in this instance of Amazon Connect.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact in this instance of Amazon Connect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who last updated the evaluation.
         * </p>
         * 
         * @param evaluatorArn
         *        The Amazon Resource Name (ARN) of the user who last updated the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluatorArn(String evaluatorArn);

        /**
         * <p>
         * The identifier of the agent who performed the contact.
         * </p>
         * 
         * @param contactAgentId
         *        The identifier of the agent who performed the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactAgentId(String contactAgentId);

        /**
         * <p>
         * The overall score of the contact evaluation.
         * </p>
         * 
         * @param score
         *        The overall score of the contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(EvaluationScore score);

        /**
         * <p>
         * The overall score of the contact evaluation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationScore.Builder} avoiding the
         * need to create one manually via {@link EvaluationScore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationScore.Builder#build()} is called immediately and its
         * result is passed to {@link #score(EvaluationScore)}.
         * 
         * @param score
         *        a consumer that will call methods on {@link EvaluationScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #score(EvaluationScore)
         */
        default Builder score(Consumer<EvaluationScore.Builder> score) {
            return score(EvaluationScore.builder().applyMutation(score).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String contactId;

        private String evaluatorArn;

        private String contactAgentId;

        private EvaluationScore score;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationMetadata model) {
            contactId(model.contactId);
            evaluatorArn(model.evaluatorArn);
            contactAgentId(model.contactAgentId);
            score(model.score);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getEvaluatorArn() {
            return evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public final String getContactAgentId() {
            return contactAgentId;
        }

        public final void setContactAgentId(String contactAgentId) {
            this.contactAgentId = contactAgentId;
        }

        @Override
        public final Builder contactAgentId(String contactAgentId) {
            this.contactAgentId = contactAgentId;
            return this;
        }

        public final EvaluationScore.Builder getScore() {
            return score != null ? score.toBuilder() : null;
        }

        public final void setScore(EvaluationScore.BuilderImpl score) {
            this.score = score != null ? score.build() : null;
        }

        @Override
        public final Builder score(EvaluationScore score) {
            this.score = score;
            return this;
        }

        @Override
        public EvaluationMetadata build() {
            return new EvaluationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
