/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEffectiveHoursOfOperationsRequest extends ConnectRequest implements
        ToCopyableBuilder<GetEffectiveHoursOfOperationsRequest.Builder, GetEffectiveHoursOfOperationsRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GetEffectiveHoursOfOperationsRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationId").getter(getter(GetEffectiveHoursOfOperationsRequest::hoursOfOperationId))
            .setter(setter(Builder::hoursOfOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("HoursOfOperationId").build()).build();

    private static final SdkField<String> FROM_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FromDate").getter(getter(GetEffectiveHoursOfOperationsRequest::fromDate))
            .setter(setter(Builder::fromDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fromDate").build()).build();

    private static final SdkField<String> TO_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ToDate")
            .getter(getter(GetEffectiveHoursOfOperationsRequest::toDate)).setter(setter(Builder::toDate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("toDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            HOURS_OF_OPERATION_ID_FIELD, FROM_DATE_FIELD, TO_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final String hoursOfOperationId;

    private final String fromDate;

    private final String toDate;

    private GetEffectiveHoursOfOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.fromDate = builder.fromDate;
        this.toDate = builder.toDate;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier for the hours of operation.
     * </p>
     * 
     * @return The identifier for the hours of operation.
     */
    public final String hoursOfOperationId() {
        return hoursOfOperationId;
    }

    /**
     * <p>
     * The date from when the hours of operation are listed.
     * </p>
     * 
     * @return The date from when the hours of operation are listed.
     */
    public final String fromDate() {
        return fromDate;
    }

    /**
     * <p>
     * The date until when the hours of operation are listed.
     * </p>
     * 
     * @return The date until when the hours of operation are listed.
     */
    public final String toDate() {
        return toDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(fromDate());
        hashCode = 31 * hashCode + Objects.hashCode(toDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEffectiveHoursOfOperationsRequest)) {
            return false;
        }
        GetEffectiveHoursOfOperationsRequest other = (GetEffectiveHoursOfOperationsRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(hoursOfOperationId(), other.hoursOfOperationId())
                && Objects.equals(fromDate(), other.fromDate()) && Objects.equals(toDate(), other.toDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEffectiveHoursOfOperationsRequest").add("InstanceId", instanceId())
                .add("HoursOfOperationId", hoursOfOperationId()).add("FromDate", fromDate()).add("ToDate", toDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "HoursOfOperationId":
            return Optional.ofNullable(clazz.cast(hoursOfOperationId()));
        case "FromDate":
            return Optional.ofNullable(clazz.cast(fromDate()));
        case "ToDate":
            return Optional.ofNullable(clazz.cast(toDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("HoursOfOperationId", HOURS_OF_OPERATION_ID_FIELD);
        map.put("fromDate", FROM_DATE_FIELD);
        map.put("toDate", TO_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEffectiveHoursOfOperationsRequest, T> g) {
        return obj -> g.apply((GetEffectiveHoursOfOperationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEffectiveHoursOfOperationsRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier for the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationId
         *        The identifier for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationId(String hoursOfOperationId);

        /**
         * <p>
         * The date from when the hours of operation are listed.
         * </p>
         * 
         * @param fromDate
         *        The date from when the hours of operation are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDate(String fromDate);

        /**
         * <p>
         * The date until when the hours of operation are listed.
         * </p>
         * 
         * @param toDate
         *        The date until when the hours of operation are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toDate(String toDate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String hoursOfOperationId;

        private String fromDate;

        private String toDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEffectiveHoursOfOperationsRequest model) {
            super(model);
            instanceId(model.instanceId);
            hoursOfOperationId(model.hoursOfOperationId);
            fromDate(model.fromDate);
            toDate(model.toDate);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getHoursOfOperationId() {
            return hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final String getFromDate() {
            return fromDate;
        }

        public final void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        @Override
        public final Builder fromDate(String fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        public final String getToDate() {
            return toDate;
        }

        public final void setToDate(String toDate) {
            this.toDate = toDate;
        }

        @Override
        public final Builder toDate(String toDate) {
            this.toDate = toDate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEffectiveHoursOfOperationsRequest build() {
            return new GetEffectiveHoursOfOperationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
