/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the hours of operations override.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HoursOfOperationOverride implements SdkPojo, Serializable,
        ToCopyableBuilder<HoursOfOperationOverride.Builder, HoursOfOperationOverride> {
    private static final SdkField<String> HOURS_OF_OPERATION_OVERRIDE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationOverrideId")
            .getter(getter(HoursOfOperationOverride::hoursOfOperationOverrideId))
            .setter(setter(Builder::hoursOfOperationOverrideId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationOverrideId").build())
            .build();

    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationId").getter(getter(HoursOfOperationOverride::hoursOfOperationId))
            .setter(setter(Builder::hoursOfOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationId").build())
            .build();

    private static final SdkField<String> HOURS_OF_OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationArn").getter(getter(HoursOfOperationOverride::hoursOfOperationArn))
            .setter(setter(Builder::hoursOfOperationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(HoursOfOperationOverride::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(HoursOfOperationOverride::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<HoursOfOperationOverrideConfig>> CONFIG_FIELD = SdkField
            .<List<HoursOfOperationOverrideConfig>> builder(MarshallingType.LIST)
            .memberName("Config")
            .getter(getter(HoursOfOperationOverride::config))
            .setter(setter(Builder::config))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HoursOfOperationOverrideConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(HoursOfOperationOverrideConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EFFECTIVE_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveFrom").getter(getter(HoursOfOperationOverride::effectiveFrom))
            .setter(setter(Builder::effectiveFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveFrom").build()).build();

    private static final SdkField<String> EFFECTIVE_TILL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveTill").getter(getter(HoursOfOperationOverride::effectiveTill))
            .setter(setter(Builder::effectiveTill))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveTill").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HOURS_OF_OPERATION_OVERRIDE_ID_FIELD, HOURS_OF_OPERATION_ID_FIELD, HOURS_OF_OPERATION_ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CONFIG_FIELD, EFFECTIVE_FROM_FIELD, EFFECTIVE_TILL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hoursOfOperationOverrideId;

    private final String hoursOfOperationId;

    private final String hoursOfOperationArn;

    private final String name;

    private final String description;

    private final List<HoursOfOperationOverrideConfig> config;

    private final String effectiveFrom;

    private final String effectiveTill;

    private HoursOfOperationOverride(BuilderImpl builder) {
        this.hoursOfOperationOverrideId = builder.hoursOfOperationOverrideId;
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.hoursOfOperationArn = builder.hoursOfOperationArn;
        this.name = builder.name;
        this.description = builder.description;
        this.config = builder.config;
        this.effectiveFrom = builder.effectiveFrom;
        this.effectiveTill = builder.effectiveTill;
    }

    /**
     * <p>
     * The identifier for the hours of operation override.
     * </p>
     * 
     * @return The identifier for the hours of operation override.
     */
    public final String hoursOfOperationOverrideId() {
        return hoursOfOperationOverrideId;
    }

    /**
     * <p>
     * The identifier for the hours of operation.
     * </p>
     * 
     * @return The identifier for the hours of operation.
     */
    public final String hoursOfOperationId() {
        return hoursOfOperationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the hours of operation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the hours of operation.
     */
    public final String hoursOfOperationArn() {
        return hoursOfOperationArn;
    }

    /**
     * <p>
     * The name of the hours of operation override.
     * </p>
     * 
     * @return The name of the hours of operation override.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the hours of operation override.
     * </p>
     * 
     * @return The description of the hours of operation override.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Config property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConfig() {
        return config != null && !(config instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information for the hours of operation override: day, start time, and end time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfig} method.
     * </p>
     * 
     * @return Configuration information for the hours of operation override: day, start time, and end time.
     */
    public final List<HoursOfOperationOverrideConfig> config() {
        return config;
    }

    /**
     * <p>
     * The date from which the hours of operation override would be effective.
     * </p>
     * 
     * @return The date from which the hours of operation override would be effective.
     */
    public final String effectiveFrom() {
        return effectiveFrom;
    }

    /**
     * <p>
     * The date till which the hours of operation override would be effective.
     * </p>
     * 
     * @return The date till which the hours of operation override would be effective.
     */
    public final String effectiveTill() {
        return effectiveTill;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationOverrideId());
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfig() ? config() : null);
        hashCode = 31 * hashCode + Objects.hashCode(effectiveFrom());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveTill());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoursOfOperationOverride)) {
            return false;
        }
        HoursOfOperationOverride other = (HoursOfOperationOverride) obj;
        return Objects.equals(hoursOfOperationOverrideId(), other.hoursOfOperationOverrideId())
                && Objects.equals(hoursOfOperationId(), other.hoursOfOperationId())
                && Objects.equals(hoursOfOperationArn(), other.hoursOfOperationArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasConfig() == other.hasConfig()
                && Objects.equals(config(), other.config()) && Objects.equals(effectiveFrom(), other.effectiveFrom())
                && Objects.equals(effectiveTill(), other.effectiveTill());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HoursOfOperationOverride").add("HoursOfOperationOverrideId", hoursOfOperationOverrideId())
                .add("HoursOfOperationId", hoursOfOperationId()).add("HoursOfOperationArn", hoursOfOperationArn())
                .add("Name", name()).add("Description", description()).add("Config", hasConfig() ? config() : null)
                .add("EffectiveFrom", effectiveFrom()).add("EffectiveTill", effectiveTill()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HoursOfOperationOverrideId":
            return Optional.ofNullable(clazz.cast(hoursOfOperationOverrideId()));
        case "HoursOfOperationId":
            return Optional.ofNullable(clazz.cast(hoursOfOperationId()));
        case "HoursOfOperationArn":
            return Optional.ofNullable(clazz.cast(hoursOfOperationArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        case "EffectiveFrom":
            return Optional.ofNullable(clazz.cast(effectiveFrom()));
        case "EffectiveTill":
            return Optional.ofNullable(clazz.cast(effectiveTill()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HoursOfOperationOverrideId", HOURS_OF_OPERATION_OVERRIDE_ID_FIELD);
        map.put("HoursOfOperationId", HOURS_OF_OPERATION_ID_FIELD);
        map.put("HoursOfOperationArn", HOURS_OF_OPERATION_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Config", CONFIG_FIELD);
        map.put("EffectiveFrom", EFFECTIVE_FROM_FIELD);
        map.put("EffectiveTill", EFFECTIVE_TILL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HoursOfOperationOverride, T> g) {
        return obj -> g.apply((HoursOfOperationOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HoursOfOperationOverride> {
        /**
         * <p>
         * The identifier for the hours of operation override.
         * </p>
         * 
         * @param hoursOfOperationOverrideId
         *        The identifier for the hours of operation override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationOverrideId(String hoursOfOperationOverrideId);

        /**
         * <p>
         * The identifier for the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationId
         *        The identifier for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationId(String hoursOfOperationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationArn
         *        The Amazon Resource Name (ARN) for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationArn(String hoursOfOperationArn);

        /**
         * <p>
         * The name of the hours of operation override.
         * </p>
         * 
         * @param name
         *        The name of the hours of operation override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the hours of operation override.
         * </p>
         * 
         * @param description
         *        The description of the hours of operation override.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Configuration information for the hours of operation override: day, start time, and end time.
         * </p>
         * 
         * @param config
         *        Configuration information for the hours of operation override: day, start time, and end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(Collection<HoursOfOperationOverrideConfig> config);

        /**
         * <p>
         * Configuration information for the hours of operation override: day, start time, and end time.
         * </p>
         * 
         * @param config
         *        Configuration information for the hours of operation override: day, start time, and end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(HoursOfOperationOverrideConfig... config);

        /**
         * <p>
         * Configuration information for the hours of operation override: day, start time, and end time.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationOverrideConfig.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationOverrideConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationOverrideConfig.Builder#build()} is
         * called immediately and its result is passed to {@link #config(List<HoursOfOperationOverrideConfig>)}.
         * 
         * @param config
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.HoursOfOperationOverrideConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(java.util.Collection<HoursOfOperationOverrideConfig>)
         */
        Builder config(Consumer<HoursOfOperationOverrideConfig.Builder>... config);

        /**
         * <p>
         * The date from which the hours of operation override would be effective.
         * </p>
         * 
         * @param effectiveFrom
         *        The date from which the hours of operation override would be effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveFrom(String effectiveFrom);

        /**
         * <p>
         * The date till which the hours of operation override would be effective.
         * </p>
         * 
         * @param effectiveTill
         *        The date till which the hours of operation override would be effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveTill(String effectiveTill);
    }

    static final class BuilderImpl implements Builder {
        private String hoursOfOperationOverrideId;

        private String hoursOfOperationId;

        private String hoursOfOperationArn;

        private String name;

        private String description;

        private List<HoursOfOperationOverrideConfig> config = DefaultSdkAutoConstructList.getInstance();

        private String effectiveFrom;

        private String effectiveTill;

        private BuilderImpl() {
        }

        private BuilderImpl(HoursOfOperationOverride model) {
            hoursOfOperationOverrideId(model.hoursOfOperationOverrideId);
            hoursOfOperationId(model.hoursOfOperationId);
            hoursOfOperationArn(model.hoursOfOperationArn);
            name(model.name);
            description(model.description);
            config(model.config);
            effectiveFrom(model.effectiveFrom);
            effectiveTill(model.effectiveTill);
        }

        public final String getHoursOfOperationOverrideId() {
            return hoursOfOperationOverrideId;
        }

        public final void setHoursOfOperationOverrideId(String hoursOfOperationOverrideId) {
            this.hoursOfOperationOverrideId = hoursOfOperationOverrideId;
        }

        @Override
        public final Builder hoursOfOperationOverrideId(String hoursOfOperationOverrideId) {
            this.hoursOfOperationOverrideId = hoursOfOperationOverrideId;
            return this;
        }

        public final String getHoursOfOperationId() {
            return hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final String getHoursOfOperationArn() {
            return hoursOfOperationArn;
        }

        public final void setHoursOfOperationArn(String hoursOfOperationArn) {
            this.hoursOfOperationArn = hoursOfOperationArn;
        }

        @Override
        public final Builder hoursOfOperationArn(String hoursOfOperationArn) {
            this.hoursOfOperationArn = hoursOfOperationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<HoursOfOperationOverrideConfig.Builder> getConfig() {
            List<HoursOfOperationOverrideConfig.Builder> result = HoursOfOperationOverrideConfigListCopier
                    .copyToBuilder(this.config);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfig(Collection<HoursOfOperationOverrideConfig.BuilderImpl> config) {
            this.config = HoursOfOperationOverrideConfigListCopier.copyFromBuilder(config);
        }

        @Override
        public final Builder config(Collection<HoursOfOperationOverrideConfig> config) {
            this.config = HoursOfOperationOverrideConfigListCopier.copy(config);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder config(HoursOfOperationOverrideConfig... config) {
            config(Arrays.asList(config));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder config(Consumer<HoursOfOperationOverrideConfig.Builder>... config) {
            config(Stream.of(config).map(c -> HoursOfOperationOverrideConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getEffectiveFrom() {
            return effectiveFrom;
        }

        public final void setEffectiveFrom(String effectiveFrom) {
            this.effectiveFrom = effectiveFrom;
        }

        @Override
        public final Builder effectiveFrom(String effectiveFrom) {
            this.effectiveFrom = effectiveFrom;
            return this;
        }

        public final String getEffectiveTill() {
            return effectiveTill;
        }

        public final void setEffectiveTill(String effectiveTill) {
            this.effectiveTill = effectiveTill;
        }

        @Override
        public final Builder effectiveTill(String effectiveTill) {
            this.effectiveTill = effectiveTill;
            return this;
        }

        @Override
        public HoursOfOperationOverride build() {
            return new HoursOfOperationOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
