/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the raw email body content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InboundRawMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<InboundRawMessage.Builder, InboundRawMessage> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(InboundRawMessage::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(InboundRawMessage::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(InboundRawMessage::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Headers")
            .getter(getter(InboundRawMessage::headersAsStrings))
            .setter(setter(Builder::headersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Headers").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, BODY_FIELD,
            CONTENT_TYPE_FIELD, HEADERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String subject;

    private final String body;

    private final String contentType;

    private final Map<String, String> headers;

    private InboundRawMessage(BuilderImpl builder) {
        this.subject = builder.subject;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.headers = builder.headers;
    }

    /**
     * <p>
     * The email subject.
     * </p>
     * 
     * @return The email subject.
     */
    public final String subject() {
        return subject;
    }

    /**
     * <p>
     * The email message body.
     * </p>
     * 
     * @return The email message body.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * Type of content, that is, <code>text/plain</code> or <code>text/html</code>.
     * </p>
     * 
     * @return Type of content, that is, <code>text/plain</code> or <code>text/html</code>.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Headers present in inbound email.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return Headers present in inbound email.
     */
    public final Map<EmailHeaderType, String> headers() {
        return EmailHeadersCopier.copyStringToEnum(headers);
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Headers present in inbound email.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return Headers present in inbound email.
     */
    public final Map<String, String> headersAsStrings() {
        return headers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headersAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundRawMessage)) {
            return false;
        }
        InboundRawMessage other = (InboundRawMessage) obj;
        return Objects.equals(subject(), other.subject()) && Objects.equals(body(), other.body())
                && Objects.equals(contentType(), other.contentType()) && hasHeaders() == other.hasHeaders()
                && Objects.equals(headersAsStrings(), other.headersAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InboundRawMessage").add("Subject", subject() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Body", body() == null ? null : "*** Sensitive Data Redacted ***").add("ContentType", contentType())
                .add("Headers", hasHeaders() ? headersAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "Headers":
            return Optional.ofNullable(clazz.cast(headersAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Subject", SUBJECT_FIELD);
        map.put("Body", BODY_FIELD);
        map.put("ContentType", CONTENT_TYPE_FIELD);
        map.put("Headers", HEADERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InboundRawMessage, T> g) {
        return obj -> g.apply((InboundRawMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InboundRawMessage> {
        /**
         * <p>
         * The email subject.
         * </p>
         * 
         * @param subject
         *        The email subject.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The email message body.
         * </p>
         * 
         * @param body
         *        The email message body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * Type of content, that is, <code>text/plain</code> or <code>text/html</code>.
         * </p>
         * 
         * @param contentType
         *        Type of content, that is, <code>text/plain</code> or <code>text/html</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Headers present in inbound email.
         * </p>
         * 
         * @param headers
         *        Headers present in inbound email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersWithStrings(Map<String, String> headers);

        /**
         * <p>
         * Headers present in inbound email.
         * </p>
         * 
         * @param headers
         *        Headers present in inbound email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Map<EmailHeaderType, String> headers);
    }

    static final class BuilderImpl implements Builder {
        private String subject;

        private String body;

        private String contentType;

        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InboundRawMessage model) {
            subject(model.subject);
            body(model.body);
            contentType(model.contentType);
            headersWithStrings(model.headers);
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Map<String, String> getHeaders() {
            if (headers instanceof SdkAutoConstructMap) {
                return null;
            }
            return headers;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = EmailHeadersCopier.copy(headers);
        }

        @Override
        public final Builder headersWithStrings(Map<String, String> headers) {
            this.headers = EmailHeadersCopier.copy(headers);
            return this;
        }

        @Override
        public final Builder headers(Map<EmailHeaderType, String> headers) {
            this.headers = EmailHeadersCopier.copyEnumToString(headers);
            return this;
        }

        @Override
        public InboundRawMessage build() {
            return new InboundRawMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
